/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query;

import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.query.input.AnonymousStream;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.Stream;
import org.wso2.siddhi.query.api.query.output.OutputRate;
import org.wso2.siddhi.query.api.query.output.stream.DeleteStream;
import org.wso2.siddhi.query.api.query.output.stream.InsertIntoStream;
import org.wso2.siddhi.query.api.query.output.stream.OutStream;
import org.wso2.siddhi.query.api.query.output.stream.UpdateStream;
import org.wso2.siddhi.query.api.query.selection.Selector;

public class Query
implements ExecutionPlan {
    private Stream inputStream;
    private Selector selector = new Selector();
    private OutStream outStream;
    private String partitionId;
    private OutputRate outputRate;

    public Query from(Stream stream) {
        this.inputStream = stream;
        return this;
    }

    public Query select(Selector selector) {
        this.selector = selector;
        return this;
    }

    public Query outStream(OutStream outStream) {
        this.outStream = outStream;
        return this;
    }

    public Query insertInto(String outputStreamId, OutStream.OutputEventsFor outputEventsFor) {
        this.outStream = new InsertIntoStream(outputStreamId, outputEventsFor);
        return this;
    }

    public Query insertInto(String outputStreamId) {
        this.outStream = new InsertIntoStream(outputStreamId);
        return this;
    }

    public void partitionBy(String partitionId) {
        this.partitionId = partitionId;
    }

    public BasicStream returnStream() {
        return new AnonymousStream(this);
    }

    public void deleteBy(String outputTableId, Condition deletingCondition) {
        this.outStream = new DeleteStream(outputTableId, deletingCondition);
    }

    public void deleteBy(String outputTableId, OutStream.OutputEventsFor outputEventsFor, Condition deletingCondition) {
        this.outStream = new DeleteStream(outputTableId, outputEventsFor, deletingCondition);
    }

    public void updateBy(String outputTableId, Condition deletingCondition) {
        this.outStream = new UpdateStream(outputTableId, deletingCondition);
    }

    public void updateBy(String outputTableId, OutStream.OutputEventsFor outputEventsFor, Condition updatingCondition) {
        this.outStream = new UpdateStream(outputTableId, outputEventsFor, updatingCondition);
    }

    public void output(OutputRate outputRate) {
        this.outputRate = outputRate;
    }

    public Stream getInputStream() {
        return this.inputStream;
    }

    public OutStream getOutputStream() {
        return this.outStream;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public OutputRate getOutputRate() {
        return this.outputRate;
    }
}

