/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.exception.SourceNotExistException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.query.QueryEventSource;
import org.wso2.siddhi.query.api.query.input.FilteredStream;
import org.wso2.siddhi.query.api.query.input.TransformedStream;
import org.wso2.siddhi.query.api.query.input.WindowStream;
import org.wso2.siddhi.query.api.query.input.handler.Filter;
import org.wso2.siddhi.query.api.query.input.handler.Transformer;
import org.wso2.siddhi.query.api.query.input.handler.Window;

public class BasicStream
implements FilteredStream {
    protected String streamId;
    protected AbstractDefinition definition;
    protected String streamReferenceId;
    protected Filter filter = null;
    protected Transformer transformer = null;
    protected boolean isCounterStream = false;
    protected QueryEventSource queryEventSource = null;

    protected BasicStream(String streamId, String streamReferenceId, Filter filter) {
        this.streamId = streamId;
        this.streamReferenceId = streamReferenceId;
        this.filter = filter;
    }

    protected BasicStream(String streamId) {
        this(streamId, streamId);
    }

    public BasicStream(String streamReferenceId, String streamId) {
        this.streamId = streamId;
        this.streamReferenceId = streamReferenceId;
    }

    public AbstractDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(AbstractDefinition definition) {
        this.definition = definition;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String getStreamReferenceId() {
        return this.streamReferenceId;
    }

    @Override
    public BasicStream setStreamReferenceId(String streamReferenceId) {
        this.streamReferenceId = streamReferenceId;
        return this;
    }

    @Override
    public List<String> getStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.streamId);
        return list;
    }

    @Override
    public void setCounterStream(boolean counterStream) {
        this.isCounterStream = counterStream;
    }

    @Override
    public List<QueryEventSource> constructQueryEventSourceList(ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, List<QueryEventSource> queryEventSources) {
        this.definition = (AbstractDefinition)streamTableDefinitionMap.get(this.streamId);
        if (this.definition == null) {
            throw new SourceNotExistException("Definition not exist! No stream/table defined with stream ID: " + this.streamId);
        }
        if (this.definition instanceof TableDefinition && (this.filter != null || this.transformer != null)) {
            throw new SourceNotExistException(this.streamId + " is not a Stream but a Table, and it cant have filter or transformer");
        }
        this.queryEventSource = new QueryEventSource(this.streamId, this.streamReferenceId, this.definition, this.filter, this.transformer, null);
        this.queryEventSource.setCounterStream(this.isCounterStream);
        queryEventSources.add(this.queryEventSource);
        return queryEventSources;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public QueryEventSource getQueryEventSource() {
        return this.queryEventSource;
    }

    public FilteredStream filter(Condition filterCondition) {
        this.filter = new Filter(filterCondition);
        return this;
    }

    public FilteredStream setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public WindowStream window(String name, Expression ... parameters) {
        return new WindowStream(this, new Window(name, parameters));
    }

    @Override
    public WindowStream window(String namespace, String function, Expression ... parameters) {
        return new WindowStream(this, new Window(namespace, function, parameters));
    }

    @Override
    public WindowStream window(Window window) {
        return new WindowStream(this, window);
    }

    @Override
    public TransformedStream transform(String name, Expression ... parameters) {
        this.transformer = new Transformer(name, parameters);
        return this;
    }

    @Override
    public TransformedStream transform(String extensionName, String functionName, Expression ... parameters) {
        this.transformer = new Transformer(extensionName, functionName, parameters);
        return this;
    }

    @Override
    public TransformedStream setTransformer(Transformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

