/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.exception.SourceNotExistException;
import org.wso2.siddhi.query.api.query.QueryEventSource;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.SingleStream;
import org.wso2.siddhi.query.api.query.input.handler.Filter;
import org.wso2.siddhi.query.api.query.input.handler.Transformer;
import org.wso2.siddhi.query.api.query.input.handler.Window;

public class WindowStream
implements SingleStream {
    protected String streamId;
    protected StreamDefinition streamDefinition;
    protected String streamReferenceId;
    protected Filter filter = null;
    protected Window window = null;
    protected Transformer transformer = null;
    protected QueryEventSource queryEventSource = null;

    public WindowStream(BasicStream basicStream, Window window) {
        this.streamId = basicStream.getStreamId();
        this.streamDefinition = (StreamDefinition)basicStream.getDefinition();
        this.streamReferenceId = basicStream.getStreamReferenceId();
        this.filter = basicStream.getFilter();
        this.transformer = basicStream.getTransformer();
        this.window = window;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public void setStreamDefinition(StreamDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String getStreamReferenceId() {
        return this.streamReferenceId;
    }

    @Override
    public WindowStream setStreamReferenceId(String streamReferenceId) {
        this.streamReferenceId = streamReferenceId;
        return this;
    }

    @Override
    public List<String> getStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.streamId);
        return list;
    }

    @Override
    public List<QueryEventSource> constructQueryEventSourceList(ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, List<QueryEventSource> queryEventSources) {
        AbstractDefinition definition = (AbstractDefinition)streamTableDefinitionMap.get(this.streamId);
        if (definition == null) {
            throw new SourceNotExistException("Stream definition not exist! No steam defined with stream ID: " + this.streamId);
        }
        if (definition instanceof TableDefinition) {
            throw new SourceNotExistException(this.streamId + " is not a Stream but a Table, and it cant have window");
        }
        this.streamDefinition = (StreamDefinition)definition;
        this.queryEventSource = new QueryEventSource(this.streamId, this.streamReferenceId, this.streamDefinition, this.filter, this.transformer, this.window);
        queryEventSources.add(this.queryEventSource);
        return queryEventSources;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public QueryEventSource getQueryEventSource() {
        return this.queryEventSource;
    }

    public Window getWindow() {
        return this.window;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

