/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input.pattern;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.query.QueryEventSource;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.Stream;
import org.wso2.siddhi.query.api.query.input.pattern.element.CountElement;
import org.wso2.siddhi.query.api.query.input.pattern.element.FollowedByElement;
import org.wso2.siddhi.query.api.query.input.pattern.element.LogicalElement;
import org.wso2.siddhi.query.api.query.input.pattern.element.PatternElement;

public class PatternStream
implements Stream,
PatternElement {
    private PatternElement patternElement;
    private List<String> streamIdList;
    private Constant within;

    public PatternStream(PatternElement patternElement, Constant within) {
        this.patternElement = patternElement;
        this.streamIdList = new ArrayList<String>(this.collectStreamIds(patternElement, new HashSet<String>()));
        this.within = within;
    }

    @Override
    public List<String> getStreamIds() {
        return this.streamIdList;
    }

    @Override
    public List<QueryEventSource> constructQueryEventSourceList(ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, List<QueryEventSource> queryEventSources) {
        return this.constructEventStreamList(this.patternElement, streamTableDefinitionMap, queryEventSources);
    }

    public Constant getWithin() {
        return this.within;
    }

    public PatternElement getPatternElement() {
        return this.patternElement;
    }

    private HashSet<String> collectStreamIds(PatternElement patternElement, HashSet<String> streamIds) {
        if (patternElement instanceof PatternStream) {
            streamIds.addAll(((PatternStream)patternElement).getStreamIds());
        } else if (patternElement instanceof BasicStream) {
            streamIds.addAll(((BasicStream)patternElement).getStreamIds());
        } else if (patternElement instanceof LogicalElement) {
            this.collectStreamIds(((LogicalElement)patternElement).getTransformedStream1(), streamIds);
            this.collectStreamIds(((LogicalElement)patternElement).getTransformedStream2(), streamIds);
        } else if (patternElement instanceof CountElement) {
            this.collectStreamIds(((CountElement)patternElement).getTransformedStream(), streamIds);
        } else if (patternElement instanceof FollowedByElement) {
            this.collectStreamIds(((FollowedByElement)patternElement).getPatternElement(), streamIds);
            this.collectStreamIds(((FollowedByElement)patternElement).getFollowedByPatternElement(), streamIds);
        }
        return streamIds;
    }

    public List<QueryEventSource> constructEventStreamList(PatternElement patternElement, ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, List<QueryEventSource> queryEventSources) {
        if (patternElement instanceof BasicStream) {
            ((BasicStream)patternElement).constructQueryEventSourceList(streamTableDefinitionMap, queryEventSources);
        } else if (patternElement instanceof LogicalElement) {
            this.constructEventStreamList(((LogicalElement)patternElement).getTransformedStream1(), streamTableDefinitionMap, queryEventSources);
            this.constructEventStreamList(((LogicalElement)patternElement).getTransformedStream2(), streamTableDefinitionMap, queryEventSources);
        } else if (patternElement instanceof CountElement) {
            this.constructEventStreamList(((CountElement)patternElement).getTransformedStream(), streamTableDefinitionMap, queryEventSources);
        } else if (patternElement instanceof FollowedByElement) {
            this.constructEventStreamList(((FollowedByElement)patternElement).getPatternElement(), streamTableDefinitionMap, queryEventSources);
            this.constructEventStreamList(((FollowedByElement)patternElement).getFollowedByPatternElement(), streamTableDefinitionMap, queryEventSources);
        } else if (patternElement instanceof PatternStream) {
            ((PatternStream)patternElement).constructQueryEventSourceList(streamTableDefinitionMap, queryEventSources);
        }
        return queryEventSources;
    }
}

