/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input.sequence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.query.QueryEventSource;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.Stream;
import org.wso2.siddhi.query.api.query.input.sequence.element.NextElement;
import org.wso2.siddhi.query.api.query.input.sequence.element.OrElement;
import org.wso2.siddhi.query.api.query.input.sequence.element.RegexElement;
import org.wso2.siddhi.query.api.query.input.sequence.element.SequenceElement;

public class SequenceStream
implements Stream,
SequenceElement {
    private SequenceElement sequenceElement;
    private List<String> streamIdList;
    private Constant within;

    public SequenceStream(SequenceElement sequenceElement, Constant within) {
        this.sequenceElement = sequenceElement;
        this.streamIdList = new ArrayList<String>(this.collectStreamIds(sequenceElement, new HashSet<String>()));
        this.within = within;
    }

    public SequenceElement getSequenceElement() {
        return this.sequenceElement;
    }

    @Override
    public List<String> getStreamIds() {
        return this.streamIdList;
    }

    @Override
    public List<QueryEventSource> constructQueryEventSourceList(ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, List<QueryEventSource> queryEventSources) {
        return this.constructEventStreamList(this.getSequenceElement(), streamTableDefinitionMap, queryEventSources);
    }

    private HashSet<String> collectStreamIds(SequenceElement sequenceElement, HashSet<String> streamIds) {
        if (sequenceElement instanceof SequenceStream) {
            streamIds.addAll(((SequenceStream)sequenceElement).getStreamIds());
        } else if (sequenceElement instanceof BasicStream) {
            streamIds.addAll(((BasicStream)sequenceElement).getStreamIds());
        } else if (sequenceElement instanceof OrElement) {
            this.collectStreamIds(((OrElement)sequenceElement).getTransformedStream1(), streamIds);
            this.collectStreamIds(((OrElement)sequenceElement).getTransformedStream2(), streamIds);
        } else if (sequenceElement instanceof RegexElement) {
            this.collectStreamIds(((RegexElement)sequenceElement).getTransformedStream(), streamIds);
        } else if (sequenceElement instanceof NextElement) {
            this.collectStreamIds(((NextElement)sequenceElement).getSequenceElement(), streamIds);
            this.collectStreamIds(((NextElement)sequenceElement).getNextSequenceElement(), streamIds);
        }
        return streamIds;
    }

    public List<QueryEventSource> constructEventStreamList(SequenceElement sequenceElement, ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, List<QueryEventSource> queryEventSources) {
        if (sequenceElement instanceof BasicStream) {
            ((BasicStream)sequenceElement).constructQueryEventSourceList(streamTableDefinitionMap, queryEventSources);
        } else if (sequenceElement instanceof OrElement) {
            this.constructEventStreamList(((OrElement)sequenceElement).getTransformedStream1(), streamTableDefinitionMap, queryEventSources);
            this.constructEventStreamList(((OrElement)sequenceElement).getTransformedStream2(), streamTableDefinitionMap, queryEventSources);
        } else if (sequenceElement instanceof RegexElement) {
            this.constructEventStreamList(((RegexElement)sequenceElement).getTransformedStream(), streamTableDefinitionMap, queryEventSources);
        } else if (sequenceElement instanceof NextElement) {
            this.constructEventStreamList(((NextElement)sequenceElement).getSequenceElement(), streamTableDefinitionMap, queryEventSources);
            this.constructEventStreamList(((NextElement)sequenceElement).getNextSequenceElement(), streamTableDefinitionMap, queryEventSources);
        } else if (sequenceElement instanceof SequenceStream) {
            ((SequenceStream)sequenceElement).constructQueryEventSourceList(streamTableDefinitionMap, queryEventSources);
        }
        return queryEventSources;
    }

    public Constant getWithin() {
        return this.within;
    }
}

