/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.exception.AttributeAlreadyExistException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.query.selection.attribute.ComplexAttribute;
import org.wso2.siddhi.query.api.query.selection.attribute.OutputAttribute;
import org.wso2.siddhi.query.api.query.selection.attribute.OutputAttributeExtension;
import org.wso2.siddhi.query.api.query.selection.attribute.SimpleAttribute;

public class Selector {
    private List<OutputAttribute> selectionList = new ArrayList<OutputAttribute>();
    private List<Variable> groupByList = new ArrayList<Variable>();
    private Condition havingCondition;

    public Selector select(String rename, Expression expression) {
        SimpleAttribute outputAttribute = new SimpleAttribute(rename, expression);
        this.checkSelection(outputAttribute);
        this.selectionList.add(outputAttribute);
        return this;
    }

    private void checkSelection(OutputAttribute newAttribute) {
        for (OutputAttribute attribute : this.selectionList) {
            if (!attribute.getRename().equals(newAttribute.getRename())) continue;
            throw new AttributeAlreadyExistException(attribute.getRename() + " is already defined as an output attribute ");
        }
    }

    public Selector select(String rename, String attributeName, Expression ... expressions) {
        ComplexAttribute outputAttribute = new ComplexAttribute(rename, attributeName, expressions);
        this.checkSelection(outputAttribute);
        this.selectionList.add(outputAttribute);
        return this;
    }

    public Selector select(String rename, String extensionNamespace, String extensionFunctionName, Expression ... expressions) {
        OutputAttributeExtension outputAttribute = new OutputAttributeExtension(rename, extensionNamespace, extensionFunctionName, expressions);
        this.checkSelection(outputAttribute);
        this.selectionList.add(outputAttribute);
        return this;
    }

    public Selector having(Condition condition) {
        this.havingCondition = condition;
        return this;
    }

    public Selector groupBy(String streamId, String attributeName) {
        this.groupByList.add(new Variable(streamId, attributeName));
        return this;
    }

    public Selector groupBy(String attributeName) {
        this.groupByList.add(new Variable(attributeName));
        return this;
    }

    public Selector addGroupByList(List<Variable> list) {
        if (list != null) {
            this.groupByList.addAll(list);
        }
        return this;
    }

    public List<OutputAttribute> getSelectionList() {
        return this.selectionList;
    }

    public List<Variable> getGroupByList() {
        return this.groupByList;
    }

    public Condition getHavingCondition() {
        return this.havingCondition;
    }

    public Selector addSelectionList(List<OutputAttribute> projectionList) {
        for (OutputAttribute outputAttribute : projectionList) {
            this.checkSelection(outputAttribute);
            this.selectionList.add(outputAttribute);
        }
        return this;
    }

    public Set<String> getDependencySet() {
        HashSet<String> dependencySet = new HashSet<String>();
        for (OutputAttribute outputAttribute : this.selectionList) {
            dependencySet.addAll(outputAttribute.getDependencySet());
        }
        return dependencySet;
    }
}

