/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.wso2.siddhi.doc.gen.core.utils.DocumentationUtils;

@Mojo(name="generate-extensions-index", defaultPhase=LifecyclePhase.INSTALL)
public class ExtensionsIndexGenerationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="extension.repository.owner", defaultValue="wso2-extensions")
    private String extensionRepositoryOwner;
    @Parameter(property="extension.repositories")
    private List<String> extensionRepositories;
    @Parameter(property="doc.gen.base.directory")
    private File docGenBaseDirectory;
    @Parameter(property="index.gen.file.name")
    private String indexGenFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.extensionRepositories == null || this.extensionRepositories.size() == 0) {
            throw new MojoExecutionException("extensionRepositories configuration is required to use goal generate-extensions-index");
        }
        if (this.extensionRepositoryOwner == null) {
            this.extensionRepositoryOwner = "wso2-extensions";
        }
        String docGenPath = this.docGenBaseDirectory != null ? this.docGenBaseDirectory.getAbsolutePath() : this.mavenProject.getParent().getBasedir() + File.separator + "docs";
        if (this.indexGenFileName == null) {
            this.indexGenFileName = "extensions";
        }
        DocumentationUtils.createExtensionsIndex(this.extensionRepositories, this.extensionRepositoryOwner, docGenPath, this.indexGenFileName);
    }
}

