/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core.utils;

import com.google.common.io.Files;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.SystemParameter;
import org.wso2.siddhi.doc.gen.commons.metadata.ExampleMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ExtensionMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ExtensionType;
import org.wso2.siddhi.doc.gen.commons.metadata.NamespaceMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ParameterMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ReturnAttributeMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.SystemParameterMetaData;
import org.wso2.siddhi.doc.gen.core.freemarker.FormatDescriptionMethod;
import org.wso2.siddhi.doc.gen.core.utils.Constants;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class DocumentationUtils {
    private DocumentationUtils() {
    }

    public static List<NamespaceMetaData> getExtensionMetaData(String targetDirectoryPath, List<String> runtimeClasspathElements, Log logger) throws MojoFailureException, MojoExecutionException {
        ArrayList<NamespaceMetaData> namespaceMetaDataList = new ArrayList<NamespaceMetaData>();
        int urlCount = runtimeClasspathElements.size() + 1;
        URL[] urls = new URL[urlCount];
        for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
            try {
                urls[i] = new File(runtimeClasspathElements.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException("Unable to access project dependency: " + runtimeClasspathElements.get(i), (Throwable)e);
            }
        }
        File classesDirectory = new File(targetDirectoryPath + File.separator + "classes");
        try {
            urls[urlCount - 1] = classesDirectory.toURI().toURL();
            ClassLoader urlClassLoader = AccessController.doPrivileged(() -> new URLClassLoader(urls, Thread.currentThread().getContextClassLoader()));
            DocumentationUtils.addExtensionInDirectory(classesDirectory, classesDirectory.getAbsolutePath(), urlClassLoader, namespaceMetaDataList, logger);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid classes directory: " + classesDirectory.getAbsolutePath(), (Exception)e);
        }
        return namespaceMetaDataList;
    }

    public static void generateDocumentation(List<NamespaceMetaData> namespaceMetaDataList, String documentationBaseDirectory, String documentationVersion, Log logger) throws MojoFailureException {
        HashMap<String, Object> rootDataModel = new HashMap<String, Object>();
        rootDataModel.put("metaData", namespaceMetaDataList);
        rootDataModel.put("formatDescription", new FormatDescriptionMethod());
        String outputFileRelativePath = "api" + File.separator + documentationVersion + ".md";
        DocumentationUtils.generateFileFromTemplate("documentation.md.ftl", rootDataModel, documentationBaseDirectory, outputFileRelativePath, logger);
    }

    public static void updateHomePage(File readMeFile, String documentationBaseDirectory, String homePageFileName, File mkdocsConfigFile, Log logger) throws MojoFailureException {
        List readMeFileLines = new ArrayList();
        try {
            readMeFileLines = Files.readLines((File)readMeFile, (Charset)Constants.DEFAULT_CHARSET);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File documentationDirectory = new File(documentationBaseDirectory + File.separator + "api");
        String[] documentationFiles = documentationDirectory.list();
        ArrayList<String> documentationFilesList = new ArrayList<String>();
        if (documentationFiles != null) {
            for (String documentationFile : documentationFiles) {
                if (!documentationFile.endsWith(".md")) continue;
                documentationFilesList.add(documentationFile);
            }
        }
        HashMap rootDataModel = new HashMap();
        rootDataModel.put("readMeFileLines", readMeFileLines);
        rootDataModel.put("documentationFiles", documentationFilesList);
        DocumentationUtils.generateFileFromTemplate("index.md.ftl", rootDataModel, documentationBaseDirectory, homePageFileName + ".md", logger);
        try {
            DocumentationUtils.updateAPIPagesInMkdocsConfig(mkdocsConfigFile, documentationFilesList);
        }
        catch (FileNotFoundException e) {
            logger.warn((CharSequence)("Unable to find mkdocs configuration file: " + mkdocsConfigFile.getAbsolutePath() + ". Mkdocs configuration file not updated."));
        }
    }

    private static void updateAPIPagesInMkdocsConfig(File mkdocsConfigFile, List<String> apiDirectoryContent) throws FileNotFoundException {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        Map yamlConfig = (Map)yaml.load((Reader)new InputStreamReader((InputStream)new FileInputStream(mkdocsConfigFile), Constants.DEFAULT_CHARSET));
        List yamlConfigPagesList = (List)yamlConfig.get("pages");
        ArrayList apiPagesList = new ArrayList();
        for (String apiFile : apiDirectoryContent) {
            String pageName = apiFile.substring(0, apiFile.length() - ".md".length());
            HashMap<String, String> newPage = new HashMap<String, String>();
            newPage.put(pageName, "api/" + apiFile);
            apiPagesList.add(newPage);
        }
        Map yamlConfigAPIPage = null;
        for (Map yamlConfigPage : yamlConfigPagesList) {
            if (yamlConfigPage.get("API Docs") == null) continue;
            yamlConfigAPIPage = yamlConfigPage;
            break;
        }
        if (yamlConfigAPIPage == null) {
            yamlConfigAPIPage = new HashMap();
            yamlConfigPagesList.add(yamlConfigAPIPage);
        }
        yamlConfigAPIPage.put("API Docs", apiPagesList);
        yaml.dump((Object)yamlConfig, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(mkdocsConfigFile), Constants.DEFAULT_CHARSET));
    }

    public static void createExtensionsIndex(List<String> extensionRepositories, String extensionRepositoryOwner, String documentationBaseDirectory, String extensionsIndexFileName, Log logger) throws MojoFailureException {
        ArrayList<String> gplExtensionRepositories = new ArrayList<String>();
        ArrayList<String> apacheExtensionRepositories = new ArrayList<String>();
        for (String extensionRepository : extensionRepositories) {
            if (extensionRepository.startsWith("siddhi-gpl-")) {
                gplExtensionRepositories.add(extensionRepository);
                continue;
            }
            if (!extensionRepository.startsWith("siddhi-")) continue;
            apacheExtensionRepositories.add(extensionRepository);
        }
        HashMap<String, Object> rootDataModel = new HashMap<String, Object>();
        rootDataModel.put("extensionsOwner", extensionRepositoryOwner);
        rootDataModel.put("gplExtensionRepositories", gplExtensionRepositories);
        rootDataModel.put("apacheExtensionRepositories", apacheExtensionRepositories);
        DocumentationUtils.generateFileFromTemplate("extensions.md.ftl", rootDataModel, documentationBaseDirectory, extensionsIndexFileName + ".md", logger);
    }

    public static void deployMkdocsOnGitHubPages(File mkdocsConfigFile, Log logger) {
        try {
            DocumentationUtils.executeCommand(new String[]{"mkdocs", "gh-deploy", "--config-file", mkdocsConfigFile.getAbsolutePath()}, logger);
        }
        catch (Throwable t) {
            logger.warn((CharSequence)"Failed to execute mkdocs gh-deploy. Skipping deployment of documentation.", t);
        }
    }

    public static void updateDocumentationOnGitHub(String docsDirectory, File mkdocsConfigFile, String version, Log logger) {
        try {
            DocumentationUtils.executeCommand(new String[]{"git", "add", docsDirectory}, logger);
            DocumentationUtils.executeCommand(new String[]{"git", "commit", "-m", String.format("[WSO2-Release] [Release %s] update documentation for release %s", version, version), "--", docsDirectory, mkdocsConfigFile.getAbsolutePath()}, logger);
            DocumentationUtils.executeCommand(new String[]{"git", "push", "origin", "master"}, logger);
        }
        catch (Throwable t) {
            logger.warn((CharSequence)"Failed to update the documentation on GitHub repository", t);
        }
    }

    private static void addExtensionInDirectory(File moduleTargetClassesDirectory, String classesDirectoryPath, ClassLoader urlClassLoader, List<NamespaceMetaData> namespaceMetaDataList, Log logger) {
        File[] innerFiles = moduleTargetClassesDirectory.listFiles();
        if (innerFiles != null) {
            for (File innerFile : innerFiles) {
                if (innerFile.isDirectory()) {
                    DocumentationUtils.addExtensionInDirectory(innerFile, classesDirectoryPath, urlClassLoader, namespaceMetaDataList, logger);
                    continue;
                }
                DocumentationUtils.addExtensionInFile(innerFile, classesDirectoryPath, urlClassLoader, namespaceMetaDataList, logger);
            }
        }
    }

    private static void addExtensionInFile(File file, String classesDirectoryPath, ClassLoader urlClassLoader, List<NamespaceMetaData> namespaceMetaDataList, Log logger) {
        String filePath = file.getAbsolutePath();
        if (filePath.endsWith(".class") && filePath.length() > classesDirectoryPath.length()) {
            String relativePathToClass = filePath.substring((classesDirectoryPath + File.separator).length());
            try {
                Class<?> extensionClass = Class.forName(relativePathToClass.substring(0, relativePathToClass.length() - ".class".length()).replace(File.separator, "."), false, urlClassLoader);
                DocumentationUtils.addExtensionMetaDataIntoNamespaceList(namespaceMetaDataList, extensionClass, logger);
            }
            catch (ClassNotFoundException ignored) {
                logger.warn((CharSequence)("Ignoring the failed class loading from " + file.getAbsolutePath()));
            }
        }
    }

    private static void addExtensionMetaDataIntoNamespaceList(List<NamespaceMetaData> namespaceList, Class<?> extensionClass, Log logger) {
        Extension extensionAnnotation = extensionClass.getAnnotation(Extension.class);
        if (extensionAnnotation != null) {
            ExtensionMetaData extensionMetaData = new ExtensionMetaData();
            String extensionType = null;
            for (Map.Entry<ExtensionType, Class<?>> entry : ExtensionType.getSuperClassMap().entrySet()) {
                Class<?> superClass = entry.getValue();
                if (!superClass.isAssignableFrom(extensionClass) || superClass == extensionClass) continue;
                extensionType = entry.getKey().getValue();
                break;
            }
            if (extensionType == null) {
                logger.warn((CharSequence)("Discarding extension (belonging to an unknown extension type): " + extensionClass.getCanonicalName()));
                return;
            }
            extensionMetaData.setName(extensionAnnotation.name());
            extensionMetaData.setDescription(extensionAnnotation.description());
            ParameterMetaData[] parameters = new ParameterMetaData[extensionAnnotation.parameters().length];
            for (int i = 0; i < extensionAnnotation.parameters().length; ++i) {
                Parameter parameterAnnotation = extensionAnnotation.parameters()[i];
                ParameterMetaData parameter = new ParameterMetaData();
                parameter.setName(parameterAnnotation.name());
                parameter.setType(Arrays.asList(parameterAnnotation.type()));
                parameter.setDescription(parameterAnnotation.description());
                parameter.setOptional(parameterAnnotation.optional());
                parameter.setDynamic(parameterAnnotation.dynamic());
                parameter.setDefaultValue(parameterAnnotation.defaultValue());
                parameters[i] = parameter;
            }
            extensionMetaData.setParameters(Arrays.asList(parameters));
            SystemParameterMetaData[] systemParameters = new SystemParameterMetaData[extensionAnnotation.systemParameter().length];
            for (int i = 0; i < extensionAnnotation.systemParameter().length; ++i) {
                SystemParameter systemParameterAnnotation = extensionAnnotation.systemParameter()[i];
                SystemParameterMetaData systemParameter = new SystemParameterMetaData();
                systemParameter.setName(systemParameterAnnotation.name());
                systemParameter.setDescription(systemParameterAnnotation.description());
                systemParameter.setDefaultValue(systemParameterAnnotation.defaultValue());
                systemParameter.setPossibleParameters(Arrays.asList(systemParameterAnnotation.possibleParameters()));
                systemParameters[i] = systemParameter;
            }
            extensionMetaData.setSystemParameters(Arrays.asList(systemParameters));
            ReturnAttributeMetaData[] returnAttributes = new ReturnAttributeMetaData[extensionAnnotation.returnAttributes().length];
            for (int i = 0; i < extensionAnnotation.returnAttributes().length; ++i) {
                ReturnAttribute parameterAnnotation = extensionAnnotation.returnAttributes()[i];
                ReturnAttributeMetaData returnAttribute = new ReturnAttributeMetaData();
                returnAttribute.setName(parameterAnnotation.name());
                returnAttribute.setType(Arrays.asList(parameterAnnotation.type()));
                returnAttribute.setDescription(parameterAnnotation.description());
                returnAttributes[i] = returnAttribute;
            }
            extensionMetaData.setReturnAttributes(Arrays.asList(returnAttributes));
            ExampleMetaData[] examples = new ExampleMetaData[extensionAnnotation.examples().length];
            for (int i = 0; i < extensionAnnotation.examples().length; ++i) {
                Example exampleAnnotation = extensionAnnotation.examples()[i];
                ExampleMetaData exampleMetaData = new ExampleMetaData();
                exampleMetaData.setSyntax(exampleAnnotation.syntax());
                exampleMetaData.setDescription(exampleAnnotation.description());
                examples[i] = exampleMetaData;
            }
            extensionMetaData.setExamples(Arrays.asList(examples));
            String namespaceName = extensionAnnotation.namespace();
            if (Objects.equals(namespaceName, "")) {
                namespaceName = "core";
            }
            NamespaceMetaData namespace = null;
            for (NamespaceMetaData existingNamespace : namespaceList) {
                if (!Objects.equals(existingNamespace.getName(), namespaceName)) continue;
                namespace = existingNamespace;
                break;
            }
            if (namespace == null) {
                namespace = new NamespaceMetaData();
                namespace.setName(namespaceName);
                namespace.setExtensionMap(new HashMap<String, List<ExtensionMetaData>>());
                namespaceList.add(namespace);
            }
            List extensionMetaDataList = namespace.getExtensionMap().computeIfAbsent(extensionType, k -> new ArrayList());
            extensionMetaDataList.add(extensionMetaData);
        }
    }

    private static void generateFileFromTemplate(String templateFile, Object dataModel, String outputDirectory, String outputFileName, Log logger) throws MojoFailureException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_25);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setClassForTemplateLoading(DocumentationUtils.class, File.separator + "templates");
        try {
            Template template = cfg.getTemplate(templateFile);
            File outputFile = new File(outputDirectory + File.separator + outputFileName);
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new MojoFailureException("Unable to create directory " + outputFile.getParentFile());
            }
            if (!outputFile.exists() && !outputFile.createNewFile()) {
                throw new MojoFailureException("Unable to create file " + outputFile.getAbsolutePath());
            }
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, Charset.defaultCharset());){
                template.process(dataModel, (Writer)writer);
            }
            catch (TemplateException e) {
                throw new MojoFailureException("Invalid Free Marker template found in " + templateFile, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find template file " + templateFile, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeCommand(String[] command, Log logger) throws Throwable {
        logger.info((CharSequence)("Executing: " + String.join((CharSequence)" ", command)));
        Process process = Runtime.getRuntime().exec(command);
        InputStream[] inputStreams = new InputStream[]{process.getInputStream(), process.getErrorStream()};
        BufferedReader bufferedReader = null;
        try {
            for (InputStream inputStream : inputStreams) {
                String commandOutput;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_CHARSET));
                while ((commandOutput = bufferedReader.readLine()) != null) {
                    logger.info((CharSequence)commandOutput);
                }
            }
            process.waitFor();
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
        }
    }
}

