/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.wso2.siddhi.doc.gen.commons.metadata.NamespaceMetaData;
import org.wso2.siddhi.doc.gen.core.utils.DocumentationUtils;

@Mojo(name="generate-md-docs", aggregator=true, defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.TEST)
public class MarkdownDocumentationGenerationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="module.target.directory")
    private File moduleTargetDirectory;
    @Parameter(property="home.page.template.file")
    private File homePageTemplateFile;
    @Parameter(property="mkdocs.config.file")
    private File mkdocsConfigFile;
    @Parameter(property="doc.gen.base.directory")
    private File docGenBaseDirectory;
    @Parameter(property="home.page.file.name")
    private String homePageFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<NamespaceMetaData> namespaceMetaDataList;
        MavenProject rootMavenProject = this.mavenProject;
        while (rootMavenProject.getParent().getBasedir() != null) {
            rootMavenProject = rootMavenProject.getParent();
        }
        String moduleTargetPath = this.moduleTargetDirectory != null ? this.moduleTargetDirectory.getAbsolutePath() : this.mavenProject.getBuild().getDirectory();
        String docGenPath = this.docGenBaseDirectory != null ? this.docGenBaseDirectory.getAbsolutePath() : rootMavenProject.getBasedir() + File.separator + "docs";
        if (this.homePageTemplateFile == null) {
            this.homePageTemplateFile = new File(rootMavenProject.getBasedir() + File.separator + "README" + ".md");
        }
        if (this.mkdocsConfigFile == null) {
            this.mkdocsConfigFile = new File(rootMavenProject.getBasedir() + File.separator + "mkdocs" + ".yml");
        }
        if (this.homePageFileName == null) {
            this.homePageFileName = "index";
        }
        try {
            namespaceMetaDataList = DocumentationUtils.getExtensionMetaData(moduleTargetPath, this.mavenProject.getRuntimeClasspathElements(), this.getLog());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("Unable to resolve dependencies of the project", (Throwable)e);
        }
        if (namespaceMetaDataList.size() > 0) {
            DocumentationUtils.generateDocumentation(namespaceMetaDataList, docGenPath, this.mavenProject.getVersion(), this.getLog());
            DocumentationUtils.updateHomePage(this.homePageTemplateFile, docGenPath, this.homePageFileName, this.mkdocsConfigFile, this.getLog());
        }
    }
}

