/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.wso2.siddhi.doc.gen.core.utils.DocumentationUtils;

@Mojo(name="deploy-mkdocs-github-pages", aggregator=true, defaultPhase=LifecyclePhase.INSTALL)
public class MkdocsGitHubPagesDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="mkdocs.config.file")
    private File mkdocsConfigFile;
    @Parameter(property="doc.gen.base.directory")
    private File docGenBaseDirectory;
    @Parameter(property="readme.file")
    private File readmeFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject rootMavenProject = this.mavenProject;
        while (rootMavenProject.getParent().getBasedir() != null) {
            rootMavenProject = rootMavenProject.getParent();
        }
        if (this.mkdocsConfigFile == null) {
            this.mkdocsConfigFile = new File(rootMavenProject.getBasedir() + File.separator + "mkdocs" + ".yml");
        }
        String docGenBasePath = this.docGenBaseDirectory != null ? this.docGenBaseDirectory.getAbsolutePath() : rootMavenProject.getBasedir() + File.separator + "docs";
        if (this.readmeFile == null) {
            this.readmeFile = new File(rootMavenProject.getBasedir() + File.separator + "README" + ".md");
        }
        DocumentationUtils.removeSnapshotAPIDocs(this.mkdocsConfigFile, docGenBasePath, this.getLog());
        DocumentationUtils.deployMkdocsOnGitHubPages(this.mkdocsConfigFile, this.mavenProject.getVersion(), this.getLog());
        DocumentationUtils.updateDocumentationOnGitHub(docGenBasePath, this.mkdocsConfigFile, this.readmeFile, this.mavenProject.getVersion(), this.getLog());
    }
}

