/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.wso2.siddhi.doc.gen.commons.metadata.NamespaceMetaData;
import org.wso2.siddhi.doc.gen.core.utils.DocumentationUtils;

@Mojo(name="generate-md-docs", aggregator=true, defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.TEST)
public class MarkdownDocumentationGenerationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="module.target.directory")
    private File moduleTargetDirectory;
    @Parameter(property="home.page.template.file")
    private File homePageTemplateFile;
    @Parameter(property="mkdocs.config.file")
    private File mkdocsConfigFile;
    @Parameter(property="doc.gen.base.directory")
    private File docGenBaseDirectory;
    @Parameter(property="home.page.file.name")
    private String homePageFileName;
    @Parameter(property="readme.file")
    private File readmeFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<NamespaceMetaData> namespaceMetaDataList;
        MavenProject rootMavenProject = this.mavenProject;
        while (rootMavenProject.getParent().getBasedir() != null) {
            rootMavenProject = rootMavenProject.getParent();
        }
        String moduleTargetPath = this.moduleTargetDirectory != null ? this.moduleTargetDirectory.getAbsolutePath() : this.mavenProject.getBuild().getDirectory();
        String docGenBasePath = this.docGenBaseDirectory != null ? this.docGenBaseDirectory.getAbsolutePath() : rootMavenProject.getBasedir() + File.separator + "docs";
        if (this.homePageTemplateFile == null) {
            this.homePageTemplateFile = new File(rootMavenProject.getBasedir() + File.separator + "README" + ".md");
        }
        if (this.mkdocsConfigFile == null) {
            this.mkdocsConfigFile = new File(rootMavenProject.getBasedir() + File.separator + "mkdocs" + ".yml");
        }
        File homePageFile = this.homePageFileName == null ? new File(docGenBasePath + File.separator + "index" + ".md") : new File(docGenBasePath + File.separator + this.homePageFileName);
        if (this.readmeFile == null) {
            this.readmeFile = new File(rootMavenProject.getBasedir() + File.separator + "README" + ".md");
        }
        try {
            namespaceMetaDataList = DocumentationUtils.getExtensionMetaData(moduleTargetPath, this.mavenProject.getRuntimeClasspathElements(), this.getLog());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("Unable to resolve dependencies of the project", (Throwable)e);
        }
        if (namespaceMetaDataList.size() > 0) {
            DocumentationUtils.generateDocumentation(namespaceMetaDataList, docGenBasePath, this.mavenProject.getVersion());
            DocumentationUtils.updateHeadingsInMarkdownFile(this.homePageTemplateFile, homePageFile, rootMavenProject.getArtifactId(), this.mavenProject.getVersion(), namespaceMetaDataList);
            DocumentationUtils.updateHeadingsInMarkdownFile(this.readmeFile, this.readmeFile, rootMavenProject.getArtifactId(), this.mavenProject.getVersion(), namespaceMetaDataList);
            try {
                DocumentationUtils.updateAPIPagesInMkdocsConfig(this.mkdocsConfigFile, docGenBasePath);
            }
            catch (FileNotFoundException e) {
                this.getLog().warn((CharSequence)("Unable to find mkdocs configuration file: " + this.mkdocsConfigFile.getAbsolutePath() + ". Mkdocs configuration file not updated."));
            }
        }
    }
}

