/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core.utils;

import com.google.common.io.Files;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.SystemParameter;
import org.wso2.siddhi.doc.gen.commons.metadata.ExampleMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ExtensionMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ExtensionType;
import org.wso2.siddhi.doc.gen.commons.metadata.NamespaceMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ParameterMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.ReturnAttributeMetaData;
import org.wso2.siddhi.doc.gen.commons.metadata.SystemParameterMetaData;
import org.wso2.siddhi.doc.gen.core.freemarker.FormatDescriptionMethod;
import org.wso2.siddhi.doc.gen.core.utils.Constants;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class DocumentationUtils {
    private DocumentationUtils() {
    }

    public static List<NamespaceMetaData> getExtensionMetaData(String targetDirectoryPath, List<String> runtimeClasspathElements, Log logger) throws MojoFailureException, MojoExecutionException {
        ArrayList<NamespaceMetaData> namespaceMetaDataList = new ArrayList<NamespaceMetaData>();
        int urlCount = runtimeClasspathElements.size() + 1;
        URL[] urls = new URL[urlCount];
        for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
            try {
                urls[i] = new File(runtimeClasspathElements.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException("Unable to access project dependency: " + runtimeClasspathElements.get(i), (Throwable)e);
            }
        }
        File classesDirectory = new File(targetDirectoryPath + File.separator + "classes");
        try {
            urls[urlCount - 1] = classesDirectory.toURI().toURL();
            ClassLoader urlClassLoader = AccessController.doPrivileged(() -> new URLClassLoader(urls, Thread.currentThread().getContextClassLoader()));
            DocumentationUtils.addExtensionInDirectory(classesDirectory, classesDirectory.getAbsolutePath(), urlClassLoader, namespaceMetaDataList, logger);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid classes directory: " + classesDirectory.getAbsolutePath(), (Exception)e);
        }
        for (NamespaceMetaData aNamespaceMetaData : namespaceMetaDataList) {
            for (List<ExtensionMetaData> extensionMetaData : aNamespaceMetaData.getExtensionMap().values()) {
                Collections.sort(extensionMetaData);
            }
        }
        Collections.sort(namespaceMetaDataList);
        return namespaceMetaDataList;
    }

    public static void generateDocumentation(List<NamespaceMetaData> namespaceMetaDataList, String documentationBaseDirectory, String documentationVersion, Log logger) throws MojoFailureException {
        HashMap<String, Object> rootDataModel = new HashMap<String, Object>();
        rootDataModel.put("metaData", namespaceMetaDataList);
        rootDataModel.put("formatDescription", new FormatDescriptionMethod());
        rootDataModel.put("latestDocumentationVersion", documentationVersion);
        String outputFileRelativePath = "api" + File.separator + documentationVersion + ".md";
        DocumentationUtils.generateFileFromTemplate("documentation.md.ftl", rootDataModel, documentationBaseDirectory, outputFileRelativePath);
        File newVersionFile = new File(documentationBaseDirectory + File.separator + outputFileRelativePath);
        File latestLabelFile = new File(documentationBaseDirectory + File.separator + "api" + File.separator + "latest" + ".md");
        try {
            Files.copy((File)newVersionFile, (File)latestLabelFile);
        }
        catch (IOException e) {
            logger.warn((CharSequence)"Failed to generate latest.md file", (Throwable)e);
        }
    }

    public static void updateHeadingsInMarkdownFile(File inputFile, File outputFile, String extensionRepositoryName, String latestDocumentationVersion, List<NamespaceMetaData> namespaceMetaDataList) throws MojoFailureException {
        List inputFileLines = new ArrayList();
        try {
            inputFileLines = Files.readLines((File)inputFile, (Charset)Constants.DEFAULT_CHARSET);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, Object> rootDataModel = new HashMap<String, Object>();
        rootDataModel.put("inputFileLines", inputFileLines);
        rootDataModel.put("extensionRepositoryName", extensionRepositoryName);
        rootDataModel.put("latestDocumentationVersion", latestDocumentationVersion);
        rootDataModel.put("metaData", namespaceMetaDataList);
        rootDataModel.put("formatDescription", new FormatDescriptionMethod());
        DocumentationUtils.generateFileFromTemplate("headings-update.md.ftl", rootDataModel, outputFile.getParent(), outputFile.getName());
    }

    public static void removeSnapshotAPIDocs(File mkdocsConfigFile, String documentationBaseDirectory, Log logger) {
        File apiDocsDirectory = new File(documentationBaseDirectory + File.separator + "api");
        String[] documentationFileNames = apiDocsDirectory.list((directory, fileName) -> fileName.endsWith(".md"));
        if (documentationFileNames != null) {
            for (String documentationFileName : documentationFileNames) {
                File documentationFile;
                if (!documentationFileName.endsWith("-SNAPSHOT.md") || (documentationFile = new File(apiDocsDirectory.getAbsolutePath() + File.separator + documentationFileName)).delete()) continue;
                logger.warn((CharSequence)("Failed to delete SNAPSHOT documentation file " + documentationFile.getAbsolutePath()));
            }
        }
    }

    public static void updateAPIPagesInMkdocsConfig(File mkdocsConfigFile, String documentationBaseDirectory) throws FileNotFoundException {
        List<String> apiDirectoryContent;
        File documentationDirectory = new File(documentationBaseDirectory + File.separator + "api");
        String[] documentationFiles = documentationDirectory.list((directory, fileName) -> fileName.endsWith(".md"));
        if (documentationFiles == null) {
            apiDirectoryContent = new ArrayList<String>();
        } else {
            apiDirectoryContent = Arrays.asList(documentationFiles);
            apiDirectoryContent.sort(new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    String[] s1s = s1.split("\\D+");
                    String[] s2s = s2.split("\\D+");
                    for (int i = 0; s1s.length > i || s2s.length > i; ++i) {
                        String s1a = "0";
                        String s2a = "0";
                        if (s1s.length > i) {
                            s1a = s1s[i];
                        }
                        if (s2s.length > i) {
                            s2a = s2s[i];
                        }
                        int s1aInt = Integer.parseInt(s1a);
                        int s2aInt = Integer.parseInt(s2a);
                        if (s2aInt > s1aInt) {
                            return 1;
                        }
                        if (s2aInt >= s1aInt) continue;
                        return -1;
                    }
                    return 0;
                }
            });
        }
        String latestVersionFile = null;
        if (apiDirectoryContent.size() > 1) {
            String first = apiDirectoryContent.get(0);
            String second = apiDirectoryContent.get(1);
            if (first.equals("latest.md")) {
                latestVersionFile = second;
            }
        }
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        Map yamlConfig = (Map)yaml.load((Reader)new InputStreamReader((InputStream)new FileInputStream(mkdocsConfigFile), Constants.DEFAULT_CHARSET));
        List yamlConfigPagesList = (List)yamlConfig.get("pages");
        ArrayList apiPagesList = new ArrayList();
        for (String apiFile : apiDirectoryContent) {
            String pageName = apiFile.substring(0, apiFile.length() - ".md".length());
            HashMap<String, String> newPage = new HashMap<String, String>();
            if (latestVersionFile != null && pageName.equals("latest")) {
                pageName = "Latest (" + latestVersionFile.substring(0, latestVersionFile.length() - ".md".length()) + ")";
            }
            newPage.put(pageName, "api/" + apiFile);
            apiPagesList.add(newPage);
        }
        Map yamlConfigAPIPage = null;
        for (Map yamlConfigPage : yamlConfigPagesList) {
            if (yamlConfigPage.get("API Docs") == null) continue;
            yamlConfigAPIPage = yamlConfigPage;
            break;
        }
        if (yamlConfigAPIPage == null) {
            yamlConfigAPIPage = new HashMap();
            yamlConfigPagesList.add(yamlConfigAPIPage);
        }
        yamlConfigAPIPage.put("API Docs", apiPagesList);
        yaml.dump((Object)yamlConfig, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(mkdocsConfigFile), Constants.DEFAULT_CHARSET));
    }

    public static void createExtensionsIndex(List<String> extensionRepositories, String extensionRepositoryOwner, String documentationBaseDirectory, String extensionsIndexFileName) throws MojoFailureException {
        ArrayList<String> gplExtensionRepositories = new ArrayList<String>();
        ArrayList<String> apacheExtensionRepositories = new ArrayList<String>();
        for (String extensionRepository : extensionRepositories) {
            if (extensionRepository.startsWith("siddhi-gpl-")) {
                gplExtensionRepositories.add(extensionRepository);
                continue;
            }
            if (!extensionRepository.startsWith("siddhi-")) continue;
            apacheExtensionRepositories.add(extensionRepository);
        }
        HashMap<String, Object> rootDataModel = new HashMap<String, Object>();
        rootDataModel.put("extensionsOwner", extensionRepositoryOwner);
        rootDataModel.put("gplExtensionRepositories", gplExtensionRepositories);
        rootDataModel.put("apacheExtensionRepositories", apacheExtensionRepositories);
        DocumentationUtils.generateFileFromTemplate("extensions.md.ftl", rootDataModel, documentationBaseDirectory, extensionsIndexFileName + ".md");
    }

    public static boolean generateMkdocsSite(File mkdocsConfigFile, Log logger) {
        boolean isDocumentationGenerationSuccessful = false;
        try {
            DocumentationUtils.executeCommand(new String[]{"mkdocs", "build", "-c", "-f", mkdocsConfigFile.getAbsolutePath(), "-d", "site"}, logger);
            isDocumentationGenerationSuccessful = true;
        }
        catch (Throwable t) {
            logger.warn((CharSequence)"Failed to generate the mkdocs site.", t);
        }
        return isDocumentationGenerationSuccessful;
    }

    public static void deployMkdocsOnGitHubPages(String version, File baseDirectory, String url, String scmUsername, String scmPassword, Log logger) {
        try {
            List<String> gitStatusOutput = DocumentationUtils.getCommandOutput(new String[]{"git", "branch"}, logger);
            String initialBranch = null;
            for (String gitStatusOutputLine : gitStatusOutput) {
                if (!gitStatusOutputLine.startsWith("* ")) continue;
                initialBranch = gitStatusOutputLine.substring("* ".length());
            }
            if (initialBranch != null) {
                DocumentationUtils.executeCommand(new String[]{"git", "stash"}, logger);
                DocumentationUtils.executeCommand(new String[]{"git", "checkout", "gh-pages"}, logger);
                DocumentationUtils.executeCommand(new String[]{"git", "checkout", "--orphan", "gh-pages"}, logger);
                DocumentationUtils.executeCommand(new String[]{"git", "pull", "origin", "gh-pages"}, logger);
                File siteDirectory = new File("site");
                FileUtils.copyDirectory((File)siteDirectory, (File)baseDirectory);
                String[] siteDirectoryContent = siteDirectory.list();
                if (siteDirectoryContent != null && siteDirectoryContent.length > 0) {
                    ArrayList gitAddCommand = new ArrayList();
                    Collections.addAll(gitAddCommand, "git", "add");
                    Collections.addAll(gitAddCommand, siteDirectoryContent);
                    DocumentationUtils.executeCommand(gitAddCommand.toArray(new String[gitAddCommand.size()]), logger);
                    ArrayList gitCommitCommand = new ArrayList();
                    Collections.addAll(gitCommitCommand, "git", "commit", "-m", String.format("[WSO2-Release] [Release %s] update documentation for release %s", version, version), "--");
                    Collections.addAll(gitCommitCommand, siteDirectoryContent);
                    DocumentationUtils.executeCommand(gitCommitCommand.toArray(new String[gitCommitCommand.size()]), logger);
                    if (scmUsername != null && scmPassword != null && url != null) {
                        String urlWithUsernameAndPassword = url.replaceFirst("https:\\/\\/github\\.com", "https://%s:%s@github.com");
                        DocumentationUtils.executeCommand(new String[]{"git", "push", String.format(urlWithUsernameAndPassword, scmUsername, scmPassword), "gh-pages"}, logger);
                    } else {
                        DocumentationUtils.executeCommand(new String[]{"git", "push", "origin", "gh-pages"}, logger);
                    }
                }
                DocumentationUtils.executeCommand(new String[]{"git", "checkout", initialBranch}, logger);
                DocumentationUtils.executeCommand(new String[]{"git", "stash", "pop"}, logger);
            } else {
                logger.warn((CharSequence)"Unable to parse git-status command and retrieve current git branch. Skipping deployment.");
            }
        }
        catch (Throwable t) {
            logger.warn((CharSequence)"Failed to deploy the documentation on github pages.", t);
        }
    }

    public static void updateDocumentationOnGitHub(String docsDirectory, File mkdocsConfigFile, File readmeFile, String version, Log logger) {
        try {
            DocumentationUtils.executeCommand(new String[]{"git", "add", docsDirectory, mkdocsConfigFile.getAbsolutePath(), readmeFile.getAbsolutePath()}, logger);
            DocumentationUtils.executeCommand(new String[]{"git", "commit", "-m", String.format("[WSO2-Release] [Release %s] update documentation for release %s", version, version), "--", docsDirectory, mkdocsConfigFile.getAbsolutePath(), readmeFile.getAbsolutePath()}, logger);
        }
        catch (Throwable t) {
            logger.warn((CharSequence)"Failed to update the documentation on GitHub repository", t);
        }
    }

    private static void addExtensionInDirectory(File moduleTargetClassesDirectory, String classesDirectoryPath, ClassLoader urlClassLoader, List<NamespaceMetaData> namespaceMetaDataList, Log logger) {
        File[] innerFiles = moduleTargetClassesDirectory.listFiles();
        if (innerFiles != null) {
            for (File innerFile : innerFiles) {
                if (innerFile.isDirectory()) {
                    DocumentationUtils.addExtensionInDirectory(innerFile, classesDirectoryPath, urlClassLoader, namespaceMetaDataList, logger);
                    continue;
                }
                DocumentationUtils.addExtensionInFile(innerFile, classesDirectoryPath, urlClassLoader, namespaceMetaDataList, logger);
            }
        }
    }

    private static void addExtensionInFile(File file, String classesDirectoryPath, ClassLoader urlClassLoader, List<NamespaceMetaData> namespaceMetaDataList, Log logger) {
        String filePath = file.getAbsolutePath();
        if (filePath.endsWith(".class") && filePath.length() > classesDirectoryPath.length()) {
            String relativePathToClass = filePath.substring((classesDirectoryPath + File.separator).length());
            try {
                Class<?> extensionClass = Class.forName(relativePathToClass.substring(0, relativePathToClass.length() - ".class".length()).replace(File.separator, "."), false, urlClassLoader);
                DocumentationUtils.addExtensionMetaDataIntoNamespaceList(namespaceMetaDataList, extensionClass, logger);
            }
            catch (Throwable ignored) {
                logger.warn((CharSequence)("Ignoring the failed class loading from " + file.getAbsolutePath()));
            }
        }
    }

    private static void addExtensionMetaDataIntoNamespaceList(List<NamespaceMetaData> namespaceList, Class<?> extensionClass, Log logger) {
        Extension extensionAnnotation = extensionClass.getAnnotation(Extension.class);
        if (extensionAnnotation != null) {
            ExtensionMetaData extensionMetaData = new ExtensionMetaData();
            String extensionType = null;
            for (Map.Entry<ExtensionType, Class<?>> entry : ExtensionType.getSuperClassMap().entrySet()) {
                Class<?> superClass = entry.getValue();
                if (!superClass.isAssignableFrom(extensionClass) || superClass == extensionClass) continue;
                extensionType = entry.getKey().getValue();
                break;
            }
            if (extensionType == null) {
                logger.warn((CharSequence)("Discarding extension (belonging to an unknown extension type): " + extensionClass.getCanonicalName()));
                return;
            }
            extensionMetaData.setName(extensionAnnotation.name());
            extensionMetaData.setDescription(extensionAnnotation.description());
            ParameterMetaData[] parameters = new ParameterMetaData[extensionAnnotation.parameters().length];
            for (int i = 0; i < extensionAnnotation.parameters().length; ++i) {
                Parameter parameterAnnotation = extensionAnnotation.parameters()[i];
                ParameterMetaData parameter = new ParameterMetaData();
                parameter.setName(parameterAnnotation.name());
                parameter.setType(Arrays.asList(parameterAnnotation.type()));
                parameter.setDescription(parameterAnnotation.description());
                parameter.setOptional(parameterAnnotation.optional());
                parameter.setDynamic(parameterAnnotation.dynamic());
                parameter.setDefaultValue(parameterAnnotation.defaultValue());
                parameters[i] = parameter;
            }
            extensionMetaData.setParameters(Arrays.asList(parameters));
            SystemParameterMetaData[] systemParameters = new SystemParameterMetaData[extensionAnnotation.systemParameter().length];
            for (int i = 0; i < extensionAnnotation.systemParameter().length; ++i) {
                SystemParameter systemParameterAnnotation = extensionAnnotation.systemParameter()[i];
                SystemParameterMetaData systemParameter = new SystemParameterMetaData();
                systemParameter.setName(systemParameterAnnotation.name());
                systemParameter.setDescription(systemParameterAnnotation.description());
                systemParameter.setDefaultValue(systemParameterAnnotation.defaultValue());
                systemParameter.setPossibleParameters(Arrays.asList(systemParameterAnnotation.possibleParameters()));
                systemParameters[i] = systemParameter;
            }
            extensionMetaData.setSystemParameters(Arrays.asList(systemParameters));
            ReturnAttributeMetaData[] returnAttributes = new ReturnAttributeMetaData[extensionAnnotation.returnAttributes().length];
            for (int i = 0; i < extensionAnnotation.returnAttributes().length; ++i) {
                ReturnAttribute parameterAnnotation = extensionAnnotation.returnAttributes()[i];
                ReturnAttributeMetaData returnAttribute = new ReturnAttributeMetaData();
                returnAttribute.setName(parameterAnnotation.name());
                returnAttribute.setType(Arrays.asList(parameterAnnotation.type()));
                returnAttribute.setDescription(parameterAnnotation.description());
                returnAttributes[i] = returnAttribute;
            }
            extensionMetaData.setReturnAttributes(Arrays.asList(returnAttributes));
            ExampleMetaData[] examples = new ExampleMetaData[extensionAnnotation.examples().length];
            for (int i = 0; i < extensionAnnotation.examples().length; ++i) {
                Example exampleAnnotation = extensionAnnotation.examples()[i];
                ExampleMetaData exampleMetaData = new ExampleMetaData();
                exampleMetaData.setSyntax(exampleAnnotation.syntax());
                exampleMetaData.setDescription(exampleAnnotation.description());
                examples[i] = exampleMetaData;
            }
            extensionMetaData.setExamples(Arrays.asList(examples));
            String namespaceName = extensionAnnotation.namespace();
            if (Objects.equals(namespaceName, "")) {
                namespaceName = "core";
            }
            NamespaceMetaData namespace = null;
            for (NamespaceMetaData existingNamespace : namespaceList) {
                if (!Objects.equals(existingNamespace.getName(), namespaceName)) continue;
                namespace = existingNamespace;
                break;
            }
            if (namespace == null) {
                namespace = new NamespaceMetaData();
                namespace.setName(namespaceName);
                namespace.setExtensionMap(new TreeMap<String, List<ExtensionMetaData>>());
                namespaceList.add(namespace);
            }
            List extensionMetaDataList = namespace.getExtensionMap().computeIfAbsent(extensionType, k -> new ArrayList());
            extensionMetaDataList.add(extensionMetaData);
        }
    }

    private static void generateFileFromTemplate(String templateFile, Map<String, Object> dataModel, String outputDirectory, String outputFileName) throws MojoFailureException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_25);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setClassForTemplateLoading(DocumentationUtils.class, File.separator + "templates");
        HashMap<String, String> constantsClassFieldMap = new HashMap<String, String>();
        for (Field field : Constants.class.getDeclaredFields()) {
            try {
                constantsClassFieldMap.put(field.getName(), field.get(null).toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        dataModel.put("CONSTANTS", constantsClassFieldMap);
        HashMap<String, String> extensionTypeEnumMap = new HashMap<String, String>();
        for (Field field : ExtensionType.class.getDeclaredFields()) {
            try {
                extensionTypeEnumMap.put(field.getName(), ((ExtensionType)((Object)field.get(null))).getValue());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        dataModel.put("EXTENSION_TYPE", extensionTypeEnumMap);
        try {
            Template template = cfg.getTemplate(templateFile);
            File outputFile = new File(outputDirectory + File.separator + outputFileName);
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new MojoFailureException("Unable to create directory " + outputFile.getParentFile());
            }
            if (!outputFile.exists() && !outputFile.createNewFile()) {
                throw new MojoFailureException("Unable to create file " + outputFile.getAbsolutePath());
            }
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, Charset.defaultCharset());){
                template.process(dataModel, (Writer)writer);
            }
            catch (TemplateException e) {
                throw new MojoFailureException("Invalid Free Marker template found in " + templateFile, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find template file " + templateFile, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getCommandOutput(String[] command, Log logger) throws Throwable {
        logger.info((CharSequence)("Executing: " + String.join((CharSequence)" ", command)));
        Process process = Runtime.getRuntime().exec(command);
        ArrayList<String> executionOutputLines = new ArrayList<String>();
        InputStream[] inputStreams = new InputStream[]{process.getInputStream(), process.getErrorStream()};
        BufferedReader bufferedReader = null;
        try {
            for (InputStream inputStream : inputStreams) {
                String commandOutput;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_CHARSET));
                while ((commandOutput = bufferedReader.readLine()) != null) {
                    executionOutputLines.add(commandOutput);
                }
            }
            process.waitFor();
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
        }
        return executionOutputLines;
    }

    private static void executeCommand(String[] command, Log logger) throws Throwable {
        List<String> executionOutputLines = DocumentationUtils.getCommandOutput(command, logger);
        for (String executionOutputLine : executionOutputLines) {
            logger.debug((CharSequence)executionOutputLine);
        }
    }
}

