/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.wso2.siddhi.doc.gen.core.utils.DocumentationUtils;

@Mojo(name="generate-extensions-index", aggregator=true, defaultPhase=LifecyclePhase.INSTALL)
public class ExtensionsIndexGenerationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(property="extension.repository.owner")
    private String extensionRepositoryOwner;
    @Parameter(property="extension.repositories", required=true)
    private List<String> extensionRepositories;
    @Parameter(property="doc.gen.base.directory")
    private File docGenBaseDirectory;
    @Parameter(property="index.gen.file.name")
    private String indexGenFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject rootMavenProject = this.mavenProject;
        while (rootMavenProject.getParent().getBasedir() != null) {
            rootMavenProject = rootMavenProject.getParent();
        }
        if (this.extensionRepositories == null || this.extensionRepositories.size() == 0) {
            throw new MojoExecutionException("extensionRepositories configuration is required to use goal generate-extensions-index");
        }
        if (this.extensionRepositoryOwner == null) {
            this.extensionRepositoryOwner = "wso2-extensions";
        }
        String docGenBasePath = this.docGenBaseDirectory != null ? this.docGenBaseDirectory.getAbsolutePath() : rootMavenProject.getBasedir() + File.separator + "docs";
        if (this.indexGenFileName == null) {
            this.indexGenFileName = "extensions";
        }
        DocumentationUtils.createExtensionsIndex(this.extensionRepositories, this.extensionRepositoryOwner, docGenBasePath, this.indexGenFileName);
    }
}

