/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.doc.gen.core.freemarker;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.Objects;

public class FormatDescriptionMethod
implements TemplateMethodModelEx {
    public Object exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("There should be a single argument of type string passed to format description method");
        }
        SimpleScalar arg1 = (SimpleScalar)args.get(0);
        String inputString = arg1.getAsString();
        inputString = this.replaceLeadingSpaces(inputString);
        inputString = inputString.replaceAll("<", "&lt;");
        inputString = inputString.replaceAll(">", "&gt;");
        inputString = this.replaceNewLines(inputString);
        inputString = inputString.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        inputString = inputString.replaceAll("```([^```]*)```", "<pre>$1</pre>");
        inputString = inputString.replaceAll("`([^`]*)`", "<code>$1</code>");
        return inputString;
    }

    private String replaceLeadingSpaces(String inputString) {
        StringBuilder stringBuilder = new StringBuilder(inputString);
        int i = 0;
        boolean isInsideCode = false;
        while (i < stringBuilder.length()) {
            if (i + 3 < stringBuilder.length() && Objects.equals(stringBuilder.substring(i, i + 3), "```")) {
                isInsideCode = !isInsideCode;
                i += 3;
                continue;
            }
            if (stringBuilder.charAt(i) == '`') {
                isInsideCode = !isInsideCode;
                ++i;
                continue;
            }
            if (!isInsideCode && stringBuilder.charAt(i) == '\n') {
                ++i;
                while (i < stringBuilder.length() && stringBuilder.charAt(i) == ' ') {
                    stringBuilder.replace(i, i + 1, "&nbsp;");
                    i += 6;
                }
                continue;
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    private String replaceNewLines(String inputString) {
        StringBuilder stringBuilder = new StringBuilder(inputString);
        int i = 0;
        boolean isInsideCode = false;
        while (i < stringBuilder.length()) {
            if (i + 3 < stringBuilder.length() && Objects.equals(stringBuilder.substring(i, i + 3), "```")) {
                isInsideCode = !isInsideCode;
                i += 3;
                continue;
            }
            if (stringBuilder.charAt(i) == '`') {
                isInsideCode = !isInsideCode;
                ++i;
                continue;
            }
            if (!isInsideCode && stringBuilder.charAt(i) == '\n') {
                stringBuilder.replace(i, i + 1, "<br>");
                i += 4;
                continue;
            }
            ++i;
        }
        return stringBuilder.toString();
    }
}

