/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.math;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class AtanFunctionExtension
extends FunctionExecutor {
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length < 1 || attributeExpressionExecutors.length > 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to math:atan() function, required 1 or 2, but found " + attributeExpressionExecutors.length);
        }
        int attributeIndex = 0;
        for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            Attribute.Type attributeType = expressionExecutor.getReturnType();
            if (attributeType != Attribute.Type.DOUBLE && attributeType != Attribute.Type.INT && attributeType != Attribute.Type.FLOAT && attributeType != Attribute.Type.LONG) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the argument at index " + attributeIndex + " of math:atan() function," + "required " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.DOUBLE + ", but found " + attributeType.toString());
            }
            ++attributeIndex;
        }
    }

    protected Object execute(Object[] data) {
        int inputInt;
        double inputVal1 = 0.0;
        double inputVal2 = 0.0;
        if (data[0] != null) {
            if (data[0] instanceof Integer) {
                inputInt = (Integer)data[0];
                inputVal1 = inputInt;
            } else if (data[0] instanceof Long) {
                long inputLong = (Long)data[0];
                inputVal1 = inputLong;
            } else if (data[0] instanceof Float) {
                float inputLong = ((Float)data[0]).floatValue();
                inputVal1 = inputLong;
            } else if (data[0] instanceof Double) {
                inputVal1 = (Double)data[0];
            }
        } else {
            throw new ExecutionPlanRuntimeException("Input to the math:atan() function cannot be null");
        }
        if (data[1] != null) {
            if (data[1] instanceof Integer) {
                inputInt = (Integer)data[1];
                inputVal2 = inputInt;
            } else if (data[1] instanceof Long) {
                long inputLong = (Long)data[1];
                inputVal2 = inputLong;
            } else if (data[1] instanceof Float) {
                float inputLong = ((Float)data[1]).floatValue();
                inputVal2 = inputLong;
            } else if (data[1] instanceof Double) {
                inputVal2 = (Double)data[1];
            }
        } else {
            throw new ExecutionPlanRuntimeException("Input to the math:atan() function cannot be null");
        }
        return Math.atan2(inputVal1, inputVal2);
    }

    protected Object execute(Object data) {
        if (data != null) {
            if (data instanceof Integer) {
                int inputInt = (Integer)data;
                return Math.atan(inputInt);
            }
            if (data instanceof Long) {
                long inputLong = (Long)data;
                return Math.atan(inputLong);
            }
            if (data instanceof Float) {
                float inputFloat = ((Float)data).floatValue();
                return Math.atan(inputFloat);
            }
            if (data instanceof Double) {
                return Math.atan((Double)data);
            }
        } else {
            throw new ExecutionPlanRuntimeException("Input to the math:atan() function cannot be null");
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

