/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.math;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class LogFunctionExtension
extends FunctionExecutor {
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to math:log() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.DOUBLE && attributeType != Attribute.Type.INT && attributeType != Attribute.Type.FLOAT && attributeType != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of math:log() function, required " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.DOUBLE + ", but found " + attributeType.toString());
        }
        attributeType = attributeExpressionExecutors[1].getReturnType();
        if (attributeType != Attribute.Type.DOUBLE && attributeType != Attribute.Type.INT && attributeType != Attribute.Type.FLOAT && attributeType != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of math:log() function, required " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.DOUBLE + ", but found " + attributeType.toString());
        }
    }

    protected Object execute(Object[] data) {
        int inputInt;
        double number = 0.0;
        double base = 0.0;
        if (data[0] != null) {
            if (data[0] instanceof Integer) {
                inputInt = (Integer)data[0];
                number = inputInt;
            } else if (data[0] instanceof Long) {
                long inputLong = (Long)data[0];
                number = inputLong;
            } else if (data[0] instanceof Float) {
                float inputLong = ((Float)data[0]).floatValue();
                number = inputLong;
            } else if (data[0] instanceof Double) {
                number = (Double)data[0];
            }
        } else {
            throw new ExecutionPlanRuntimeException("The first argument to the math:log() function cannot be null");
        }
        if (data[1] != null) {
            if (data[1] instanceof Integer) {
                inputInt = (Integer)data[1];
                base = inputInt;
            } else if (data[1] instanceof Long) {
                long inputLong = (Long)data[1];
                base = inputLong;
            } else if (data[1] instanceof Float) {
                float inputLong = ((Float)data[1]).floatValue();
                base = inputLong;
            } else if (data[1] instanceof Double) {
                base = (Double)data[1];
            }
        } else {
            throw new ExecutionPlanRuntimeException("The second argument to the math:log() function cannot be null");
        }
        if (base == 1.0) {
            throw new ExecutionPlanRuntimeException("The base argument supplied to the math:log() function is equal to zero. Since the logarithms to the base 1 is undefined, the result of math:log(" + number + "," + base + ") is undefined");
        }
        return Math.log(number) / Math.log(base);
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

