/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.math;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class PercentileFunctionExtension
extends AttributeAggregator {
    private PercentileFunctionExtension percentileOutputFunctionExtension;
    private double percentileValue;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new OperationNotSupportedException("Percentile function has to have exactly 2 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new OperationNotSupportedException("Percentile value has to be a constant");
        }
        Object percentileValueObject = attributeExpressionExecutors[1].execute(null);
        if (!(percentileValueObject instanceof Double)) {
            throw new OperationNotSupportedException("Percentile value should be of type double. But found " + attributeExpressionExecutors[1].getReturnType());
        }
        this.percentileValue = (Double)percentileValueObject;
        if (this.percentileValue <= 0.0 || this.percentileValue > 100.0) {
            throw new OperationNotSupportedException("Percentile value should be in 0 < p \u2264 100 range. But found " + this.percentileValue);
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.percentileOutputFunctionExtension = new PercentileFunctionExtensionFloat();
                break;
            }
            case INT: {
                this.percentileOutputFunctionExtension = new PercentileFunctionExtensionInt();
                break;
            }
            case LONG: {
                this.percentileOutputFunctionExtension = new PercentileFunctionExtensionLong();
                break;
            }
            case DOUBLE: {
                this.percentileOutputFunctionExtension = new PercentileFunctionExtensionDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Percentile not supported for " + type);
            }
        }
    }

    public Attribute.Type getReturnType() {
        return this.percentileOutputFunctionExtension.getReturnType();
    }

    public Object processAdd(Object data) {
        return new IllegalStateException("Percentile cannot process a single argument, but found " + data.toString());
    }

    public Object processAdd(Object[] data) {
        return this.percentileOutputFunctionExtension.processAdd(data);
    }

    public Object processRemove(Object data) {
        return new IllegalStateException("Percentile cannot process a single argument, but found " + data.toString());
    }

    public Object processRemove(Object[] data) {
        return this.percentileOutputFunctionExtension.processRemove(data);
    }

    public Object reset() {
        return this.percentileOutputFunctionExtension.reset();
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return this.percentileOutputFunctionExtension.currentState();
    }

    public void restoreState(Object[] state) {
        this.percentileOutputFunctionExtension.restoreState(state);
    }

    public double getPercentileValue(List<Double> valuesList, double percentile) {
        double percentileIndexTemp = percentile * (double)valuesList.size() / 100.0;
        if (percentileIndexTemp % 1.0 == 0.0) {
            int percentileIndex = (int)percentileIndexTemp;
            if (percentileIndex == valuesList.size()) {
                return valuesList.get(percentileIndex - 1);
            }
            return (valuesList.get(percentileIndex - 1) + valuesList.get(percentileIndex)) / 2.0;
        }
        int percentileIndex = (int)Math.round(percentileIndexTemp);
        return valuesList.get(percentileIndex - 1);
    }

    public void sortedArrayListAdd(List<Double> arrayList, double value) {
        int insertIndex = Collections.binarySearch(arrayList, value);
        if (insertIndex < 0) {
            arrayList.add(-insertIndex - 1, value);
        } else {
            arrayList.add(insertIndex + 1, value);
        }
    }

    public void sortedArrayListRemove(List<Double> arrayList, double value) {
        int removeIndex = Collections.binarySearch(arrayList, value);
        arrayList.remove(removeIndex);
    }

    class PercentileFunctionExtensionLong
    extends PercentileFunctionExtension {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private long count = 0L;
        private List<Double> valuesList = new ArrayList<Double>();

        PercentileFunctionExtensionLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object[] data) {
            ++this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = ((Long)data[0]).longValue();
            this.sortedArrayListAdd(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object processRemove(Object[] data) {
            --this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = ((Long)data[0]).longValue();
            this.sortedArrayListRemove(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object reset() {
            this.count = 0L;
            this.valuesList.clear();
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{this.valuesList, this.count};
        }

        @Override
        public void restoreState(Object[] state) {
            this.valuesList = (List)state[0];
            this.count = (Long)state[1];
        }
    }

    class PercentileFunctionExtensionInt
    extends PercentileFunctionExtension {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private long count = 0L;
        private List<Double> valuesList = new ArrayList<Double>();

        PercentileFunctionExtensionInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object[] data) {
            ++this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = ((Integer)data[0]).intValue();
            this.sortedArrayListAdd(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object processRemove(Object[] data) {
            --this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = ((Integer)data[0]).intValue();
            this.sortedArrayListRemove(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object reset() {
            this.count = 0L;
            this.valuesList.clear();
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{this.valuesList, this.count};
        }

        @Override
        public void restoreState(Object[] state) {
            this.valuesList = (List)state[0];
            this.count = (Long)state[1];
        }
    }

    class PercentileFunctionExtensionFloat
    extends PercentileFunctionExtension {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private long count = 0L;
        private List<Double> valuesList = new ArrayList<Double>();

        PercentileFunctionExtensionFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object[] data) {
            ++this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = ((Float)data[0]).floatValue();
            this.sortedArrayListAdd(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object processRemove(Object[] data) {
            --this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = ((Float)data[0]).floatValue();
            this.sortedArrayListRemove(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object reset() {
            this.count = 0L;
            this.valuesList.clear();
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{this.valuesList, this.count};
        }

        @Override
        public void restoreState(Object[] state) {
            this.valuesList = (List)state[0];
            this.count = (Long)state[1];
        }
    }

    class PercentileFunctionExtensionDouble
    extends PercentileFunctionExtension {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private long count = 0L;
        private List<Double> valuesList = new ArrayList<Double>();

        PercentileFunctionExtensionDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object[] data) {
            ++this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = (Double)data[0];
            this.sortedArrayListAdd(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object processRemove(Object[] data) {
            --this.count;
            if (this.count == 0L) {
                return 0.0;
            }
            double value = (Double)data[0];
            this.sortedArrayListRemove(this.valuesList, value);
            return this.getPercentileValue(this.valuesList, PercentileFunctionExtension.this.percentileValue);
        }

        @Override
        public Object reset() {
            this.count = 0L;
            this.valuesList.clear();
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{this.valuesList, this.count};
        }

        @Override
        public void restoreState(Object[] state) {
            this.valuesList = (List)state[0];
            this.count = (Long)state[1];
        }
    }
}

