/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.math;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class RoundFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to math:round() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.DOUBLE && attributeType != Attribute.Type.FLOAT) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of math:round() function, required " + Attribute.Type.FLOAT + " or " + Attribute.Type.DOUBLE + ", but found " + attributeType.toString());
        }
        this.returnType = attributeType == Attribute.Type.FLOAT ? Attribute.Type.INT : Attribute.Type.LONG;
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data != null) {
            if (data instanceof Float) {
                float inputValue = ((Float)data).floatValue();
                return Math.round(inputValue);
            }
            if (data instanceof Double) {
                double inputValue = (Double)data;
                return Math.round(inputValue);
            }
        } else {
            throw new ExecutionPlanRuntimeException("Input to the math:round() function cannot be null");
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

