/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.math;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Random;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class RandomFunctionExtension
extends FunctionExecutor {
    Random random;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length > 1) {
            throw new ExecutionPlanValidationException("Invalid no of Arguments Passed. Required 0 or 1. Found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors.length == 1) {
            long seed;
            if (attributeExpressionExecutors[0] == null) {
                throw new ExecutionPlanValidationException("Invalid input given to math:rand() function. The 'seed' argument cannot be null");
            }
            Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
            if (type != Attribute.Type.INT && type != Attribute.Type.LONG) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of math:rand() function, required " + Attribute.Type.INT + " or " + Attribute.Type.LONG + ", but found " + type.toString());
            }
            if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
                Object constantObj = ((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
                if (type == Attribute.Type.INT) {
                    int intSeed = (Integer)constantObj;
                    seed = intSeed;
                } else {
                    seed = (Long)constantObj;
                }
            } else {
                throw new ExecutionPlanValidationException("The seed argument of math:rand() function should be a constant, but found " + attributeExpressionExecutors[0].getClass().toString());
            }
            this.random = new Random(seed);
        } else {
            this.random = new Random();
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        return this.random.nextDouble();
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }

    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, Random>("Random", this.random)};
    }

    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.random = (Random)stateEntry.getValue();
    }
}

