/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.math;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.extension.math.util.ValueParser;
import org.wso2.siddhi.query.api.definition.Attribute;

public class PercentileFunctionExtension
extends AttributeAggregator {
    private ValueParser valueParser;
    private double percentileValue;
    private List<Double> valuesList;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new OperationNotSupportedException("Percentile function has to have exactly 2 parameter, currently " + attributeExpressionExecutors.length + " parameters provided.");
        }
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new OperationNotSupportedException("Percentile value has to be a constant.");
        }
        Object percentileValueObject = attributeExpressionExecutors[1].execute(null);
        if (!(percentileValueObject instanceof Double)) {
            throw new OperationNotSupportedException("Percentile value should be of type double. But found " + attributeExpressionExecutors[1].getReturnType());
        }
        this.percentileValue = (Double)percentileValueObject;
        if (this.percentileValue <= 0.0 || this.percentileValue > 100.0) {
            throw new OperationNotSupportedException("Percentile value should be in 0 < p \u2264 100 range. But found " + this.percentileValue);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        switch (attributeType) {
            case FLOAT: {
                this.valueParser = new FloatValueParser();
                break;
            }
            case INT: {
                this.valueParser = new IntValueParser();
                break;
            }
            case LONG: {
                this.valueParser = new LongValueParser();
                break;
            }
            case DOUBLE: {
                this.valueParser = new DoubleValueParser();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Percentile not supported for " + attributeType);
            }
        }
        this.valuesList = new ArrayList<Double>();
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.DOUBLE;
    }

    public Object processAdd(Object data) {
        return new IllegalStateException("Percentile cannot process a single argument, but found " + data.toString());
    }

    public Object processAdd(Object[] data) {
        double value = this.valueParser.parseValue(data[0]);
        this.sortedArrayListAdd(this.valuesList, value);
        return this.getPercentileValue(this.valuesList, this.percentileValue);
    }

    public Object processRemove(Object data) {
        return new IllegalStateException("Percentile cannot process a single argument, but found " + data.toString());
    }

    public Object processRemove(Object[] data) {
        double value = this.valueParser.parseValue(data[0]);
        this.sortedArrayListRemove(this.valuesList, value);
        return this.getPercentileValue(this.valuesList, this.percentileValue);
    }

    public Object reset() {
        this.valuesList.clear();
        return 0.0;
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[]{this.valuesList};
    }

    public void restoreState(Object[] state) {
        this.valuesList = (List)state[0];
    }

    private double getPercentileValue(List<Double> valuesList, double percentile) {
        double percentileIndexTemp = percentile * (double)valuesList.size() / 100.0;
        if (percentileIndexTemp % 1.0 == 0.0) {
            int percentileIndex = (int)percentileIndexTemp;
            if (percentileIndex == valuesList.size()) {
                return valuesList.get(percentileIndex - 1);
            }
            return (valuesList.get(percentileIndex - 1) + valuesList.get(percentileIndex)) / 2.0;
        }
        int percentileIndex = (int)Math.round(percentileIndexTemp);
        if (percentileIndex == 0) {
            return valuesList.get(percentileIndex);
        }
        return valuesList.get(percentileIndex - 1);
    }

    private void sortedArrayListAdd(List<Double> arrayList, double value) {
        int insertIndex = Collections.binarySearch(arrayList, value);
        if (insertIndex < 0) {
            arrayList.add(-insertIndex - 1, value);
        } else {
            arrayList.add(insertIndex + 1, value);
        }
    }

    private void sortedArrayListRemove(List<Double> arrayList, double value) {
        int removeIndex = Collections.binarySearch(arrayList, value);
        arrayList.remove(removeIndex);
    }

    private class LongValueParser
    implements ValueParser {
        private LongValueParser() {
        }

        @Override
        public double parseValue(Object valueObject) {
            return ((Long)valueObject).longValue();
        }
    }

    private class IntValueParser
    implements ValueParser {
        private IntValueParser() {
        }

        @Override
        public double parseValue(Object valueObject) {
            return ((Integer)valueObject).intValue();
        }
    }

    private class FloatValueParser
    implements ValueParser {
        private FloatValueParser() {
        }

        @Override
        public double parseValue(Object valueObject) {
            return ((Float)valueObject).floatValue();
        }
    }

    private class DoubleValueParser
    implements ValueParser {
        private DoubleValueParser() {
        }

        @Override
        public double parseValue(Object valueObject) {
            return (Double)valueObject;
        }
    }
}

