/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.ooh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class KSlackExtension
extends StreamProcessor {
    private long k = 0L;
    private long greatestTimestamp = 0L;
    private TreeMap<Long, ArrayList<StreamEvent>> eventTreeMap;
    private TreeMap<Long, ArrayList<StreamEvent>> expiredEventTreeMap;
    private ExpressionExecutor timestampExecutor;

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ComplexEventChunk complexEventChunk = new ComplexEventChunk();
        try {
            while (streamEventChunk.hasNext()) {
                StreamEvent event = (StreamEvent)streamEventChunk.next();
                streamEventChunk.remove();
                long timestamp = (Long)this.timestampExecutor.execute((ComplexEvent)event);
                ArrayList<Object> eventList = this.eventTreeMap.get(timestamp);
                if (eventList == null) {
                    eventList = new ArrayList();
                }
                eventList.add(event);
                this.eventTreeMap.put(timestamp, eventList);
                if (timestamp <= this.greatestTimestamp) continue;
                this.greatestTimestamp = timestamp;
                long minTimestamp = this.eventTreeMap.firstKey();
                if (this.greatestTimestamp - minTimestamp > this.k) {
                    this.k = this.greatestTimestamp - minTimestamp;
                }
                for (Map.Entry<Long, ArrayList<StreamEvent>> entry : this.eventTreeMap.entrySet()) {
                    ArrayList<StreamEvent> list = this.expiredEventTreeMap.get(entry.getKey());
                    if (list != null) {
                        list.addAll((Collection<StreamEvent>)entry.getValue());
                        continue;
                    }
                    this.expiredEventTreeMap.put(entry.getKey(), entry.getValue());
                }
                this.eventTreeMap = new TreeMap();
                Iterator<Map.Entry<Long, ArrayList<StreamEvent>>> entryIterator = this.expiredEventTreeMap.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<Long, ArrayList<StreamEvent>> entry;
                    entry = entryIterator.next();
                    if (entry.getKey() + this.k > this.greatestTimestamp) continue;
                    entryIterator.remove();
                    ArrayList<StreamEvent> timeEventList = entry.getValue();
                    for (StreamEvent aTimeEventList : timeEventList) {
                        complexEventChunk.add((ComplexEvent)aTimeEventList);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ec) {
            throw new ExecutionPlanCreationException("The very first parameter must be an Integer with a valid field index (0 to (fieldsLength-1)).");
        }
        nextProcessor.process(complexEventChunk);
    }

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (this.attributeExpressionLength == 0) {
            throw new ExecutionPlanCreationException("At least one parameter is required specifying the timestamp field having long return type.");
        }
        if (this.attributeExpressionLength > 1) {
            throw new ExecutionPlanCreationException("Only one parameter is required for KSlack that's timestamp field having long return type, but found " + this.attributeExpressionLength);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
            throw new ExecutionPlanCreationException("Return type expected by KSlack is LONG but found " + attributeExpressionExecutors[0].getReturnType());
        }
        this.timestampExecutor = attributeExpressionExecutors[0];
        this.eventTreeMap = new TreeMap();
        this.expiredEventTreeMap = new TreeMap();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("beta0", Attribute.Type.INT));
        return attributes;
    }
}

