/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class LookingAtFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;
    private static final Logger log = Logger.getLogger(LookingAtFunctionExtension.class);
    private boolean isRegexConstant = false;
    private String regexConstant;
    private Pattern patternConstant;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to regex:lookingAt() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of regex:lookingAt() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of regex:lookingAt() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            this.isRegexConstant = true;
            this.regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            this.patternConstant = Pattern.compile(this.regexConstant);
        }
    }

    protected Object execute(Object[] data) {
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to regex:lookingAt() function. First argument cannot be null");
        }
        if (data[1] == null) {
            if (log.isDebugEnabled()) {
                log.warn((Object)"Invalid input given to regex:lookingAt() function. Second argument cannot be null, returning false");
            }
            return false;
        }
        String source = (String)data[1];
        if (!this.isRegexConstant) {
            String regex = (String)data[0];
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(source);
            return matcher.lookingAt();
        }
        Matcher matcher = this.patternConstant.matcher(source);
        return matcher.lookingAt();
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[]{this.isRegexConstant, this.regexConstant, this.patternConstant};
    }

    public void restoreState(Object[] state) {
        this.isRegexConstant = (Boolean)state[0];
        this.regexConstant = (String)state[1];
        this.patternConstant = (Pattern)state[2];
    }
}

