/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.time;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class DateAddFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;
    private boolean useDefaultDateFormat = false;
    private String dateFormat = null;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors.length == 3) {
            this.useDefaultDateFormat = true;
            this.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        if (attributeExpressionExecutors.length == 4) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateAdd(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.INT) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateAdd(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.INT + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
            }
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of time:dateAdd(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[2].getReturnType().toString());
            }
            if (attributeExpressionExecutors[3].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the fourth argument of time:dateAdd(dateValue,expr,unit,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[3].getReturnType().toString());
            }
        } else if (attributeExpressionExecutors.length == 3) {
            if (this.useDefaultDateFormat) {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateAdd(dateValue,expr,unit) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.INT) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateAdd(dateValue,expr,unit) function, required " + Attribute.Type.INT + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
                }
                if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateAdd(dateValue,expr,unit) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[2].getReturnType().toString());
                }
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dateAdd(timestampInMilliseconds,expr,unit) function, required " + Attribute.Type.LONG + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.INT) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateAdd(timestampInMilliseconds,expr,unit) function, required " + Attribute.Type.INT + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
                }
                if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dateAdd(timestampInMilliseconds,expr,unit) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[2].getReturnType().toString());
                }
            }
        } else {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:dateAdd() function, required 3 or 4, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        Calendar calInstance = Calendar.getInstance();
        String date = null;
        if (data.length == 4 || this.useDefaultDateFormat) {
            try {
                if (data[0] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:dateAdd(date,expr,unit,dateFormat) function. First argument cannot be null");
                }
                if (data[1] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:dateAdd(date,expr,unit,dateFormat) function. Second argument cannot be null");
                }
                if (data[2] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:dateAdd(date,expr,unit,dateFormat) function. Third argument cannot be null");
                }
                if (!this.useDefaultDateFormat) {
                    if (data[3] == null) {
                        throw new ExecutionPlanRuntimeException("Invalid input given to time:dateAdd(date,expr,unit,dateFormat) function. Fourth argument cannot be null");
                    }
                    this.dateFormat = (String)data[3];
                }
                date = (String)data[0];
                int expression = (Integer)data[1];
                String unit = (String)data[2];
                FastDateFormat formattedDate = FastDateFormat.getInstance((String)this.dateFormat);
                Date userSpecifiedDate = formattedDate.parse(date);
                calInstance.setTime(userSpecifiedDate);
                this.getProcessedCalenderInstance(unit, calInstance, expression);
                return formattedDate.format(calInstance.getTime());
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.dateFormat + " does not match with the timestamp " + date + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        if (data.length == 3) {
            if (data[0] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateAdd(timestampInMilliseconds,expr,unit) function. First argument cannot be null");
            }
            if (data[1] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateAdd(timestampInMilliseconds,expr,unit) function. Second argument cannot be null");
            }
            if (data[2] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dateAdd(timestampInMilliseconds,expr,unit) function. Third argument cannot be null");
            }
            try {
                long dateInMills = (Long)data[0];
                calInstance.setTimeInMillis(dateInMills);
                String unit = (String)data[2];
                int expression = (Integer)data[1];
                this.getProcessedCalenderInstance(unit, calInstance, expression);
                return String.valueOf(calInstance.getTimeInMillis());
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        throw new ExecutionPlanRuntimeException("Invalid set of arguments given to time:dateAdd() function.Arguments should be either 3 or 4. ");
    }

    public Calendar getProcessedCalenderInstance(String unit, Calendar calInstance, int expression) {
        if ((unit = unit.toUpperCase()).equals("YEAR")) {
            calInstance.add(1, expression);
        } else if (unit.equals("MONTH")) {
            calInstance.add(2, expression);
        } else if (unit.equals("SECOND")) {
            calInstance.add(13, expression);
        } else if (unit.equals("MINUTE")) {
            calInstance.add(12, expression);
        } else if (unit.equals("HOUR")) {
            calInstance.add(10, expression);
        } else if (unit.equals("DAY")) {
            calInstance.add(5, expression);
        } else if (unit.equals("WEEK")) {
            calInstance.add(3, expression);
        } else if (unit.equals("QUARTER")) {
            calInstance.add(2, expression * 3);
        }
        return calInstance;
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

