/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.time;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ExtractAttributesFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.INT;
    private boolean useDefaultDateFormat = false;
    private String dateFormat = null;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors.length == 2) {
            this.useDefaultDateFormat = true;
            this.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        if (attributeExpressionExecutors.length == 3) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
            }
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[2].getReturnType().toString());
            }
        } else if (attributeExpressionExecutors.length == 2) {
            if (this.useDefaultDateFormat) {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
                }
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:extract(timestampInMilliseconds,unit) function, required " + Attribute.Type.LONG + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:extract(timestampInMilliseconds,unit) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
                }
            }
        } else {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:extract() function, required 2 or 3, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        String unit;
        Calendar cal = Calendar.getInstance();
        String source = null;
        if (data.length == 3 || this.useDefaultDateFormat) {
            try {
                if (data[0] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(unit,dateValue,dateFormat) function. First argument cannot be null");
                }
                if (data[1] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(unit,dateValue,dateFormat) function. Second argument cannot be null");
                }
                if (!this.useDefaultDateFormat) {
                    if (data[2] == null) {
                        throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(unit,dateValue,dateFormat) function. Third argument cannot be null");
                    }
                    this.dateFormat = (String)data[2];
                }
                source = (String)data[1];
                unit = (String)data[0];
                FastDateFormat userSpecificFormat = FastDateFormat.getInstance((String)this.dateFormat);
                Date userSpecifiedDate = userSpecificFormat.parse(source);
                cal.setTime(userSpecifiedDate);
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.dateFormat + " does not match with the timestamp " + source + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(timestampInMilliseconds,unit) function. First argument cannot be null");
        }
        if (data[1] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(timestampInMilliseconds,unit) function. Second argument cannot be null");
        }
        try {
            long millis = (Long)data[0];
            unit = (String)data[1];
            cal.setTimeInMillis(millis);
        }
        catch (ClassCastException e) {
            String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
        int returnValue = 0;
        unit = unit.toUpperCase();
        if (unit.equals("YEAR")) {
            returnValue = cal.get(1);
        } else if (unit.equals("MONTH")) {
            returnValue = cal.get(2) + 1;
        } else if (unit.equals("SECOND")) {
            returnValue = cal.get(13);
        } else if (unit.equals("MINUTE")) {
            returnValue = cal.get(12);
        } else if (unit.equals("HOUR")) {
            returnValue = cal.get(11);
        } else if (unit.equals("DAY")) {
            returnValue = cal.get(5);
        } else if (unit.equals("WEEK")) {
            returnValue = cal.get(3);
        } else if (unit.equals("QUARTER")) {
            returnValue = cal.get(2) / 3 + 1;
        }
        return returnValue;
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

