/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ExtractDayOfWeekFunctionExtension
extends FunctionExecutor {
    private static final Log log = LogFactory.getLog(ExtractDayOfWeekFunctionExtension.class);
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length > 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:dayOfWeek(dateValue,dateFormat) function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dayOfWeek(dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors.length > 0 && attributeExpressionExecutors.length > 1 && attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dayOfWeek(dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
    }

    protected Object execute(Object[] data) {
        String userFormat;
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:dayOfWeek(dateValue,dateFormat) function. First argument cannot be null");
        }
        if (data.length > 1) {
            if (data[1] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dayOfWeek(dateValue,dateFormat) function. Second argument cannot be null");
            }
            userFormat = (String)data[1];
        } else {
            userFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        String source = null;
        try {
            source = (String)data[0];
            FastDateFormat userSpecificFormat = FastDateFormat.getInstance((String)userFormat);
            Date userSpecifiedDate = userSpecificFormat.parse(source);
            return this.getDayOfWeek(userSpecifiedDate);
        }
        catch (ParseException e) {
            String errorMsg = "Provided format " + userFormat + " does not match with the timestamp " + source + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
        catch (ClassCastException e) {
            String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
    }

    protected Object execute(Object data) {
        if (data == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:dayOfWeek(dateValue,dateFormat) function. First argument cannot be null");
        }
        String userFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        try {
            String source = (String)data;
            String[] inputData = source.split(" ");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(inputData[0]);
                return this.getDayOfWeek(date);
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + userFormat + " does not match with the timestamp " + source + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        catch (ClassCastException e) {
            String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }

    private String getDayOfWeek(Date date) {
        SimpleDateFormat dateFormatDayOfWeek = new SimpleDateFormat("EEEE");
        return dateFormatDayOfWeek.format(date);
    }
}

