/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.annotation;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.annotation.Element;

public class Annotation {
    private String name;
    private List<Element> elements = new ArrayList<Element>();

    public Annotation(String name) {
        this.name = name;
    }

    public Annotation element(String key, String value) {
        this.elements.add(new Element(key, value));
        return this;
    }

    public Annotation element(String value) {
        this.elements.add(new Element(null, value));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public Annotation element(Element element) {
        this.elements.add(element);
        return this;
    }

    public static Annotation annotation(String name) {
        return new Annotation(name);
    }

    public String getElement(String key) {
        for (Element element : this.elements) {
            if (!element.getKey().equals(key)) continue;
            return element.getValue();
        }
        return null;
    }

    public String toString() {
        return "Annotation{name='" + this.name + '\'' + ", elements=" + this.elements + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation that = (Annotation)o;
        if (this.elements != null ? !this.elements.equals(that.elements) : that.elements != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.elements != null ? this.elements.hashCode() : 0);
        return result;
    }
}

