/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.input.stream;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.constant.Constant;

public class JoinInputStream
extends InputStream {
    private InputStream leftInputStream;
    private Type type;
    private InputStream rightInputStream;
    private Expression onCompare;
    private EventTrigger trigger;
    private Constant within;

    public JoinInputStream(SingleInputStream leftInputStream, Type type, SingleInputStream rightInputStream, Expression onCompare, Constant within, EventTrigger trigger) {
        this.leftInputStream = leftInputStream;
        this.type = type;
        this.rightInputStream = rightInputStream;
        this.onCompare = onCompare;
        this.within = within;
        this.trigger = trigger;
    }

    public InputStream getLeftInputStream() {
        return this.leftInputStream;
    }

    public Type getType() {
        return this.type;
    }

    public InputStream getRightInputStream() {
        return this.rightInputStream;
    }

    public Expression getOnCompare() {
        return this.onCompare;
    }

    public EventTrigger getTrigger() {
        return this.trigger;
    }

    public Constant getWithin() {
        return this.within;
    }

    @Override
    public List<String> getAllStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (String streamId : this.leftInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        for (String streamId : this.rightInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        return list;
    }

    @Override
    public List<String> getUniqueStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (String streamId : this.leftInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        for (String streamId : this.rightInputStream.getAllStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        return list;
    }

    public static enum EventTrigger {
        LEFT,
        RIGHT,
        ALL;

    }

    public static enum Type {
        JOIN,
        INNER_JOIN,
        LEFT_OUTER_JOIN,
        RIGHT_OUTER_JOIN,
        FULL_OUTER_JOIN;

    }
}

