/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.input.handler;

import java.util.Arrays;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamHandler;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.extension.Extension;

public class Window
implements StreamHandler,
Extension,
SiddhiElement {
    private static final long serialVersionUID = 1L;
    private String namespace = "";
    private String function;
    private Expression[] parameters;
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public Window(String namespace, String functionName, Expression[] parameters) {
        this.function = functionName;
        this.parameters = Arrays.copyOfRange(parameters, 0, parameters.length);
        this.namespace = namespace;
    }

    public Window(String namespace, String functionName) {
        this.function = functionName;
        this.namespace = namespace;
    }

    public Window(String functionName, Expression[] parameters) {
        this.function = functionName;
        this.parameters = Arrays.copyOfRange(parameters, 0, parameters.length);
    }

    public Window(String functionName) {
        this.function = functionName;
    }

    @Override
    public String getName() {
        return this.function;
    }

    @Override
    public Expression[] getParameters() {
        return Arrays.copyOfRange(this.parameters, 0, this.parameters.length);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Window window = (Window)o;
        if (this.function != null ? !this.function.equals(window.function) : window.function != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, window.parameters)) {
            return false;
        }
        return this.namespace != null ? this.namespace.equals(window.namespace) : window.namespace == null;
    }

    public int hashCode() {
        int result = this.function != null ? this.function.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Window{namespace='" + this.namespace + '\'' + ", function='" + this.function + '\'' + ", parameters=" + Arrays.toString(this.parameters) + '}';
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }
}

