/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.input.stream;

import java.io.Serializable;
import java.util.List;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.AnonymousInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.constant.Constant;

public abstract class InputStream
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream, Expression onCompare, Constant within) {
        return new JoinInputStream(leftStream, type, rightStream, onCompare, within, JoinInputStream.EventTrigger.ALL);
    }

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream, Expression onCompare, Constant within, JoinInputStream.EventTrigger trigger) {
        return new JoinInputStream(leftStream, type, rightStream, onCompare, within, trigger);
    }

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream, Constant within, JoinInputStream.EventTrigger trigger) {
        return new JoinInputStream(leftStream, type, rightStream, null, within, trigger);
    }

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream, Expression onCompare, JoinInputStream.EventTrigger trigger) {
        return new JoinInputStream(leftStream, type, rightStream, onCompare, null, trigger);
    }

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream, JoinInputStream.EventTrigger trigger) {
        return new JoinInputStream(leftStream, type, rightStream, null, null, trigger);
    }

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream, Constant within) {
        return new JoinInputStream(leftStream, type, rightStream, null, within, JoinInputStream.EventTrigger.ALL);
    }

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream, Expression onCompare) {
        return new JoinInputStream(leftStream, type, rightStream, onCompare, null, JoinInputStream.EventTrigger.ALL);
    }

    public static InputStream joinStream(SingleInputStream leftStream, JoinInputStream.Type type, SingleInputStream rightStream) {
        return new JoinInputStream(leftStream, type, rightStream, null, null, JoinInputStream.EventTrigger.ALL);
    }

    public static StateInputStream patternStream(StateElement patternElement) {
        return new StateInputStream(StateInputStream.Type.PATTERN, patternElement);
    }

    public static StateInputStream sequenceStream(StateElement sequenceElement) {
        return new StateInputStream(StateInputStream.Type.SEQUENCE, sequenceElement);
    }

    public static BasicSingleInputStream innerStream(String streamId) {
        return new BasicSingleInputStream(null, streamId, true);
    }

    public static BasicSingleInputStream innerStream(String streamReferenceId, String streamId) {
        return new BasicSingleInputStream(streamReferenceId, streamId, true);
    }

    public static BasicSingleInputStream stream(String streamId) {
        return new BasicSingleInputStream(null, streamId);
    }

    public static BasicSingleInputStream stream(String streamReferenceId, String streamId) {
        return new BasicSingleInputStream(streamReferenceId, streamId);
    }

    public static SingleInputStream stream(Query query) {
        return new AnonymousInputStream(query);
    }

    public abstract List<String> getAllStreamIds();

    public abstract List<String> getUniqueStreamIds();
}

