/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.exception.DuplicateAttributeException;
import org.wso2.siddhi.query.api.execution.query.selection.BasicSelector;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;

public class Selector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<OutputAttribute> selectionList = new ArrayList<OutputAttribute>();
    private List<Variable> groupByList = new ArrayList<Variable>();
    private Expression havingExpression;

    public static Selector selector() {
        return new Selector();
    }

    public static BasicSelector basicSelector() {
        return new BasicSelector();
    }

    public Selector select(String rename, Expression expression) {
        OutputAttribute outputAttribute = new OutputAttribute(rename, expression);
        this.checkSelection(outputAttribute);
        this.selectionList.add(outputAttribute);
        return this;
    }

    public Selector select(Variable variable) {
        OutputAttribute outputAttribute = new OutputAttribute(variable);
        this.checkSelection(outputAttribute);
        this.selectionList.add(outputAttribute);
        return this;
    }

    private void checkSelection(OutputAttribute newAttribute) {
        for (OutputAttribute attribute : this.selectionList) {
            if (!attribute.getRename().equals(newAttribute.getRename())) continue;
            throw new DuplicateAttributeException(attribute.getRename() + " is already defined as an output attribute ");
        }
    }

    public Selector having(Expression havingExpression) {
        this.havingExpression = havingExpression;
        return this;
    }

    public Selector groupBy(Variable variable) {
        this.groupByList.add(variable);
        return this;
    }

    public Selector addGroupByList(List<Variable> list) {
        if (list != null) {
            this.groupByList.addAll(list);
        }
        return this;
    }

    public List<OutputAttribute> getSelectionList() {
        return this.selectionList;
    }

    public List<Variable> getGroupByList() {
        return this.groupByList;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public Selector addSelectionList(List<OutputAttribute> projectionList) {
        for (OutputAttribute outputAttribute : projectionList) {
            this.checkSelection(outputAttribute);
            this.selectionList.add(outputAttribute);
        }
        return this;
    }

    public String toString() {
        return "Selector{selectionList=" + this.selectionList + ", groupByList=" + this.groupByList + ", havingExpression=" + this.havingExpression + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Selector)) {
            return false;
        }
        Selector selector = (Selector)o;
        if (this.groupByList != null ? !this.groupByList.equals(selector.groupByList) : selector.groupByList != null) {
            return false;
        }
        if (this.havingExpression != null ? !this.havingExpression.equals(selector.havingExpression) : selector.havingExpression != null) {
            return false;
        }
        return !(this.selectionList != null ? !this.selectionList.equals(selector.selectionList) : selector.selectionList != null);
    }

    public int hashCode() {
        int result = this.selectionList != null ? this.selectionList.hashCode() : 0;
        result = 31 * result + (this.groupByList != null ? this.groupByList.hashCode() : 0);
        result = 31 * result + (this.havingExpression != null ? this.havingExpression.hashCode() : 0);
        return result;
    }
}

