/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateDefinitionException;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class ExecutionPlan {
    private Map<String, StreamDefinition> streamDefinitionMap = new HashMap<String, StreamDefinition>();
    private Map<String, TableDefinition> tableDefinitionMap = new HashMap<String, TableDefinition>();
    private Map<String, WindowDefinition> windowDefinitionMap = new HashMap<String, WindowDefinition>();
    private Map<String, TriggerDefinition> triggerDefinitionMap = new HashMap<String, TriggerDefinition>();
    private List<ExecutionElement> executionElementList = new ArrayList<ExecutionElement>();
    private List<String> executionElementNameList = new ArrayList<String>();
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private Map<String, FunctionDefinition> functionDefinitionMap = new HashMap<String, FunctionDefinition>();

    public ExecutionPlan(String name) {
        this.annotations.add(Annotation.annotation("info").element("name", name));
    }

    public ExecutionPlan(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public ExecutionPlan() {
    }

    public static ExecutionPlan executionPlan(String name) {
        return new ExecutionPlan(name);
    }

    public static ExecutionPlan executionPlan() {
        return new ExecutionPlan();
    }

    public Map<String, FunctionDefinition> getFunctionDefinitionMap() {
        return this.functionDefinitionMap;
    }

    public ExecutionPlan defineStream(StreamDefinition streamDefinition) {
        if (streamDefinition == null) {
            throw new ExecutionPlanValidationException("Stream Definition should not be null");
        }
        if (streamDefinition.getId() == null) {
            throw new ExecutionPlanValidationException("Stream Id should not be null for Stream Definition");
        }
        this.checkDuplicateDefinition(streamDefinition);
        this.streamDefinitionMap.put(streamDefinition.getId(), streamDefinition);
        return this;
    }

    public ExecutionPlan defineTable(TableDefinition tableDefinition) {
        if (tableDefinition == null) {
            throw new ExecutionPlanValidationException("Table Definition should not be null");
        }
        if (tableDefinition.getId() == null) {
            throw new ExecutionPlanValidationException("Table Id should not be null for Table Definition");
        }
        this.checkDuplicateDefinition(tableDefinition);
        this.tableDefinitionMap.put(tableDefinition.getId(), tableDefinition);
        return this;
    }

    public ExecutionPlan defineWindow(WindowDefinition windowDefinition) {
        if (windowDefinition == null) {
            throw new ExecutionPlanValidationException("Window Definition should not be null");
        }
        if (windowDefinition.getId() == null) {
            throw new ExecutionPlanValidationException("Window Id should not be null for Window Definition");
        }
        this.checkDuplicateDefinition(windowDefinition);
        this.windowDefinitionMap.put(windowDefinition.getId(), windowDefinition);
        return this;
    }

    public ExecutionPlan defineTrigger(TriggerDefinition triggerDefinition) {
        if (triggerDefinition == null) {
            throw new ExecutionPlanValidationException("Trigger Definition should not be null");
        }
        if (triggerDefinition.getId() == null) {
            throw new ExecutionPlanValidationException("Trigger Id should not be null for Trigger Definition");
        }
        StreamDefinition streamDefinition = StreamDefinition.id(triggerDefinition.getId()).attribute("triggered_time", Attribute.Type.LONG);
        try {
            this.checkDuplicateDefinition(streamDefinition);
        }
        catch (DuplicateDefinitionException e) {
            throw new DuplicateDefinitionException("Trigger '" + triggerDefinition.getId() + "' cannot be defined as," + " " + e.getMessage(), e);
        }
        if (this.triggerDefinitionMap.containsKey(triggerDefinition.getId())) {
            throw new DuplicateDefinitionException("Trigger Definition with same Id '" + triggerDefinition.getId() + "' already exist '" + this.triggerDefinitionMap.get(triggerDefinition.getId()) + "', hence cannot add '" + triggerDefinition + "'");
        }
        this.triggerDefinitionMap.put(triggerDefinition.getId(), triggerDefinition);
        this.streamDefinitionMap.put(streamDefinition.getId(), streamDefinition);
        return this;
    }

    private void checkDuplicateDefinition(AbstractDefinition definition) {
        TableDefinition existingTableDefinition = this.tableDefinitionMap.get(definition.getId());
        if (existingTableDefinition != null && (!existingTableDefinition.equals(definition) || definition instanceof StreamDefinition)) {
            throw new DuplicateDefinitionException("Table Definition with same Stream Id '" + definition.getId() + "' already exist : " + existingTableDefinition + ", hence cannot add " + definition);
        }
        StreamDefinition existingStreamDefinition = this.streamDefinitionMap.get(definition.getId());
        if (existingStreamDefinition != null && (!existingStreamDefinition.equals(definition) || definition instanceof TableDefinition)) {
            throw new DuplicateDefinitionException("Stream Definition with same Stream Id '" + definition.getId() + "' already exist : " + existingStreamDefinition + ", hence cannot add " + definition);
        }
        WindowDefinition existingWindowDefinition = this.windowDefinitionMap.get(definition.getId());
        if (existingWindowDefinition != null && (!existingWindowDefinition.equals(definition) || definition instanceof WindowDefinition)) {
            throw new DuplicateDefinitionException("Stream Definition with same Window Id '" + definition.getId() + "' already exist : " + existingWindowDefinition + ", hence cannot add " + definition);
        }
    }

    public ExecutionPlan addQuery(Query query) {
        if (query == null) {
            throw new ExecutionPlanValidationException("Query should not be null");
        }
        String name = null;
        Element element = AnnotationHelper.getAnnotationElement("info", "name", query.getAnnotations());
        if (element != null) {
            name = element.getValue();
        }
        if (name != null && this.executionElementNameList.contains(name)) {
            throw new ExecutionPlanValidationException("Cannot add Query as another Execution Element already uses its name=" + name);
        }
        this.executionElementNameList.add(name);
        this.executionElementList.add(query);
        return this;
    }

    public ExecutionPlan addPartition(Partition partition) {
        if (partition == null) {
            throw new ExecutionPlanValidationException("Partition should not be null");
        }
        String name = null;
        Element element = AnnotationHelper.getAnnotationElement("info", "name", partition.getAnnotations());
        if (element != null) {
            name = element.getValue();
        }
        if (name != null && this.executionElementNameList.contains(name)) {
            throw new ExecutionPlanValidationException("Cannot add Partition as another Execution Element already uses its name=" + name);
        }
        this.executionElementNameList.add(name);
        this.executionElementList.add(partition);
        return this;
    }

    public ExecutionPlan annotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public List<ExecutionElement> getExecutionElementList() {
        return this.executionElementList;
    }

    public Map<String, StreamDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap;
    }

    public Map<String, TableDefinition> getTableDefinitionMap() {
        return this.tableDefinitionMap;
    }

    public Map<String, TriggerDefinition> getTriggerDefinitionMap() {
        return this.triggerDefinitionMap;
    }

    public Map<String, WindowDefinition> getWindowDefinitionMap() {
        return this.windowDefinitionMap;
    }

    public String toString() {
        return "ExecutionPlan{streamDefinitionMap=" + this.streamDefinitionMap + ", tableDefinitionMap=" + this.tableDefinitionMap + ", windowDefinitionMap=" + this.windowDefinitionMap + ", executionElementList=" + this.executionElementList + ", executionElementNameList=" + this.executionElementNameList + ", annotations=" + this.annotations + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecutionPlan)) {
            return false;
        }
        ExecutionPlan that = (ExecutionPlan)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.executionElementList != null ? !this.executionElementList.equals(that.executionElementList) : that.executionElementList != null) {
            return false;
        }
        if (this.executionElementNameList != null ? !this.executionElementNameList.equals(that.executionElementNameList) : that.executionElementNameList != null) {
            return false;
        }
        if (this.streamDefinitionMap != null ? !this.streamDefinitionMap.equals(that.streamDefinitionMap) : that.streamDefinitionMap != null) {
            return false;
        }
        return !(this.tableDefinitionMap != null ? !this.tableDefinitionMap.equals(that.tableDefinitionMap) : that.tableDefinitionMap != null);
    }

    public int hashCode() {
        int result = this.streamDefinitionMap != null ? this.streamDefinitionMap.hashCode() : 0;
        result = 31 * result + (this.tableDefinitionMap != null ? this.tableDefinitionMap.hashCode() : 0);
        result = 31 * result + (this.executionElementList != null ? this.executionElementList.hashCode() : 0);
        result = 31 * result + (this.executionElementNameList != null ? this.executionElementNameList.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    public void defineFunction(FunctionDefinition functionDefinition) {
        if (functionDefinition == null) {
            throw new ExecutionPlanValidationException("Function Definition should not be null");
        }
        if (functionDefinition.getId() == null) {
            throw new ExecutionPlanValidationException("Function Id should not be null for Function Definition");
        }
        if (functionDefinition.getReturnType() == null) {
            throw new ExecutionPlanValidationException("Return type should not be null for Function Definition");
        }
        if (functionDefinition.getBody() == null) {
            throw new ExecutionPlanValidationException("Body should not be null for Function Definition");
        }
        if (functionDefinition.getLanguage() == null) {
            throw new ExecutionPlanValidationException("Language should not be null for Function Definition");
        }
        this.checkDuplicateFunctionExist(functionDefinition);
        this.functionDefinitionMap.put(functionDefinition.getId(), functionDefinition);
    }

    private void checkDuplicateFunctionExist(FunctionDefinition functionDefinition) {
        if (this.functionDefinitionMap.get(functionDefinition.getId()) != null) {
            throw new DuplicateDefinitionException("The function definition with the same id exists " + functionDefinition.getId());
        }
    }
}

