/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.partition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.PartitionType;
import org.wso2.siddhi.query.api.execution.partition.RangePartitionType;
import org.wso2.siddhi.query.api.execution.partition.ValuePartitionType;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class Partition
implements ExecutionElement {
    private Map<String, PartitionType> partitionTypeMap = new HashMap<String, PartitionType>();
    private List<Query> queryList = new ArrayList<Query>();
    private List<String> queryNameList = new ArrayList<String>();
    private List<Annotation> annotations = new ArrayList<Annotation>();

    public static Partition partition() {
        return new Partition();
    }

    public static RangePartitionType.RangePartitionProperty range(String partitionKey, Expression condition) {
        return new RangePartitionType.RangePartitionProperty(partitionKey, condition);
    }

    public Map<String, PartitionType> getPartitionTypeMap() {
        return this.partitionTypeMap;
    }

    public Partition with(String streamId, Expression expression) {
        ValuePartitionType valuePartitionType = new ValuePartitionType(streamId, expression);
        this.addPartitionType(valuePartitionType);
        return this;
    }

    public Partition with(String streamId, RangePartitionType.RangePartitionProperty ... rangePartitionProperties) {
        RangePartitionType rangePartitionType = new RangePartitionType(streamId, rangePartitionProperties);
        this.addPartitionType(rangePartitionType);
        return this;
    }

    public Partition with(PartitionType partitionType) {
        this.addPartitionType(partitionType);
        return this;
    }

    public Partition addQuery(Query query) {
        if (query == null) {
            throw new ExecutionPlanValidationException("Query should not be null");
        }
        String name = null;
        Element element = AnnotationHelper.getAnnotationElement("info", "name", query.getAnnotations());
        if (element != null) {
            name = element.getValue();
        }
        if (name != null && this.queryNameList.contains(name)) {
            throw new ExecutionPlanValidationException("Cannot add Query as another Execution Element already uses its name=" + name + " within the same Partition");
        }
        this.queryNameList.add(name);
        this.queryList.add(query);
        return this;
    }

    private void addPartitionType(PartitionType partitionType) {
        String partitionedStream = partitionType.getStreamId();
        if (this.partitionTypeMap.containsKey(partitionedStream)) {
            throw new ExecutionPlanValidationException("Duplicate partition for Stream " + partitionedStream + "!, " + partitionType.toString() + " cannot be added as " + this.partitionTypeMap.get(partitionType.getStreamId()) + " already exist.");
        }
        this.partitionTypeMap.put(partitionType.getStreamId(), partitionType);
    }

    public List<Query> getQueryList() {
        return this.queryList;
    }

    public Partition annotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "Partition{partitionTypeMap=" + this.partitionTypeMap + ", queryList=" + this.queryList + ", annotations=" + this.annotations + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition partition = (Partition)o;
        if (this.annotations != null ? !this.annotations.equals(partition.annotations) : partition.annotations != null) {
            return false;
        }
        if (this.partitionTypeMap != null ? !this.partitionTypeMap.equals(partition.partitionTypeMap) : partition.partitionTypeMap != null) {
            return false;
        }
        return !(this.queryList != null ? !this.queryList.equals(partition.queryList) : partition.queryList != null);
    }

    public int hashCode() {
        int result = this.partitionTypeMap != null ? this.partitionTypeMap.hashCode() : 0;
        result = 31 * result + (this.queryList != null ? this.queryList.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }
}

