/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.definition;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.AttributeNotExistException;
import org.wso2.siddhi.query.api.exception.DuplicateAttributeException;

public abstract class AbstractDefinition
implements SiddhiElement {
    protected String id;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();
    protected List<Annotation> annotations = new ArrayList<Annotation>();
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    protected AbstractDefinition() {
    }

    protected AbstractDefinition(String id) {
        this.id = id;
    }

    public static Annotation annotation(String name) {
        return new Annotation(name);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    protected void checkAttribute(String attributeName) {
        for (Attribute attribute : this.attributeList) {
            if (!attribute.getName().equals(attributeName)) continue;
            throw new DuplicateAttributeException("'" + attributeName + "' is already defined for with type '" + (Object)((Object)attribute.getType()) + "' for '" + this.id + "'; " + this.toString(), attribute.getQueryContextStartIndex(), attribute.getQueryContextEndIndex());
        }
    }

    public Attribute.Type getAttributeType(String attributeName) {
        for (Attribute attribute : this.attributeList) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute.getType();
        }
        throw new AttributeNotExistException("Cannot find attribute type as '" + attributeName + "' does not exist in '" + this.id + "'; " + this.toString());
    }

    public int getAttributePosition(String attributeName) {
        int attributeListSize = this.attributeList.size();
        for (int i = 0; i < attributeListSize; ++i) {
            Attribute attribute = this.attributeList.get(i);
            if (!attribute.getName().equals(attributeName)) continue;
            return i;
        }
        throw new AttributeNotExistException("Cannot get attribute position as '" + attributeName + "' does not exist in '" + this.id + "'; " + this.toString());
    }

    public String[] getAttributeNameArray() {
        int attributeListSize = this.attributeList.size();
        String[] attributeNameArray = new String[attributeListSize];
        for (int i = 0; i < attributeListSize; ++i) {
            attributeNameArray[i] = this.attributeList.get(i).getName();
        }
        return attributeNameArray;
    }

    public String toString() {
        StringBuilder definitionBuilder = new StringBuilder();
        if (this.annotations != null && this.annotations.size() > 0) {
            for (Annotation annotation : this.annotations) {
                definitionBuilder.append(annotation.toString());
            }
        }
        definitionBuilder.append("define stream ").append(this.id).append(" (");
        boolean isFirst = true;
        for (Attribute attribute : this.attributeList) {
            if (!isFirst) {
                definitionBuilder.append(", ");
            } else {
                isFirst = false;
            }
            definitionBuilder.append(attribute.getName()).append(" ").append(attribute.getType().toString().toLowerCase());
        }
        definitionBuilder.append(")");
        return definitionBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDefinition)) {
            return false;
        }
        AbstractDefinition that = (AbstractDefinition)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.attributeList != null ? !this.attributeList.equals(that.attributeList) : that.attributeList != null) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.attributeList != null ? this.attributeList.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    public boolean equalsIgnoreAnnotations(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDefinition)) {
            return false;
        }
        AbstractDefinition that = (AbstractDefinition)o;
        if (this.attributeList != null ? !this.attributeList.equals(that.attributeList) : that.attributeList != null) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }
}

