/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query;

import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.execution.query.input.store.InputStore;
import org.wso2.siddhi.query.api.execution.query.output.stream.DeleteStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.ReturnStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateSet;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateStream;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;

public class StoreQuery
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private InputStore inputStore;
    private Selector selector = new Selector();
    private OutputStream outputStream = new ReturnStream();
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;
    private StoreQueryType type;

    public static StoreQuery query() {
        return new StoreQuery();
    }

    public StoreQuery from(InputStore inputStore) {
        this.inputStore = inputStore;
        return this;
    }

    public InputStore getInputStore() {
        return this.inputStore;
    }

    public StoreQuery select(Selector selector) {
        this.selector = selector;
        return this;
    }

    public StoreQuery outStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public void deleteBy(String outputTableId, Expression onDeletingExpression) {
        this.outputStream = new DeleteStream(outputTableId, onDeletingExpression);
    }

    public void updateBy(String outputTableId, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, onUpdateExpression);
    }

    public void updateBy(String outputTableId, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, updateSetAttributes, onUpdateExpression);
    }

    public void updateOrInsertBy(String outputTableId, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateOrInsertStream(outputTableId, updateSetAttributes, onUpdateExpression);
    }

    public Selector getSelector() {
        return this.selector;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String toString() {
        return "StoreQuery{inputStore=" + this.inputStore + ", selector=" + this.selector + ", outputStream=" + this.outputStream + ", type=" + (Object)((Object)this.type) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreQuery that = (StoreQuery)o;
        if (this.inputStore != null ? !this.inputStore.equals(that.inputStore) : that.inputStore != null) {
            return false;
        }
        if (this.outputStream != null ? !this.outputStream.equals(that.outputStream) : that.outputStream != null) {
            return false;
        }
        return this.selector != null ? this.selector.equals(that.selector) : that.selector == null;
    }

    public int hashCode() {
        int result = this.inputStore != null ? this.inputStore.hashCode() : 0;
        result = 31 * result + (this.selector != null ? this.selector.hashCode() : 0);
        result = 31 * result + (this.outputStream != null ? this.outputStream.hashCode() : 0);
        return result;
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }

    public StoreQueryType getType() {
        return this.type;
    }

    public void setType(StoreQueryType type) {
        this.type = type;
    }

    public static enum StoreQueryType {
        INSERT,
        DELETE,
        UPDATE,
        SELECT,
        UPDATE_OR_INSERT,
        FIND;

    }
}

