/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.And;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.condition.In;
import org.wso2.siddhi.query.api.expression.condition.IsNull;
import org.wso2.siddhi.query.api.expression.condition.Not;
import org.wso2.siddhi.query.api.expression.condition.Or;
import org.wso2.siddhi.query.api.expression.constant.BoolConstant;
import org.wso2.siddhi.query.api.expression.constant.DoubleConstant;
import org.wso2.siddhi.query.api.expression.constant.FloatConstant;
import org.wso2.siddhi.query.api.expression.constant.IntConstant;
import org.wso2.siddhi.query.api.expression.constant.LongConstant;
import org.wso2.siddhi.query.api.expression.constant.StringConstant;
import org.wso2.siddhi.query.api.expression.constant.TimeConstant;
import org.wso2.siddhi.query.api.expression.math.Add;
import org.wso2.siddhi.query.api.expression.math.Divide;
import org.wso2.siddhi.query.api.expression.math.Mod;
import org.wso2.siddhi.query.api.expression.math.Multiply;
import org.wso2.siddhi.query.api.expression.math.Subtract;

public abstract class Expression
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public static StringConstant value(String value) {
        return new StringConstant(value);
    }

    public static IntConstant value(int value) {
        return new IntConstant(value);
    }

    public static LongConstant value(long value) {
        return new LongConstant(value);
    }

    public static DoubleConstant value(double value) {
        return new DoubleConstant(value);
    }

    public static FloatConstant value(float value) {
        return new FloatConstant(value);
    }

    public static BoolConstant value(boolean value) {
        return new BoolConstant(value);
    }

    public static Variable variable(String attributeName) {
        return new Variable(attributeName);
    }

    public static Add add(Expression leftValue, Expression rightValue) {
        return new Add(leftValue, rightValue);
    }

    public static Subtract subtract(Expression leftValue, Expression rightValue) {
        return new Subtract(leftValue, rightValue);
    }

    public static Multiply multiply(Expression leftValue, Expression rightValue) {
        return new Multiply(leftValue, rightValue);
    }

    public static Divide divide(Expression leftValue, Expression rightValue) {
        return new Divide(leftValue, rightValue);
    }

    public static Mod mod(Expression leftValue, Expression rightValue) {
        return new Mod(leftValue, rightValue);
    }

    public static Expression function(String extensionNamespace, String extensionFunctionName, Expression ... expressions) {
        return new AttributeFunction(extensionNamespace, extensionFunctionName, expressions);
    }

    public static Expression function(String functionName, Expression ... expressions) {
        return new AttributeFunction("", functionName, expressions);
    }

    public static Expression compare(Expression leftExpression, Compare.Operator operator, Expression rightExpression) {
        return new Compare(leftExpression, operator, rightExpression);
    }

    public static Expression in(Expression leftExpression, String streamId) {
        return new In(leftExpression, streamId);
    }

    public static Expression and(Expression leftExpression, Expression rightExpression) {
        return new And(leftExpression, rightExpression);
    }

    public static Expression or(Expression leftExpression, Expression rightExpression) {
        return new Or(leftExpression, rightExpression);
    }

    public static Expression not(Expression expression) {
        return new Not(expression);
    }

    public static Expression isNull(Expression expression) {
        return new IsNull(expression);
    }

    public static Expression isNullStream(String streamId) {
        return new IsNull(streamId, null, false);
    }

    public static Expression isNullStream(String streamId, int streamIndex) {
        return new IsNull(streamId, streamIndex, false);
    }

    public static Expression isNullInnerStream(String streamId) {
        return new IsNull(streamId, null, true);
    }

    public static Expression isNullInnerStream(String streamId, int streamIndex) {
        return new IsNull(streamId, streamIndex, true);
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }

    public static abstract class Time {
        public static TimeConstant milliSec(long i) {
            return new TimeConstant(i);
        }

        public static TimeConstant milliSec(int i) {
            return Time.milliSec((long)i);
        }

        public static TimeConstant sec(long i) {
            return new TimeConstant(i * 1000L);
        }

        public static TimeConstant sec(int i) {
            return Time.sec((long)i);
        }

        public static TimeConstant minute(long i) {
            return new TimeConstant(i * 60L * 1000L);
        }

        public static TimeConstant minute(int i) {
            return Time.minute((long)i);
        }

        public static TimeConstant hour(long i) {
            return new TimeConstant(i * 60L * 60L * 1000L);
        }

        public static TimeConstant hour(int i) {
            return Time.hour((long)i);
        }

        public static TimeConstant day(long i) {
            return new TimeConstant(i * 24L * 60L * 60L * 1000L);
        }

        public static TimeConstant day(int i) {
            return Time.day((long)i);
        }

        public static TimeConstant week(long i) {
            return new TimeConstant(i * 7L * 24L * 60L * 60L * 1000L);
        }

        public static TimeConstant week(int i) {
            return Time.week((long)i);
        }

        public static TimeConstant month(long i) {
            return new TimeConstant(i * 30L * 24L * 60L * 60L * 1000L);
        }

        public static TimeConstant month(int i) {
            return Time.month((long)i);
        }

        public static TimeConstant year(long i) {
            return new TimeConstant(i * 365L * 24L * 60L * 60L * 1000L);
        }

        public static TimeConstant year(int i) {
            return Time.year((long)i);
        }

        public static Long timeToLong(String value) {
            Pattern timeValuePattern = Pattern.compile("\\d+");
            Pattern durationPattern = Pattern.compile("\\D+");
            Matcher timeMatcher = timeValuePattern.matcher(value);
            Matcher durationMatcher = durationPattern.matcher(value);
            if (timeMatcher.find() && durationMatcher.find()) {
                TimePeriod.Duration duration = Time.normalizeDuration(durationMatcher.group(0).trim());
                int timeValue = Integer.parseInt(timeMatcher.group(0));
                switch (duration) {
                    case SECONDS: {
                        return Time.sec(timeValue).value();
                    }
                    case MINUTES: {
                        return Time.minute(timeValue).value();
                    }
                    case HOURS: {
                        return Time.hour(timeValue).value();
                    }
                    case DAYS: {
                        return Time.day(timeValue).value();
                    }
                    case YEARS: {
                        return Time.year(timeValue).value();
                    }
                }
                return Time.month(timeValue).value();
            }
            throw new SiddhiAppValidationException("Provided retention parameter cannot be identified. retention period: " + value + ".");
        }

        public static TimePeriod.Duration normalizeDuration(String value) {
            switch (value.toLowerCase()) {
                case "sec": 
                case "seconds": 
                case "second": {
                    return TimePeriod.Duration.SECONDS;
                }
                case "min": 
                case "minutes": 
                case "minute": {
                    return TimePeriod.Duration.MINUTES;
                }
                case "h": 
                case "hour": 
                case "hours": {
                    return TimePeriod.Duration.HOURS;
                }
                case "days": 
                case "day": {
                    return TimePeriod.Duration.DAYS;
                }
                case "month": 
                case "months": {
                    return TimePeriod.Duration.MONTHS;
                }
                case "year": 
                case "years": {
                    return TimePeriod.Duration.YEARS;
                }
            }
            throw new SiddhiAppValidationException("Duration '" + value + "' does not exists ");
        }
    }
}

