/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.input.stream;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.execution.query.input.state.CountStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.EveryStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.NextStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;

public class StateInputStream
extends InputStream {
    private static final long serialVersionUID = 1L;
    private Type stateType;
    private StateElement stateElement;
    private List<String> streamIdList;

    public StateInputStream(Type stateType, StateElement stateElement) {
        this.stateType = stateType;
        this.stateElement = stateElement;
        this.streamIdList = this.collectStreamIds(stateElement, new ArrayList<String>());
    }

    public StateElement getStateElement() {
        return this.stateElement;
    }

    public Type getStateType() {
        return this.stateType;
    }

    @Override
    public List<String> getAllStreamIds() {
        return this.streamIdList;
    }

    @Override
    public List<String> getUniqueStreamIds() {
        ArrayList<String> uniqueStreams = new ArrayList<String>();
        for (String aStreamId : this.streamIdList) {
            if (uniqueStreams.contains(aStreamId)) continue;
            uniqueStreams.add(aStreamId);
        }
        return uniqueStreams;
    }

    private List<String> collectStreamIds(StateElement stateElement, List<String> streamIds) {
        if (stateElement instanceof LogicalStateElement) {
            this.collectStreamIds(((LogicalStateElement)stateElement).getStreamStateElement1(), streamIds);
            this.collectStreamIds(((LogicalStateElement)stateElement).getStreamStateElement2(), streamIds);
        } else if (stateElement instanceof CountStateElement) {
            this.collectStreamIds(((CountStateElement)stateElement).getStreamStateElement(), streamIds);
        } else if (stateElement instanceof EveryStateElement) {
            this.collectStreamIds(((EveryStateElement)stateElement).getStateElement(), streamIds);
        } else if (stateElement instanceof NextStateElement) {
            this.collectStreamIds(((NextStateElement)stateElement).getStateElement(), streamIds);
            this.collectStreamIds(((NextStateElement)stateElement).getNextStateElement(), streamIds);
        } else if (stateElement instanceof StreamStateElement) {
            BasicSingleInputStream basicSingleInputStream = ((StreamStateElement)stateElement).getBasicSingleInputStream();
            streamIds.add(basicSingleInputStream.getStreamId());
        }
        return streamIds;
    }

    public int getStreamCount(String streamId) {
        int count = 0;
        for (String aStreamId : this.streamIdList) {
            if (!streamId.equals(aStreamId)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "StateInputStream{stateType=" + (Object)((Object)this.stateType) + ", stateElement=" + this.stateElement + ", streamIdList=" + this.streamIdList + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateInputStream)) {
            return false;
        }
        StateInputStream that = (StateInputStream)o;
        if (this.stateElement != null ? !this.stateElement.equals(that.stateElement) : that.stateElement != null) {
            return false;
        }
        if (this.stateType != that.stateType) {
            return false;
        }
        return !(this.streamIdList != null ? !this.streamIdList.equals(that.streamIdList) : that.streamIdList != null);
    }

    public int hashCode() {
        int result = this.stateType != null ? this.stateType.hashCode() : 0;
        result = 31 * result + (this.stateElement != null ? this.stateElement.hashCode() : 0);
        result = 31 * result + (this.streamIdList != null ? this.streamIdList.hashCode() : 0);
        return result;
    }

    public static enum Type {
        PATTERN,
        SEQUENCE;

    }
}

