/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.annotation;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.annotation.Element;

public class Annotation
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private String name;
    private ArrayList<Element> elements = new ArrayList();
    private ArrayList<Annotation> annotations = new ArrayList();
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public Annotation(String name) {
        this.name = name;
    }

    public static Annotation annotation(String name) {
        return new Annotation(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
    }

    public String getElement(String key) {
        for (Element element : this.elements) {
            if (element.getKey() == null || !element.getKey().equalsIgnoreCase(key)) continue;
            return element.getValue();
        }
        return null;
    }

    public Annotation element(String key, String value) {
        this.elements.add(new Element(key, value));
        return this;
    }

    public Annotation element(String value) {
        this.elements.add(new Element(null, value));
        return this;
    }

    public Annotation element(Element element) {
        this.elements.add(element);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations.clear();
        this.annotations.addAll(annotations);
    }

    public List<Annotation> getAnnotations(String name) {
        ArrayList<Annotation> results = new ArrayList<Annotation>();
        for (Annotation annotation : this.annotations) {
            if (!annotation.getName().equalsIgnoreCase(name)) continue;
            results.add(annotation);
        }
        return results;
    }

    public Annotation annotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public String toString() {
        boolean isFirst = true;
        StringBuilder definitionBuilder = new StringBuilder("@").append(this.name).append("( ");
        if (this.elements != null && this.elements.size() > 0) {
            for (Element element : this.elements) {
                if (!isFirst) {
                    definitionBuilder.append(", ");
                } else {
                    isFirst = false;
                }
                definitionBuilder.append(element.toString());
            }
        }
        if (this.annotations != null && this.annotations.size() > 0) {
            for (Annotation annotation : this.annotations) {
                if (!isFirst) {
                    definitionBuilder.append(", ");
                } else {
                    isFirst = false;
                }
                definitionBuilder.append(annotation.toString());
            }
        }
        definitionBuilder.append(")");
        return definitionBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation that = (Annotation)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.elements != null ? !this.elements.equals(that.elements) : that.elements != null) {
            return false;
        }
        return this.annotations != null ? this.annotations.equals(that.annotations) : that.annotations == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.elements != null ? this.elements.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }
}

