/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.compiler.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.wso2.siddhi.query.api.SiddhiApp;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.aggregation.Within;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.partition.PartitionType;
import org.wso2.siddhi.query.api.execution.partition.RangePartitionType;
import org.wso2.siddhi.query.api.execution.partition.ValuePartitionType;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.StoreQuery;
import org.wso2.siddhi.query.api.execution.query.input.handler.Filter;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamFunction;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamHandler;
import org.wso2.siddhi.query.api.execution.query.input.handler.Window;
import org.wso2.siddhi.query.api.execution.query.input.state.AbsentStreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.CountStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.EveryStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.NextStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.State;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.store.InputStore;
import org.wso2.siddhi.query.api.execution.query.input.store.Store;
import org.wso2.siddhi.query.api.execution.query.input.stream.AnonymousInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.EventOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.OutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.SnapshotOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.ratelimit.TimeOutputRate;
import org.wso2.siddhi.query.api.execution.query.output.stream.DeleteStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.InsertIntoStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.ReturnStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateSet;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateStream;
import org.wso2.siddhi.query.api.execution.query.selection.BasicSelector;
import org.wso2.siddhi.query.api.execution.query.selection.OrderByAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.constant.BoolConstant;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.expression.constant.DoubleConstant;
import org.wso2.siddhi.query.api.expression.constant.FloatConstant;
import org.wso2.siddhi.query.api.expression.constant.IntConstant;
import org.wso2.siddhi.query.api.expression.constant.LongConstant;
import org.wso2.siddhi.query.api.expression.constant.StringConstant;
import org.wso2.siddhi.query.api.expression.constant.TimeConstant;
import org.wso2.siddhi.query.api.expression.math.Add;
import org.wso2.siddhi.query.api.expression.math.Multiply;
import org.wso2.siddhi.query.compiler.SiddhiQLBaseVisitor;
import org.wso2.siddhi.query.compiler.SiddhiQLParser;
import org.wso2.siddhi.query.compiler.exception.SiddhiParserException;

public class SiddhiQLBaseVisitorImpl
extends SiddhiQLBaseVisitor {
    private Set<String> activeStreams = new HashSet<String>();

    @Override
    public Object visitParse(@NotNull SiddhiQLParser.ParseContext ctx) {
        return this.visit((ParseTree)ctx.siddhi_app());
    }

    @Override
    public SiddhiApp visitSiddhi_app(@NotNull SiddhiQLParser.Siddhi_appContext ctx) {
        SiddhiApp siddhiApp = SiddhiApp.siddhiApp();
        for (SiddhiQLParser.App_annotationContext annotationContext : ctx.app_annotation()) {
            siddhiApp.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        for (SiddhiQLParser.Definition_streamContext streamContext : ctx.definition_stream()) {
            siddhiApp.defineStream((StreamDefinition)this.visit((ParseTree)streamContext));
        }
        for (SiddhiQLParser.Definition_tableContext tableContext : ctx.definition_table()) {
            siddhiApp.defineTable((TableDefinition)this.visit((ParseTree)tableContext));
        }
        for (SiddhiQLParser.Definition_functionContext functionContext : ctx.definition_function()) {
            siddhiApp.defineFunction((FunctionDefinition)this.visit((ParseTree)functionContext));
        }
        for (SiddhiQLParser.Definition_windowContext windowContext : ctx.definition_window()) {
            siddhiApp.defineWindow((WindowDefinition)this.visit((ParseTree)windowContext));
        }
        for (SiddhiQLParser.Definition_aggregationContext aggregationContext : ctx.definition_aggregation()) {
            siddhiApp.defineAggregation((AggregationDefinition)this.visit((ParseTree)aggregationContext));
        }
        for (SiddhiQLParser.Execution_elementContext executionElementContext : ctx.execution_element()) {
            ExecutionElement executionElement = (ExecutionElement)this.visit((ParseTree)executionElementContext);
            if (executionElement instanceof Partition) {
                siddhiApp.addPartition((Partition)executionElement);
                continue;
            }
            if (executionElement instanceof Query) {
                siddhiApp.addQuery((Query)executionElement);
                continue;
            }
            throw this.newSiddhiParserException(ctx);
        }
        for (SiddhiQLParser.Definition_triggerContext triggerContext : ctx.definition_trigger()) {
            siddhiApp.defineTrigger((TriggerDefinition)this.visit((ParseTree)triggerContext));
        }
        this.populateQueryContext((SiddhiElement)siddhiApp, ctx);
        return siddhiApp;
    }

    @Override
    public Object visitDefinition_stream_final(@NotNull SiddhiQLParser.Definition_stream_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_stream());
    }

    @Override
    public StreamDefinition visitDefinition_stream(@NotNull SiddhiQLParser.Definition_streamContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        if (source.isInnerStream) {
            throw this.newSiddhiParserException(ctx, " InnerStreams cannot be defined!");
        }
        try {
            StreamDefinition streamDefinition = StreamDefinition.id((String)source.streamId);
            this.populateQueryContext((SiddhiElement)streamDefinition, ctx);
            List<SiddhiQLParser.Attribute_nameContext> attribute_names = ctx.attribute_name();
            List<SiddhiQLParser.Attribute_typeContext> attribute_types = ctx.attribute_type();
            for (int i = 0; i < attribute_names.size(); ++i) {
                SiddhiQLParser.Attribute_nameContext attributeNameContext = attribute_names.get(i);
                SiddhiQLParser.Attribute_typeContext attributeTypeContext = attribute_types.get(i);
                streamDefinition.attribute((String)this.visit((ParseTree)attributeNameContext), (Attribute.Type)this.visit((ParseTree)attributeTypeContext));
            }
            for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
                streamDefinition.annotation((Annotation)this.visit((ParseTree)annotationContext));
            }
            return streamDefinition;
        }
        catch (Throwable t) {
            throw this.newSiddhiParserException(ctx, t.getMessage(), t);
        }
    }

    @Override
    public Object visitDefinition_function_final(@NotNull SiddhiQLParser.Definition_function_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_function());
    }

    @Override
    public FunctionDefinition visitDefinition_function(@NotNull SiddhiQLParser.Definition_functionContext ctx) {
        String functionName = (String)this.visitFunction_name(ctx.function_name());
        String languageName = (String)this.visitLanguage_name(ctx.language_name());
        Attribute.Type attributeType = (Attribute.Type)this.visit((ParseTree)ctx.attribute_type());
        String functionBody = (String)this.visitFunction_body(ctx.function_body());
        FunctionDefinition functionDefinition = new FunctionDefinition();
        functionDefinition.id(functionName).language(languageName).type(attributeType).body(functionBody);
        this.populateQueryContext((SiddhiElement)functionDefinition, ctx);
        return functionDefinition;
    }

    @Override
    public Object visitFunction_name(@NotNull SiddhiQLParser.Function_nameContext ctx) {
        return this.visitId(ctx.id());
    }

    @Override
    public Object visitFunction_body(@NotNull SiddhiQLParser.Function_bodyContext ctx) {
        String bodyBlock = ctx.SCRIPT().getText();
        return bodyBlock.substring(1, bodyBlock.length() - 2);
    }

    @Override
    public Object visitLanguage_name(@NotNull SiddhiQLParser.Language_nameContext ctx) {
        return this.visitId(ctx.id());
    }

    @Override
    public Object visitDefinition_trigger_final(@NotNull SiddhiQLParser.Definition_trigger_finalContext ctx) {
        return this.visitDefinition_trigger(ctx.definition_trigger());
    }

    @Override
    public Object visitDefinition_trigger(@NotNull SiddhiQLParser.Definition_triggerContext ctx) {
        TriggerDefinition triggerDefinition = TriggerDefinition.id((String)((String)this.visitTrigger_name(ctx.trigger_name())));
        if (ctx.time_value() != null) {
            triggerDefinition.atEvery(this.visitTime_value(ctx.time_value()).value());
        } else {
            triggerDefinition.at(this.visitString_value(ctx.string_value()).getValue());
        }
        this.populateQueryContext((SiddhiElement)triggerDefinition, ctx);
        return triggerDefinition;
    }

    @Override
    public Object visitTrigger_name(@NotNull SiddhiQLParser.Trigger_nameContext ctx) {
        return this.visitId(ctx.id());
    }

    @Override
    public Object visitDefinition_table_final(@NotNull SiddhiQLParser.Definition_table_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_table());
    }

    @Override
    public TableDefinition visitDefinition_table(@NotNull SiddhiQLParser.Definition_tableContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        if (source.isInnerStream) {
            throw this.newSiddhiParserException(ctx, "'#' cannot be used, because Tables can't be defined as InnerStream!");
        }
        TableDefinition tableDefinition = TableDefinition.id((String)source.streamId);
        List<SiddhiQLParser.Attribute_nameContext> attribute_names = ctx.attribute_name();
        List<SiddhiQLParser.Attribute_typeContext> attribute_types = ctx.attribute_type();
        for (int i = 0; i < attribute_names.size(); ++i) {
            SiddhiQLParser.Attribute_nameContext attributeNameContext = attribute_names.get(i);
            SiddhiQLParser.Attribute_typeContext attributeTypeContext = attribute_types.get(i);
            tableDefinition.attribute((String)this.visit((ParseTree)attributeNameContext), (Attribute.Type)this.visit((ParseTree)attributeTypeContext));
        }
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            tableDefinition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        this.populateQueryContext((SiddhiElement)tableDefinition, ctx);
        return tableDefinition;
    }

    @Override
    public Object visitDefinition_window_final(@NotNull SiddhiQLParser.Definition_window_finalContext ctx) {
        return this.visit((ParseTree)ctx.definition_window());
    }

    @Override
    public Object visitDefinition_window(@NotNull SiddhiQLParser.Definition_windowContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        if (source.isInnerStream) {
            throw this.newSiddhiParserException(ctx, "'#' cannot be used, because Windows can't be defined as InnerStream!");
        }
        WindowDefinition windowDefinition = WindowDefinition.id((String)source.streamId);
        List<SiddhiQLParser.Attribute_nameContext> attribute_names = ctx.attribute_name();
        List<SiddhiQLParser.Attribute_typeContext> attribute_types = ctx.attribute_type();
        for (int i = 0; i < attribute_names.size(); ++i) {
            SiddhiQLParser.Attribute_nameContext attributeNameContext = attribute_names.get(i);
            SiddhiQLParser.Attribute_typeContext attributeTypeContext = attribute_types.get(i);
            windowDefinition.attribute((String)this.visit((ParseTree)attributeNameContext), (Attribute.Type)this.visit((ParseTree)attributeTypeContext));
        }
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            windowDefinition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        AttributeFunction attributeFunction = (AttributeFunction)this.visit((ParseTree)ctx.function_operation());
        Window window = new Window(attributeFunction.getNamespace(), attributeFunction.getName(), attributeFunction.getParameters());
        windowDefinition.window(window);
        if (ctx.output_event_type() != null) {
            windowDefinition.setOutputEventType((OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()));
        }
        this.populateQueryContext((SiddhiElement)windowDefinition, ctx);
        return windowDefinition;
    }

    @Override
    public Object visitPartition_final(@NotNull SiddhiQLParser.Partition_finalContext ctx) {
        return this.visit((ParseTree)ctx.partition());
    }

    @Override
    public Partition visitPartition(@NotNull SiddhiQLParser.PartitionContext ctx) {
        Partition partition = Partition.partition();
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            partition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        for (SiddhiQLParser.Partition_with_streamContext with_streamContext : ctx.partition_with_stream()) {
            partition.with((PartitionType)this.visit((ParseTree)with_streamContext));
        }
        for (SiddhiQLParser.QueryContext queryContext : ctx.query()) {
            partition.addQuery((Query)this.visit((ParseTree)queryContext));
        }
        this.populateQueryContext((SiddhiElement)partition, ctx);
        return partition;
    }

    @Override
    public PartitionType visitPartition_with_stream(@NotNull SiddhiQLParser.Partition_with_streamContext ctx) {
        String streamId = (String)this.visit((ParseTree)ctx.stream_id());
        this.activeStreams.add(streamId);
        try {
            if (ctx.condition_ranges() != null) {
                RangePartitionType partitionType = new RangePartitionType(streamId, (RangePartitionType.RangePartitionProperty[])this.visit((ParseTree)ctx.condition_ranges()));
                this.populateQueryContext((SiddhiElement)partitionType, ctx);
                RangePartitionType rangePartitionType = partitionType;
                return rangePartitionType;
            }
            if (ctx.attribute() != null) {
                ValuePartitionType partitionType = new ValuePartitionType(streamId, (Expression)this.visit((ParseTree)ctx.attribute()));
                this.populateQueryContext((SiddhiElement)partitionType, ctx);
                ValuePartitionType valuePartitionType = partitionType;
                return valuePartitionType;
            }
            throw this.newSiddhiParserException(ctx);
        }
        finally {
            this.activeStreams.clear();
        }
    }

    @Override
    public RangePartitionType.RangePartitionProperty[] visitCondition_ranges(@NotNull SiddhiQLParser.Condition_rangesContext ctx) {
        RangePartitionType.RangePartitionProperty[] rangePartitionProperties = new RangePartitionType.RangePartitionProperty[ctx.condition_range().size()];
        List<SiddhiQLParser.Condition_rangeContext> condition_range = ctx.condition_range();
        for (int i = 0; i < condition_range.size(); ++i) {
            SiddhiQLParser.Condition_rangeContext rangeContext = condition_range.get(i);
            rangePartitionProperties[i] = (RangePartitionType.RangePartitionProperty)this.visit((ParseTree)rangeContext);
        }
        return rangePartitionProperties;
    }

    @Override
    public Object visitCondition_range(@NotNull SiddhiQLParser.Condition_rangeContext ctx) {
        RangePartitionType.RangePartitionProperty rangePartitionProperty = new RangePartitionType.RangePartitionProperty(((StringConstant)this.visit((ParseTree)ctx.string_value())).getValue(), (Expression)this.visit((ParseTree)ctx.expression()));
        this.populateQueryContext((SiddhiElement)rangePartitionProperty, ctx);
        return rangePartitionProperty;
    }

    @Override
    public Object visitQuery_final(@NotNull SiddhiQLParser.Query_finalContext ctx) {
        return this.visit((ParseTree)ctx.query());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query visitQuery(@NotNull SiddhiQLParser.QueryContext ctx) {
        try {
            Query query = Query.query().from((InputStream)this.visit((ParseTree)ctx.query_input()));
            if (ctx.query_section() != null) {
                query.select((Selector)this.visit((ParseTree)ctx.query_section()));
            }
            if (ctx.output_rate() != null) {
                query.output((OutputRate)this.visit((ParseTree)ctx.output_rate()));
            }
            for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
                query.annotation((Annotation)this.visit((ParseTree)annotationContext));
            }
            if (ctx.query_output() != null) {
                query.outStream((OutputStream)this.visit((ParseTree)ctx.query_output()));
            }
            this.populateQueryContext((SiddhiElement)query, ctx);
            Query query2 = query;
            return query2;
        }
        finally {
            this.activeStreams.clear();
        }
    }

    @Override
    public Annotation visitApp_annotation(@NotNull SiddhiQLParser.App_annotationContext ctx) {
        Annotation annotation = new Annotation((String)this.visit((ParseTree)ctx.name()));
        for (SiddhiQLParser.Annotation_elementContext elementContext : ctx.annotation_element()) {
            annotation.element((Element)this.visit((ParseTree)elementContext));
        }
        this.populateQueryContext((SiddhiElement)annotation, ctx);
        return annotation;
    }

    @Override
    public Annotation visitAnnotation(@NotNull SiddhiQLParser.AnnotationContext ctx) {
        Annotation annotation = Annotation.annotation((String)((String)this.visit((ParseTree)ctx.name())));
        for (SiddhiQLParser.Annotation_elementContext elementContext : ctx.annotation_element()) {
            annotation.element((Element)this.visit((ParseTree)elementContext));
        }
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            annotation.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        this.populateQueryContext((SiddhiElement)annotation, ctx);
        return annotation;
    }

    @Override
    public Element visitAnnotation_element(@NotNull SiddhiQLParser.Annotation_elementContext ctx) {
        Element element = ctx.property_name() != null ? new Element((String)this.visit((ParseTree)ctx.property_name()), ((StringConstant)this.visit((ParseTree)ctx.property_value())).getValue()) : new Element(null, ((StringConstant)this.visit((ParseTree)ctx.property_value())).getValue());
        this.populateQueryContext((SiddhiElement)element, ctx);
        return element;
    }

    @Override
    public SingleInputStream visitStandard_stream(@NotNull SiddhiQLParser.Standard_streamContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        BasicSingleInputStream basicSingleInputStream = new BasicSingleInputStream(null, source.streamId, source.isInnerStream);
        if (ctx.pre_window_handlers != null) {
            basicSingleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.pre_window_handlers));
        }
        if (ctx.window() == null && ctx.post_window_handlers == null) {
            this.populateQueryContext((SiddhiElement)basicSingleInputStream, ctx);
            return basicSingleInputStream;
        }
        if (ctx.window() != null) {
            SingleInputStream singleInputStream = new SingleInputStream(basicSingleInputStream, (Window)this.visit((ParseTree)ctx.window()));
            if (ctx.post_window_handlers != null) {
                singleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.post_window_handlers));
            }
            this.populateQueryContext((SiddhiElement)singleInputStream, ctx);
            return singleInputStream;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitJoin_stream(@NotNull SiddhiQLParser.Join_streamContext ctx) {
        SingleInputStream leftStream = (SingleInputStream)this.visit((ParseTree)ctx.left_source);
        SingleInputStream rightStream = (SingleInputStream)this.visit((ParseTree)ctx.right_source);
        JoinInputStream.Type joinType = (JoinInputStream.Type)this.visit((ParseTree)ctx.join());
        JoinInputStream.EventTrigger eventTrigger = null;
        Expression onCondition = null;
        Within within = null;
        Expression per = null;
        if (ctx.within_time_range() != null) {
            within = (Within)this.visit((ParseTree)ctx.within_time_range());
        }
        if (ctx.per() != null) {
            per = (Expression)this.visit((ParseTree)ctx.per());
        }
        if (ctx.expression() != null) {
            onCondition = (Expression)this.visit((ParseTree)ctx.expression());
        }
        eventTrigger = ctx.right_unidirectional != null ? JoinInputStream.EventTrigger.RIGHT : (ctx.left_unidirectional != null ? JoinInputStream.EventTrigger.LEFT : JoinInputStream.EventTrigger.ALL);
        InputStream inputStream = InputStream.joinStream((SingleInputStream)leftStream, (JoinInputStream.Type)joinType, (SingleInputStream)rightStream, (Expression)onCondition, (JoinInputStream.EventTrigger)eventTrigger, (Within)within, (Expression)per);
        this.populateQueryContext((SiddhiElement)inputStream, ctx);
        return inputStream;
    }

    @Override
    public Object visitJoin_source(@NotNull SiddhiQLParser.Join_sourceContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        String streamAlias = null;
        if (ctx.alias() != null) {
            streamAlias = (String)this.visit((ParseTree)ctx.alias());
            this.activeStreams.remove(ctx.source().getText());
            this.activeStreams.add(streamAlias);
        }
        BasicSingleInputStream basicSingleInputStream = new BasicSingleInputStream(streamAlias, source.streamId, source.isInnerStream);
        if (ctx.basic_source_stream_handlers() != null) {
            basicSingleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.basic_source_stream_handlers()));
        }
        if (ctx.window() != null) {
            SingleInputStream inputStream = new SingleInputStream(basicSingleInputStream, (Window)this.visit((ParseTree)ctx.window()));
            this.populateQueryContext((SiddhiElement)inputStream, ctx);
            return inputStream;
        }
        this.populateQueryContext((SiddhiElement)basicSingleInputStream, ctx);
        return basicSingleInputStream;
    }

    @Override
    public Object visitPattern_stream(@NotNull SiddhiQLParser.Pattern_streamContext ctx) {
        StateElement stateElement = ctx.every_pattern_source_chain() != null ? (StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain()) : (StateElement)this.visit((ParseTree)ctx.absent_pattern_source_chain());
        StateInputStream stateInputStream = new StateInputStream(StateInputStream.Type.PATTERN, stateElement);
        this.populateQueryContext((SiddhiElement)stateInputStream, ctx);
        return stateInputStream;
    }

    @Override
    public Object visitEvery_pattern_source_chain(@NotNull SiddhiQLParser.Every_pattern_source_chainContext ctx) {
        if (ctx.every_pattern_source_chain().size() == 1) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        if (ctx.every_pattern_source_chain().size() == 2) {
            NextStateElement nextStateElement = new NextStateElement((StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain(0)), (StateElement)this.visit((ParseTree)ctx.every_pattern_source_chain(1)));
            this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
            return nextStateElement;
        }
        if (ctx.EVERY() != null) {
            if (ctx.pattern_source_chain() != null) {
                EveryStateElement everyStateElement = new EveryStateElement((StateElement)this.visit((ParseTree)ctx.pattern_source_chain()));
                if (ctx.within_time() != null) {
                    everyStateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
                }
                this.populateQueryContext((SiddhiElement)everyStateElement, ctx);
                return everyStateElement;
            }
            if (ctx.pattern_source() != null) {
                EveryStateElement everyStateElement = new EveryStateElement((StateElement)this.visit((ParseTree)ctx.pattern_source()));
                if (ctx.within_time() != null) {
                    everyStateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
                }
                this.populateQueryContext((SiddhiElement)everyStateElement, ctx);
                return everyStateElement;
            }
            throw this.newSiddhiParserException(ctx);
        }
        if (ctx.pattern_source_chain() != null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.pattern_source_chain());
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitPattern_source_chain(@NotNull SiddhiQLParser.Pattern_source_chainContext ctx) {
        if (ctx.pattern_source_chain().size() == 1) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.pattern_source_chain(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        if (ctx.pattern_source_chain().size() == 2) {
            NextStateElement nextStateElement = new NextStateElement((StateElement)this.visit((ParseTree)ctx.pattern_source_chain(0)), (StateElement)this.visit((ParseTree)ctx.pattern_source_chain(1)));
            this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
            return nextStateElement;
        }
        if (ctx.pattern_source() != null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.pattern_source());
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitAbsent_pattern_source_chain(SiddhiQLParser.Absent_pattern_source_chainContext ctx) {
        if (ctx.absent_pattern_source_chain() != null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.absent_pattern_source_chain());
            if (ctx.EVERY() != null) {
                stateElement = new EveryStateElement(stateElement);
            }
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        return this.visit(ctx.getChild(0));
    }

    @Override
    public Object visitLeft_absent_pattern_source(SiddhiQLParser.Left_absent_pattern_sourceContext ctx) {
        if (ctx.left_absent_pattern_source().size() == 1 && ctx.every_absent_pattern_source() == null && ctx.every_pattern_source_chain() == null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.left_absent_pattern_source(0));
            if (ctx.EVERY() != null) {
                stateElement = new EveryStateElement(stateElement);
            }
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        NextStateElement nextStateElement = new NextStateElement((StateElement)this.visit(ctx.getChild(0)), (StateElement)this.visit(ctx.getChild(2)));
        this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
        return nextStateElement;
    }

    @Override
    public Object visitRight_absent_pattern_source(SiddhiQLParser.Right_absent_pattern_sourceContext ctx) {
        if (ctx.right_absent_pattern_source().size() == 1 && ctx.every_absent_pattern_source() == null && ctx.every_pattern_source_chain() == null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.right_absent_pattern_source(0));
            if (ctx.EVERY() != null) {
                stateElement = new EveryStateElement(stateElement);
            }
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        NextStateElement nextStateElement = new NextStateElement((StateElement)this.visit(ctx.getChild(0)), (StateElement)this.visit(ctx.getChild(2)));
        this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
        return nextStateElement;
    }

    @Override
    public Object visitEvery_absent_pattern_source(SiddhiQLParser.Every_absent_pattern_sourceContext ctx) {
        StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.basic_absent_pattern_source());
        if (ctx.EVERY() != null) {
            stateElement = new EveryStateElement(stateElement);
        }
        this.populateQueryContext((SiddhiElement)stateElement, ctx);
        return stateElement;
    }

    @Override
    public Object visitFor_time(SiddhiQLParser.For_timeContext ctx) {
        return this.visit((ParseTree)ctx.time_value());
    }

    @Override
    public Object visitBasic_absent_pattern_source(SiddhiQLParser.Basic_absent_pattern_sourceContext ctx) {
        AbsentStreamStateElement stateElement = State.logicalNot((StreamStateElement)new StreamStateElement((BasicSingleInputStream)this.visit((ParseTree)ctx.basic_source())));
        stateElement.waitingTime((TimeConstant)this.visit((ParseTree)ctx.for_time()));
        this.populateQueryContext((SiddhiElement)stateElement, ctx);
        return stateElement;
    }

    @Override
    public Object visitLogical_absent_stateful_source(SiddhiQLParser.Logical_absent_stateful_sourceContext ctx) {
        if (ctx.logical_absent_stateful_source() != null) {
            return this.visit((ParseTree)ctx.logical_absent_stateful_source());
        }
        if (ctx.AND() != null) {
            if (ctx.basic_absent_pattern_source().size() == 2) {
                StateElement stateElement = State.logicalNotAnd((AbsentStreamStateElement)((AbsentStreamStateElement)this.visit((ParseTree)ctx.basic_absent_pattern_source(0))), (StreamStateElement)((AbsentStreamStateElement)this.visit((ParseTree)ctx.basic_absent_pattern_source(1))));
                this.populateQueryContext((SiddhiElement)stateElement, ctx);
                return stateElement;
            }
            StreamStateElement presentStreamState = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source());
            AbsentStreamStateElement absentStreamState = !ctx.basic_absent_pattern_source().isEmpty() ? (AbsentStreamStateElement)this.visit((ParseTree)ctx.basic_absent_pattern_source(0)) : State.logicalNot((StreamStateElement)new StreamStateElement((BasicSingleInputStream)this.visit((ParseTree)ctx.basic_source())));
            StateElement stateElement = State.logicalNotAnd((AbsentStreamStateElement)absentStreamState, (StreamStateElement)presentStreamState);
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        if (ctx.OR() != null) {
            if (ctx.basic_absent_pattern_source().size() == 2) {
                return State.logicalOr((StreamStateElement)((AbsentStreamStateElement)this.visit((ParseTree)ctx.basic_absent_pattern_source(0))), (StreamStateElement)((AbsentStreamStateElement)this.visit((ParseTree)ctx.basic_absent_pattern_source(1))));
            }
            StreamStateElement streamStateElement1 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source());
            AbsentStreamStateElement streamStateElement2 = (AbsentStreamStateElement)this.visit((ParseTree)ctx.basic_absent_pattern_source(0));
            StateElement stateElement = State.logicalOr((StreamStateElement)streamStateElement2, (StreamStateElement)streamStateElement1);
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitLogical_stateful_source(@NotNull SiddhiQLParser.Logical_stateful_sourceContext ctx) {
        if (ctx.AND() != null) {
            StreamStateElement streamStateElement1 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(0));
            StreamStateElement streamStateElement2 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(1));
            StateElement stateElement = State.logicalAnd((StreamStateElement)streamStateElement1, (StreamStateElement)streamStateElement2);
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        if (ctx.OR() != null) {
            StreamStateElement streamStateElement1 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(0));
            StreamStateElement streamStateElement2 = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source(1));
            StateElement stateElement = State.logicalOr((StreamStateElement)streamStateElement1, (StreamStateElement)streamStateElement2);
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public CountStateElement visitPattern_collection_stateful_source(@NotNull SiddhiQLParser.Pattern_collection_stateful_sourceContext ctx) {
        StreamStateElement streamStateElement = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source());
        if (ctx.collect() != null) {
            Object[] minMax = (Object[])this.visit((ParseTree)ctx.collect());
            int min = -1;
            int max = -1;
            if (minMax[0] != null) {
                min = (Integer)minMax[0];
            }
            if (minMax[1] != null) {
                max = (Integer)minMax[1];
            }
            CountStateElement stateElement = new CountStateElement(streamStateElement, min, max);
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public StateInputStream visitSequence_stream(@NotNull SiddhiQLParser.Sequence_streamContext ctx) {
        if (ctx.every_sequence_source_chain() != null) {
            StateInputStream stateInputStream = (StateInputStream)this.visitEvery_sequence_source_chain(ctx.every_sequence_source_chain());
            this.populateQueryContext((SiddhiElement)stateInputStream, ctx);
            return stateInputStream;
        }
        StateInputStream stateInputStream = (StateInputStream)this.visitEvery_absent_sequence_source_chain(ctx.every_absent_sequence_source_chain());
        this.populateQueryContext((SiddhiElement)stateInputStream, ctx);
        return stateInputStream;
    }

    @Override
    public Object visitEvery_sequence_source_chain(SiddhiQLParser.Every_sequence_source_chainContext ctx) {
        Object stateElement1 = ctx.EVERY() != null ? new EveryStateElement((StateElement)this.visit((ParseTree)ctx.sequence_source())) : (StateElement)this.visit((ParseTree)ctx.sequence_source());
        if (ctx.within_time() != null) {
            stateElement1.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
        }
        this.populateQueryContext((SiddhiElement)stateElement1, ctx);
        NextStateElement nextStateElement = new NextStateElement(stateElement1, (StateElement)this.visit((ParseTree)ctx.sequence_source_chain()));
        this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
        StateInputStream stateInputStream = new StateInputStream(StateInputStream.Type.SEQUENCE, (StateElement)nextStateElement);
        this.populateQueryContext((SiddhiElement)stateInputStream, ctx);
        return stateInputStream;
    }

    @Override
    public Object visitEvery_absent_sequence_source_chain(SiddhiQLParser.Every_absent_sequence_source_chainContext ctx) {
        Object stateElement1 = ctx.EVERY() != null ? new EveryStateElement((StateElement)this.visit(ctx.getChild(1))) : (StateElement)this.visit(ctx.getChild(0));
        if (ctx.within_time() != null) {
            stateElement1.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
        }
        StateElement stateElement2 = (StateElement)this.visit(ctx.getChild(ctx.getChildCount() - 1));
        this.populateQueryContext((SiddhiElement)stateElement1, ctx);
        this.populateQueryContext((SiddhiElement)stateElement2, ctx);
        NextStateElement nextStateElement = new NextStateElement(stateElement1, stateElement2);
        this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
        StateInputStream stateInputStream = new StateInputStream(StateInputStream.Type.SEQUENCE, (StateElement)nextStateElement);
        this.populateQueryContext((SiddhiElement)stateInputStream, ctx);
        return stateInputStream;
    }

    @Override
    public Object visitAbsent_sequence_source_chain(SiddhiQLParser.Absent_sequence_source_chainContext ctx) {
        StateElement stateElement;
        if (ctx.absent_sequence_source_chain() != null) {
            stateElement = (StateElement)this.visit((ParseTree)ctx.absent_sequence_source_chain());
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
        } else {
            stateElement = (StateElement)this.visit(ctx.getChild(0));
        }
        this.populateQueryContext((SiddhiElement)stateElement, ctx);
        return stateElement;
    }

    @Override
    public Object visitLeft_absent_sequence_source(SiddhiQLParser.Left_absent_sequence_sourceContext ctx) {
        if (ctx.left_absent_sequence_source().size() == 1 && ctx.basic_absent_pattern_source() == null && ctx.sequence_source_chain() == null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.left_absent_sequence_source(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        NextStateElement nextStateElement = new NextStateElement((StateElement)this.visit(ctx.getChild(0)), (StateElement)this.visit(ctx.getChild(2)));
        this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
        return nextStateElement;
    }

    @Override
    public Object visitRight_absent_sequence_source(SiddhiQLParser.Right_absent_sequence_sourceContext ctx) {
        if (ctx.right_absent_sequence_source().size() == 1 && ctx.basic_absent_pattern_source() == null && ctx.sequence_source_chain() == null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.right_absent_sequence_source(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        NextStateElement nextStateElement = new NextStateElement((StateElement)this.visit(ctx.getChild(0)), (StateElement)this.visit(ctx.getChild(2)));
        this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
        return nextStateElement;
    }

    @Override
    public StateElement visitSequence_source_chain(@NotNull SiddhiQLParser.Sequence_source_chainContext ctx) {
        if (ctx.sequence_source_chain().size() == 1) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.sequence_source_chain(0));
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        if (ctx.sequence_source_chain().size() == 2) {
            NextStateElement nextStateElement = new NextStateElement((StateElement)this.visit((ParseTree)ctx.sequence_source_chain(0)), (StateElement)this.visit((ParseTree)ctx.sequence_source_chain(1)));
            this.populateQueryContext((SiddhiElement)nextStateElement, ctx);
            return nextStateElement;
        }
        if (ctx.sequence_source() != null) {
            StateElement stateElement = (StateElement)this.visit((ParseTree)ctx.sequence_source());
            if (ctx.within_time() != null) {
                stateElement.setWithin((TimeConstant)this.visit((ParseTree)ctx.within_time()));
            }
            this.populateQueryContext((SiddhiElement)stateElement, ctx);
            return stateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public BasicSingleInputStream visitBasic_source(@NotNull SiddhiQLParser.Basic_sourceContext ctx) {
        Source source = (Source)this.visit((ParseTree)ctx.source());
        BasicSingleInputStream basicSingleInputStream = new BasicSingleInputStream(null, source.streamId, source.isInnerStream);
        if (ctx.basic_source_stream_handlers() != null) {
            basicSingleInputStream.addStreamHandlers((List)this.visit((ParseTree)ctx.basic_source_stream_handlers()));
        }
        this.populateQueryContext((SiddhiElement)basicSingleInputStream, ctx);
        return basicSingleInputStream;
    }

    @Override
    public List<StreamHandler> visitBasic_source_stream_handlers(@NotNull SiddhiQLParser.Basic_source_stream_handlersContext ctx) {
        ArrayList<StreamHandler> streamHandlers = new ArrayList<StreamHandler>();
        for (SiddhiQLParser.Basic_source_stream_handlerContext handlerContext : ctx.basic_source_stream_handler()) {
            streamHandlers.add((StreamHandler)this.visit((ParseTree)handlerContext));
        }
        return streamHandlers;
    }

    @Override
    public String visitEvent(@NotNull SiddhiQLParser.EventContext ctx) {
        return ctx.getText();
    }

    @Override
    public StreamStateElement visitStandard_stateful_source(@NotNull SiddhiQLParser.Standard_stateful_sourceContext ctx) {
        if (ctx.event() != null) {
            this.activeStreams.add(this.visitEvent(ctx.event()));
        }
        BasicSingleInputStream basicSingleInputStream = (BasicSingleInputStream)this.visit((ParseTree)ctx.basic_source());
        if (ctx.event() != null) {
            if (basicSingleInputStream.isInnerStream()) {
                this.activeStreams.remove("#" + basicSingleInputStream.getStreamId());
            } else {
                this.activeStreams.remove(basicSingleInputStream.getStreamId());
            }
            StreamStateElement streamStateElement = new StreamStateElement(basicSingleInputStream.as((String)this.visit((ParseTree)ctx.event())));
            this.populateQueryContext((SiddhiElement)streamStateElement, ctx);
            return streamStateElement;
        }
        StreamStateElement streamStateElement = new StreamStateElement(basicSingleInputStream);
        this.populateQueryContext((SiddhiElement)streamStateElement, ctx);
        return streamStateElement;
    }

    @Override
    public CountStateElement visitSequence_collection_stateful_source(@NotNull SiddhiQLParser.Sequence_collection_stateful_sourceContext ctx) {
        StreamStateElement streamStateElement = (StreamStateElement)this.visit((ParseTree)ctx.standard_stateful_source());
        if (ctx.one_or_more != null) {
            CountStateElement countStateElement = new CountStateElement(streamStateElement, 1, -1);
            this.populateQueryContext((SiddhiElement)countStateElement, ctx);
            return countStateElement;
        }
        if (ctx.zero_or_more != null) {
            CountStateElement countStateElement = new CountStateElement(streamStateElement, 0, -1);
            this.populateQueryContext((SiddhiElement)countStateElement, ctx);
            return countStateElement;
        }
        if (ctx.zero_or_one != null) {
            CountStateElement countStateElement = new CountStateElement(streamStateElement, 0, 1);
            this.populateQueryContext((SiddhiElement)countStateElement, ctx);
            return countStateElement;
        }
        if (ctx.collect() != null) {
            Object[] minMax = (Object[])this.visit((ParseTree)ctx.collect());
            int min = -1;
            int max = -1;
            if (minMax[0] != null) {
                min = (Integer)minMax[0];
            }
            if (minMax[1] != null) {
                max = (Integer)minMax[1];
            }
            CountStateElement countStateElement = new CountStateElement(streamStateElement, min, max);
            this.populateQueryContext((SiddhiElement)countStateElement, ctx);
            return countStateElement;
        }
        throw this.newSiddhiParserException(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnonymousInputStream visitAnonymous_stream(@NotNull SiddhiQLParser.Anonymous_streamContext ctx) {
        if (ctx.anonymous_stream() != null) {
            return (AnonymousInputStream)this.visit((ParseTree)ctx.anonymous_stream());
        }
        Set<String> activeStreamsBackup = this.activeStreams;
        try {
            this.activeStreams = new HashSet<String>();
            Query query = Query.query().from((InputStream)this.visit((ParseTree)ctx.query_input()));
            if (ctx.query_section() != null) {
                query.select((Selector)this.visit((ParseTree)ctx.query_section()));
            }
            if (ctx.output_rate() != null) {
                query.output((OutputRate)this.visit((ParseTree)ctx.output_rate()));
            }
            if (ctx.output_event_type() != null) {
                query.outStream((OutputStream)new ReturnStream((OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type())));
            } else {
                query.outStream((OutputStream)new ReturnStream());
            }
            AnonymousInputStream anonymousInputStream = new AnonymousInputStream(query);
            this.populateQueryContext((SiddhiElement)anonymousInputStream, ctx);
            AnonymousInputStream anonymousInputStream2 = anonymousInputStream;
            return anonymousInputStream2;
        }
        finally {
            this.activeStreams.clear();
            this.activeStreams = activeStreamsBackup;
        }
    }

    @Override
    public Filter visitFilter(@NotNull SiddhiQLParser.FilterContext ctx) {
        Filter filter = new Filter((Expression)this.visit((ParseTree)ctx.expression()));
        this.populateQueryContext((SiddhiElement)filter, ctx);
        return filter;
    }

    @Override
    public StreamFunction visitStream_function(@NotNull SiddhiQLParser.Stream_functionContext ctx) {
        AttributeFunction attributeFunction = (AttributeFunction)this.visit((ParseTree)ctx.function_operation());
        StreamFunction streamFunction = new StreamFunction(attributeFunction.getNamespace(), attributeFunction.getName(), attributeFunction.getParameters());
        this.populateQueryContext((SiddhiElement)streamFunction, ctx);
        return streamFunction;
    }

    @Override
    public Window visitWindow(@NotNull SiddhiQLParser.WindowContext ctx) {
        AttributeFunction attributeFunction = (AttributeFunction)this.visit((ParseTree)ctx.function_operation());
        Window window = new Window(attributeFunction.getNamespace(), attributeFunction.getName(), attributeFunction.getParameters());
        this.populateQueryContext((SiddhiElement)window, ctx);
        return window;
    }

    @Override
    public BasicSelector visitGroup_by_query_selection(@NotNull SiddhiQLParser.Group_by_query_selectionContext ctx) {
        BasicSelector selector = new BasicSelector();
        ArrayList<OutputAttribute> attributeList = new ArrayList<OutputAttribute>(ctx.output_attribute().size());
        for (SiddhiQLParser.Output_attributeContext output_attributeContext : ctx.output_attribute()) {
            attributeList.add((OutputAttribute)this.visit((ParseTree)output_attributeContext));
        }
        selector.addSelectionList(attributeList);
        if (ctx.group_by() != null) {
            selector.addGroupByList((List)this.visit((ParseTree)ctx.group_by()));
        }
        this.populateQueryContext((SiddhiElement)selector, ctx);
        return selector;
    }

    @Override
    public Selector visitQuery_section(@NotNull SiddhiQLParser.Query_sectionContext ctx) {
        Selector selector = new Selector();
        ArrayList<OutputAttribute> attributeList = new ArrayList<OutputAttribute>(ctx.output_attribute().size());
        for (SiddhiQLParser.Output_attributeContext output_attributeContext : ctx.output_attribute()) {
            attributeList.add((OutputAttribute)this.visit((ParseTree)output_attributeContext));
        }
        selector.addSelectionList(attributeList);
        if (ctx.group_by() != null) {
            selector.addGroupByList((List)this.visit((ParseTree)ctx.group_by()));
        }
        if (ctx.having() != null) {
            selector.having((Expression)this.visit((ParseTree)ctx.having()));
        }
        if (ctx.order_by() != null) {
            selector.addOrderByList((List)this.visit((ParseTree)ctx.order_by()));
        }
        if (ctx.limit() != null) {
            selector.limit((Constant)this.visit((ParseTree)ctx.limit()));
        }
        if (ctx.offset() != null) {
            selector.offset((Constant)this.visit((ParseTree)ctx.offset()));
        }
        this.populateQueryContext((SiddhiElement)selector, ctx);
        return selector;
    }

    @Override
    public List<Variable> visitGroup_by(@NotNull SiddhiQLParser.Group_byContext ctx) {
        ArrayList<Variable> variableList = new ArrayList<Variable>(ctx.attribute_reference().size());
        for (SiddhiQLParser.Attribute_referenceContext attributeReferenceContext : ctx.attribute_reference()) {
            variableList.add((Variable)this.visit((ParseTree)attributeReferenceContext));
        }
        return variableList;
    }

    @Override
    public Expression visitHaving(@NotNull SiddhiQLParser.HavingContext ctx) {
        return (Expression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public List<OrderByAttribute> visitOrder_by(SiddhiQLParser.Order_byContext ctx) {
        ArrayList<OrderByAttribute> orderByAttributes = new ArrayList<OrderByAttribute>(ctx.order_by_reference().size());
        for (SiddhiQLParser.Order_by_referenceContext order_by_referenceContext : ctx.order_by_reference()) {
            OrderByAttribute orderByAttribute = (OrderByAttribute)this.visit((ParseTree)order_by_referenceContext);
            orderByAttributes.add(orderByAttribute);
        }
        return orderByAttributes;
    }

    @Override
    public OrderByAttribute visitOrder_by_reference(SiddhiQLParser.Order_by_referenceContext ctx) {
        Variable variable = (Variable)this.visit((ParseTree)ctx.attribute_reference());
        if (ctx.order() != null && ctx.order().DESC() != null) {
            return new OrderByAttribute(variable, OrderByAttribute.Order.DESC);
        }
        return new OrderByAttribute(variable);
    }

    @Override
    public Constant visitLimit(SiddhiQLParser.LimitContext ctx) {
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
        if (expression instanceof Constant) {
            this.populateQueryContext((SiddhiElement)expression, ctx);
            return (Constant)expression;
        }
        throw this.newSiddhiParserException(ctx, "'limit' only accepts int and long constants but found '" + expression + "'");
    }

    @Override
    public Object visitOffset(SiddhiQLParser.OffsetContext ctx) {
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
        if (expression instanceof Constant) {
            this.populateQueryContext((SiddhiElement)expression, ctx);
            return (Constant)expression;
        }
        throw this.newSiddhiParserException(ctx, "'offset' only accepts int and long constants but found '" + expression + "'");
    }

    @Override
    public OutputStream visitQuery_output(@NotNull SiddhiQLParser.Query_outputContext ctx) {
        if (ctx.INSERT() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (ctx.UPDATE() != null && ctx.OR() != null) {
                if (source.isInnerStream) {
                    throw this.newSiddhiParserException(ctx, "UPDATE OR INTO INSERT be only used with Tables!");
                }
                if (ctx.output_event_type() != null) {
                    if (ctx.set_clause() != null) {
                        UpdateOrInsertStream outputStream = new UpdateOrInsertStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (UpdateSet)this.visit((ParseTree)ctx.set_clause()), (Expression)this.visit((ParseTree)ctx.expression()));
                        this.populateQueryContext((SiddhiElement)outputStream, ctx);
                        return outputStream;
                    }
                    UpdateOrInsertStream outputStream = new UpdateOrInsertStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (Expression)this.visit((ParseTree)ctx.expression()));
                    this.populateQueryContext((SiddhiElement)outputStream, ctx);
                    return outputStream;
                }
                if (ctx.set_clause() != null) {
                    UpdateOrInsertStream outputStream = new UpdateOrInsertStream(source.streamId, (UpdateSet)this.visit((ParseTree)ctx.set_clause()), (Expression)this.visit((ParseTree)ctx.expression()));
                    this.populateQueryContext((SiddhiElement)outputStream, ctx);
                    return outputStream;
                }
                UpdateOrInsertStream outputStream = new UpdateOrInsertStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                return outputStream;
            }
            if (ctx.output_event_type() != null) {
                InsertIntoStream outputStream = new InsertIntoStream(source.streamId, source.isInnerStream, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()));
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                return outputStream;
            }
            InsertIntoStream outputStream = new InsertIntoStream(source.streamId, source.isInnerStream);
            this.populateQueryContext((SiddhiElement)outputStream, ctx);
            return outputStream;
        }
        if (ctx.DELETE() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (source.isInnerStream) {
                throw this.newSiddhiParserException(ctx, "DELETE can be only used with Tables!");
            }
            if (ctx.output_event_type() != null) {
                DeleteStream outputStream = new DeleteStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (Expression)this.visit((ParseTree)ctx.expression()));
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                return outputStream;
            }
            DeleteStream outputStream = new DeleteStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
            this.populateQueryContext((SiddhiElement)outputStream, ctx);
            return outputStream;
        }
        if (ctx.UPDATE() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (source.isInnerStream) {
                throw this.newSiddhiParserException(ctx, "UPDATE can be only used with Tables!");
            }
            if (ctx.output_event_type() != null) {
                if (ctx.set_clause() != null) {
                    UpdateStream outputStream = new UpdateStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (UpdateSet)this.visit((ParseTree)ctx.set_clause()), (Expression)this.visit((ParseTree)ctx.expression()));
                    this.populateQueryContext((SiddhiElement)outputStream, ctx);
                    return outputStream;
                }
                UpdateStream outputStream = new UpdateStream(source.streamId, (OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()), (Expression)this.visit((ParseTree)ctx.expression()));
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                return outputStream;
            }
            if (ctx.set_clause() != null) {
                UpdateStream outputStream = new UpdateStream(source.streamId, (UpdateSet)this.visit((ParseTree)ctx.set_clause()), (Expression)this.visit((ParseTree)ctx.expression()));
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                return outputStream;
            }
            UpdateStream outputStream = new UpdateStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
            this.populateQueryContext((SiddhiElement)outputStream, ctx);
            return outputStream;
        }
        if (ctx.RETURN() != null) {
            if (ctx.output_event_type() != null) {
                ReturnStream outputStream = new ReturnStream((OutputStream.OutputEventType)this.visit((ParseTree)ctx.output_event_type()));
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                return outputStream;
            }
            ReturnStream outputStream = new ReturnStream();
            this.populateQueryContext((SiddhiElement)outputStream, ctx);
            return outputStream;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public OutputStream visitStore_query_output(@NotNull SiddhiQLParser.Store_query_outputContext ctx) {
        if (ctx.DELETE() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (source.isInnerStream) {
                throw this.newSiddhiParserException(ctx, "DELETE can be only used with Tables!");
            }
            DeleteStream outputStream = new DeleteStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
            this.populateQueryContext((SiddhiElement)outputStream, ctx);
            return outputStream;
        }
        if (ctx.UPDATE() != null) {
            Source source = (Source)this.visit((ParseTree)ctx.target());
            if (source.isInnerStream) {
                throw this.newSiddhiParserException(ctx, "DELETE can be only used with Tables!");
            }
            if (ctx.set_clause() != null) {
                UpdateStream outputStream = new UpdateStream(source.streamId, (UpdateSet)this.visit((ParseTree)ctx.set_clause()), (Expression)this.visit((ParseTree)ctx.expression()));
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                return outputStream;
            }
            UpdateStream outputStream = new UpdateStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
            this.populateQueryContext((SiddhiElement)outputStream, ctx);
            return outputStream;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public OutputStream.OutputEventType visitOutput_event_type(@NotNull SiddhiQLParser.Output_event_typeContext ctx) {
        if (ctx.ALL() != null) {
            return OutputStream.OutputEventType.ALL_EVENTS;
        }
        if (ctx.EXPIRED() != null) {
            return OutputStream.OutputEventType.EXPIRED_EVENTS;
        }
        return OutputStream.OutputEventType.CURRENT_EVENTS;
    }

    @Override
    public UpdateSet visitSet_clause(@NotNull SiddhiQLParser.Set_clauseContext ctx) {
        UpdateSet updateSet = new UpdateSet();
        for (SiddhiQLParser.Set_assignmentContext setAssignmentContext : ctx.set_assignment()) {
            updateSet.set((Variable)this.visit((ParseTree)setAssignmentContext.attribute_reference()), (Expression)this.visit((ParseTree)setAssignmentContext.expression()));
        }
        this.populateQueryContext((SiddhiElement)updateSet, ctx);
        return updateSet;
    }

    @Override
    public OutputRate visitOutput_rate(@NotNull SiddhiQLParser.Output_rateContext ctx) {
        if (ctx.SNAPSHOT() != null) {
            SnapshotOutputRate snapshotOutputRate = new SnapshotOutputRate(Long.valueOf(((TimeConstant)this.visit((ParseTree)ctx.time_value())).value()));
            this.populateQueryContext((SiddhiElement)snapshotOutputRate, ctx);
            return snapshotOutputRate;
        }
        if (ctx.time_value() != null) {
            TimeOutputRate timeOutputRate = new TimeOutputRate(Long.valueOf(((TimeConstant)this.visit((ParseTree)ctx.time_value())).value()));
            if (ctx.output_rate_type() != null) {
                timeOutputRate.output((OutputRate.Type)this.visit((ParseTree)ctx.output_rate_type()));
            }
            this.populateQueryContext((SiddhiElement)timeOutputRate, ctx);
            return timeOutputRate;
        }
        if (ctx.EVENTS() != null) {
            EventOutputRate eventOutputRate = new EventOutputRate(Integer.valueOf(Integer.parseInt(ctx.INT_LITERAL().getText())));
            if (ctx.output_rate_type() != null) {
                eventOutputRate.output((OutputRate.Type)this.visit((ParseTree)ctx.output_rate_type()));
            }
            this.populateQueryContext((SiddhiElement)eventOutputRate, ctx);
            return eventOutputRate;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitOutput_rate_type(@NotNull SiddhiQLParser.Output_rate_typeContext ctx) {
        if (ctx.ALL() != null) {
            return OutputRate.Type.ALL;
        }
        if (ctx.LAST() != null) {
            return OutputRate.Type.LAST;
        }
        if (ctx.FIRST() != null) {
            return OutputRate.Type.FIRST;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitOutput_attribute(@NotNull SiddhiQLParser.Output_attributeContext ctx) {
        if (ctx.AS() != null) {
            OutputAttribute outputAttribute = new OutputAttribute((String)this.visit((ParseTree)ctx.attribute_name()), (Expression)this.visit((ParseTree)ctx.attribute()));
            this.populateQueryContext((SiddhiElement)outputAttribute, ctx);
            return outputAttribute;
        }
        OutputAttribute outputAttribute = new OutputAttribute((Variable)this.visit((ParseTree)ctx.attribute_reference()));
        this.populateQueryContext((SiddhiElement)outputAttribute, ctx);
        return outputAttribute;
    }

    @Override
    public Object visitOr_math_operation(@NotNull SiddhiQLParser.Or_math_operationContext ctx) {
        if (ctx.OR() != null) {
            Expression expression = Expression.or((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
            this.populateQueryContext((SiddhiElement)expression, ctx);
            return expression;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitAnd_math_operation(@NotNull SiddhiQLParser.And_math_operationContext ctx) {
        if (ctx.AND() != null) {
            Expression expression = Expression.and((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
            this.populateQueryContext((SiddhiElement)expression, ctx);
            return expression;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitEquality_math_operation(@NotNull SiddhiQLParser.Equality_math_operationContext ctx) {
        if (ctx.eq != null) {
            Expression expression = Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
            this.populateQueryContext((SiddhiElement)expression, ctx);
            return expression;
        }
        if (ctx.not_eq != null) {
            Expression expression = Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.NOT_EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
            this.populateQueryContext((SiddhiElement)expression, ctx);
            return expression;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Expression visitGreaterthan_lessthan_math_operation(@NotNull SiddhiQLParser.Greaterthan_lessthan_math_operationContext ctx) {
        Expression expression;
        if (ctx.gt != null) {
            expression = Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.GREATER_THAN, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else if (ctx.lt != null) {
            expression = Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.LESS_THAN, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else if (ctx.gt_eq != null) {
            expression = Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else if (ctx.lt_eq != null) {
            expression = Expression.compare((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Compare.Operator)Compare.Operator.LESS_THAN_EQUAL, (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else {
            throw this.newSiddhiParserException(ctx);
        }
        this.populateQueryContext((SiddhiElement)expression, ctx);
        return expression;
    }

    @Override
    public Expression visitAddition_math_operation(@NotNull SiddhiQLParser.Addition_math_operationContext ctx) {
        Add expression;
        if (ctx.add != null) {
            expression = Expression.add((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else if (ctx.substract != null) {
            expression = Expression.subtract((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else {
            throw this.newSiddhiParserException(ctx);
        }
        this.populateQueryContext((SiddhiElement)expression, ctx);
        return expression;
    }

    @Override
    public Expression visitMultiplication_math_operation(@NotNull SiddhiQLParser.Multiplication_math_operationContext ctx) {
        Multiply expression;
        if (ctx.multiply != null) {
            expression = Expression.multiply((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else if (ctx.devide != null) {
            expression = Expression.divide((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else if (ctx.mod != null) {
            expression = Expression.mod((Expression)((Expression)this.visit((ParseTree)ctx.math_operation(0))), (Expression)((Expression)this.visit((ParseTree)ctx.math_operation(1))));
        } else {
            throw this.newSiddhiParserException(ctx);
        }
        this.populateQueryContext((SiddhiElement)expression, ctx);
        return expression;
    }

    @Override
    public Expression visitNot_math_operation(@NotNull SiddhiQLParser.Not_math_operationContext ctx) {
        Expression expression = Expression.not((Expression)((Expression)this.visit((ParseTree)ctx.math_operation())));
        this.populateQueryContext((SiddhiElement)expression, ctx);
        return expression;
    }

    @Override
    public Object visitIn_math_operation(@NotNull SiddhiQLParser.In_math_operationContext ctx) {
        Expression expression = Expression.in((Expression)((Expression)this.visit((ParseTree)ctx.math_operation())), (String)((String)this.visit((ParseTree)ctx.name())));
        this.populateQueryContext((SiddhiElement)expression, ctx);
        return expression;
    }

    @Override
    public Object visitBasic_math_operation(@NotNull SiddhiQLParser.Basic_math_operationContext ctx) {
        if (ctx.math_operation() != null) {
            return this.visit((ParseTree)ctx.math_operation());
        }
        if (ctx.attribute_reference() != null) {
            return this.visit((ParseTree)ctx.attribute_reference());
        }
        if (ctx.constant_value() != null) {
            return this.visit((ParseTree)ctx.constant_value());
        }
        if (ctx.null_check() != null) {
            return this.visit((ParseTree)ctx.null_check());
        }
        if (ctx.function_operation() != null) {
            return this.visit((ParseTree)ctx.function_operation());
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object visitFunction_operation(@NotNull SiddhiQLParser.Function_operationContext ctx) {
        Expression expression = ctx.function_namespace() != null ? (ctx.attribute_list() != null ? Expression.function((String)((String)this.visit((ParseTree)ctx.function_namespace())), (String)((String)this.visit((ParseTree)ctx.function_id())), (Expression[])((Expression[])this.visit((ParseTree)ctx.attribute_list()))) : Expression.function((String)((String)this.visit((ParseTree)ctx.function_namespace())), (String)((String)this.visit((ParseTree)ctx.function_id())), null)) : (ctx.attribute_list() != null ? Expression.function((String)((String)this.visit((ParseTree)ctx.function_id())), (Expression[])((Expression[])this.visit((ParseTree)ctx.attribute_list()))) : Expression.function((String)((String)this.visit((ParseTree)ctx.function_id())), null));
        this.populateQueryContext((SiddhiElement)expression, ctx);
        return expression;
    }

    @Override
    public Object visitAttribute_list(@NotNull SiddhiQLParser.Attribute_listContext ctx) {
        Expression[] expressionArray = new Expression[ctx.attribute().size()];
        List<SiddhiQLParser.AttributeContext> attribute = ctx.attribute();
        for (int i = 0; i < attribute.size(); ++i) {
            SiddhiQLParser.AttributeContext attributeContext = attribute.get(i);
            expressionArray[i] = (Expression)this.visit((ParseTree)attributeContext);
        }
        return expressionArray;
    }

    @Override
    public Object visitNull_check(@NotNull SiddhiQLParser.Null_checkContext ctx) {
        StreamReference streamReference;
        Expression expression = ctx.stream_reference() != null ? ((streamReference = (StreamReference)this.visit((ParseTree)ctx.stream_reference())).isInnerStream ? (streamReference.streamIndex != null ? Expression.isNullInnerStream((String)streamReference.streamId, (int)streamReference.streamIndex) : Expression.isNullInnerStream((String)streamReference.streamId)) : (this.activeStreams.contains(streamReference.streamId) ? (streamReference.streamIndex != null ? Expression.isNullStream((String)streamReference.streamId, (int)streamReference.streamIndex) : Expression.isNullStream((String)streamReference.streamId)) : Expression.isNull((Expression)Expression.variable((String)streamReference.streamId)))) : (ctx.function_operation() != null ? Expression.isNull((Expression)((Expression)this.visit((ParseTree)ctx.function_operation()))) : Expression.isNull((Expression)((Expression)this.visit((ParseTree)ctx.attribute_reference()))));
        this.populateQueryContext((SiddhiElement)expression, ctx);
        return expression;
    }

    @Override
    public Object visitStream_reference(@NotNull SiddhiQLParser.Stream_referenceContext ctx) {
        StreamReference streamReference = new StreamReference();
        if (ctx.hash != null) {
            streamReference.isInnerStream = true;
        }
        streamReference.streamId = (String)this.visit((ParseTree)ctx.name());
        if (ctx.attribute_index() != null) {
            streamReference.streamIndex = (Integer)this.visit((ParseTree)ctx.attribute_index());
        }
        return streamReference;
    }

    @Override
    public Variable visitAttribute_reference(@NotNull SiddhiQLParser.Attribute_referenceContext ctx) {
        Variable variable = Expression.variable((String)((String)this.visit((ParseTree)ctx.attribute_name())));
        if (ctx.name1 != null && ctx.name2 != null) {
            variable.setStreamId(ctx.hash1 != null, (String)this.visit((ParseTree)ctx.name1));
            if (ctx.attribute_index1 != null) {
                variable.setStreamIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
            }
            variable.setFunctionId((String)this.visit((ParseTree)ctx.name2));
            if (ctx.attribute_index2 != null) {
                variable.setFunctionIndex((Integer)this.visit((ParseTree)ctx.attribute_index2));
            }
        } else if (ctx.name1 != null) {
            if (ctx.hash1 == null) {
                variable.setStreamId((String)this.visit((ParseTree)ctx.name1));
                if (ctx.attribute_index1 != null) {
                    variable.setStreamIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
                }
            } else {
                String name = (String)this.visit((ParseTree)ctx.name1);
                if (this.activeStreams.contains("#" + name)) {
                    variable.setStreamId(true, name);
                    if (ctx.attribute_index1 != null) {
                        variable.setStreamIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
                    }
                } else {
                    variable.setFunctionId(name);
                    if (ctx.attribute_index1 != null) {
                        variable.setFunctionIndex((Integer)this.visit((ParseTree)ctx.attribute_index1));
                    }
                }
            }
        }
        this.populateQueryContext((SiddhiElement)variable, ctx);
        return variable;
    }

    @Override
    public Integer visitAttribute_index(@NotNull SiddhiQLParser.Attribute_indexContext ctx) {
        int index;
        if (ctx.LAST() != null) {
            index = -2;
            if (ctx.INT_LITERAL() != null) {
                index -= Integer.parseInt(ctx.INT_LITERAL().getText());
            }
        } else {
            index = Integer.parseInt(ctx.INT_LITERAL().getText());
        }
        return index;
    }

    @Override
    public Object visitProperty_name(@NotNull SiddhiQLParser.Property_nameContext ctx) {
        StringBuilder stringBuilder = new StringBuilder();
        List<SiddhiQLParser.NameContext> propertyNameList = ctx.name();
        List<SiddhiQLParser.Property_separatorContext> propertySeparator = ctx.property_separator();
        for (int i = 0; i < propertyNameList.size(); ++i) {
            stringBuilder.append(this.visit((ParseTree)propertyNameList.get(i)));
            if (i >= propertySeparator.size()) continue;
            stringBuilder.append(propertySeparator.get(i).getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public Source visitSource(@NotNull SiddhiQLParser.SourceContext ctx) {
        Source source = new Source();
        source.streamId = (String)this.visit((ParseTree)ctx.stream_id());
        source.isInnerStream = ctx.inner != null;
        this.activeStreams.add(ctx.getText());
        return source;
    }

    @Override
    public Object visitName(@NotNull SiddhiQLParser.NameContext ctx) {
        if (ctx.id() != null) {
            return this.visit((ParseTree)ctx.id());
        }
        if (ctx.keyword() != null) {
            return this.visit((ParseTree)ctx.keyword());
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public Object[] visitCollect(@NotNull SiddhiQLParser.CollectContext ctx) {
        Object[] minMax = new Object[2];
        if (ctx.start == null && ctx.end == null) {
            Integer value = Integer.parseInt(ctx.INT_LITERAL(0).getText());
            minMax[0] = value;
            minMax[1] = value;
        } else {
            if (ctx.start != null) {
                minMax[0] = Integer.parseInt(ctx.start.getText());
            }
            if (ctx.end != null) {
                minMax[1] = Integer.parseInt(ctx.end.getText());
            }
        }
        return minMax;
    }

    @Override
    public Object visitAttribute_type(@NotNull SiddhiQLParser.Attribute_typeContext ctx) {
        if (ctx.STRING() != null) {
            return Attribute.Type.STRING;
        }
        if (ctx.INT() != null) {
            return Attribute.Type.INT;
        }
        if (ctx.LONG() != null) {
            return Attribute.Type.LONG;
        }
        if (ctx.FLOAT() != null) {
            return Attribute.Type.FLOAT;
        }
        if (ctx.DOUBLE() != null) {
            return Attribute.Type.DOUBLE;
        }
        if (ctx.BOOL() != null) {
            return Attribute.Type.BOOL;
        }
        if (ctx.OBJECT() != null) {
            return Attribute.Type.OBJECT;
        }
        throw this.newSiddhiParserException(ctx);
    }

    @Override
    public JoinInputStream.Type visitJoin(@NotNull SiddhiQLParser.JoinContext ctx) {
        if (ctx.OUTER() != null) {
            if (ctx.FULL() != null) {
                return JoinInputStream.Type.FULL_OUTER_JOIN;
            }
            if (ctx.RIGHT() != null) {
                return JoinInputStream.Type.RIGHT_OUTER_JOIN;
            }
            if (ctx.LEFT() != null) {
                return JoinInputStream.Type.LEFT_OUTER_JOIN;
            }
            throw this.newSiddhiParserException(ctx, "Found " + ctx.getText() + " but only FULL OUTER JOIN, RIGHT " + "OUTER JOIN, LEFT OUTER JOIN are supported!");
        }
        return JoinInputStream.Type.JOIN;
    }

    @Override
    public Constant visitConstant_value(@NotNull SiddhiQLParser.Constant_valueContext ctx) {
        BoolConstant constant;
        if (ctx.bool_value() != null) {
            constant = Expression.value((boolean)((BoolConstant)this.visit((ParseTree)ctx.bool_value())).getValue());
        } else if (ctx.signed_double_value() != null) {
            constant = Expression.value((double)((DoubleConstant)this.visit((ParseTree)ctx.signed_double_value())).getValue());
        } else if (ctx.signed_float_value() != null) {
            constant = Expression.value((float)((FloatConstant)this.visit((ParseTree)ctx.signed_float_value())).getValue().floatValue());
        } else if (ctx.signed_long_value() != null) {
            constant = Expression.value((long)((LongConstant)this.visit((ParseTree)ctx.signed_long_value())).getValue());
        } else if (ctx.signed_int_value() != null) {
            constant = Expression.value((int)((IntConstant)this.visit((ParseTree)ctx.signed_int_value())).getValue());
        } else if (ctx.time_value() != null) {
            constant = (TimeConstant)this.visit((ParseTree)ctx.time_value());
        } else if (ctx.string_value() != null) {
            constant = Expression.value((String)((StringConstant)this.visit((ParseTree)ctx.string_value())).getValue());
        } else {
            throw this.newSiddhiParserException(ctx);
        }
        this.populateQueryContext((SiddhiElement)constant, ctx);
        return constant;
    }

    @Override
    public String visitId(@NotNull SiddhiQLParser.IdContext ctx) {
        return ctx.getText();
    }

    @Override
    public Object visitKeyword(@NotNull SiddhiQLParser.KeywordContext ctx) {
        return ctx.getText();
    }

    @Override
    public TimeConstant visitTime_value(@NotNull SiddhiQLParser.Time_valueContext ctx) {
        TimeConstant timeValueInMillis = Expression.Time.milliSec((int)0);
        if (ctx.millisecond_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.millisecond_value())).value());
        }
        if (ctx.second_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.second_value())).value());
        }
        if (ctx.minute_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.minute_value())).value());
        }
        if (ctx.hour_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.hour_value())).value());
        }
        if (ctx.day_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.day_value())).value());
        }
        if (ctx.week_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.week_value())).value());
        }
        if (ctx.month_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.month_value())).value());
        }
        if (ctx.year_value() != null) {
            timeValueInMillis.milliSec(((TimeConstant)this.visit((ParseTree)ctx.year_value())).value());
        }
        this.populateQueryContext((SiddhiElement)timeValueInMillis, ctx);
        return timeValueInMillis;
    }

    @Override
    public TimeConstant visitYear_value(@NotNull SiddhiQLParser.Year_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.year((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public TimeConstant visitMonth_value(@NotNull SiddhiQLParser.Month_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.month((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public TimeConstant visitWeek_value(@NotNull SiddhiQLParser.Week_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.week((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public TimeConstant visitDay_value(@NotNull SiddhiQLParser.Day_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.day((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public TimeConstant visitHour_value(@NotNull SiddhiQLParser.Hour_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.hour((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public TimeConstant visitMinute_value(@NotNull SiddhiQLParser.Minute_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.minute((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public TimeConstant visitSecond_value(@NotNull SiddhiQLParser.Second_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.sec((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public TimeConstant visitMillisecond_value(@NotNull SiddhiQLParser.Millisecond_valueContext ctx) {
        TimeConstant timeConstant = Expression.Time.milliSec((long)Long.parseLong(ctx.INT_LITERAL().getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)timeConstant, ctx);
        return timeConstant;
    }

    @Override
    public DoubleConstant visitSigned_double_value(@NotNull SiddhiQLParser.Signed_double_valueContext ctx) {
        DoubleConstant doubleConstant = Expression.value((double)Double.parseDouble(ctx.getText()));
        this.populateQueryContext((SiddhiElement)doubleConstant, ctx);
        return doubleConstant;
    }

    @Override
    public LongConstant visitSigned_long_value(@NotNull SiddhiQLParser.Signed_long_valueContext ctx) {
        LongConstant longConstant = Expression.value((long)Long.parseLong(ctx.getText().replaceFirst("[lL]", "")));
        this.populateQueryContext((SiddhiElement)longConstant, ctx);
        return longConstant;
    }

    @Override
    public FloatConstant visitSigned_float_value(@NotNull SiddhiQLParser.Signed_float_valueContext ctx) {
        FloatConstant floatConstant = Expression.value((float)Float.parseFloat(ctx.getText()));
        this.populateQueryContext((SiddhiElement)floatConstant, ctx);
        return floatConstant;
    }

    @Override
    public IntConstant visitSigned_int_value(@NotNull SiddhiQLParser.Signed_int_valueContext ctx) {
        IntConstant intConstant = Expression.value((int)Integer.parseInt(ctx.getText()));
        this.populateQueryContext((SiddhiElement)intConstant, ctx);
        return intConstant;
    }

    @Override
    public BoolConstant visitBool_value(@NotNull SiddhiQLParser.Bool_valueContext ctx) {
        BoolConstant boolConstant = Expression.value((boolean)"true".equalsIgnoreCase(ctx.getText()));
        this.populateQueryContext((SiddhiElement)boolConstant, ctx);
        return boolConstant;
    }

    @Override
    public StringConstant visitString_value(@NotNull SiddhiQLParser.String_valueContext ctx) {
        StringConstant stringConstant = Expression.value((String)ctx.STRING_LITERAL().getText());
        this.populateQueryContext((SiddhiElement)stringConstant, ctx);
        return stringConstant;
    }

    public SiddhiParserException newSiddhiParserException(ParserRuleContext context) {
        return new SiddhiParserException("Syntax error in SiddhiQL, near '" + context.getText() + "'.", new int[]{context.getStart().getLine(), context.getStart().getCharPositionInLine()}, new int[]{context.getStop().getLine(), context.getStop().getCharPositionInLine()});
    }

    public SiddhiParserException newSiddhiParserException(ParserRuleContext context, String message) {
        return new SiddhiParserException("Syntax error in SiddhiQL, near '" + context.getText() + "', " + message + ".", new int[]{context.getStart().getLine(), context.getStart().getCharPositionInLine()}, new int[]{context.getStop().getLine(), context.getStop().getCharPositionInLine()});
    }

    public SiddhiParserException newSiddhiParserException(ParserRuleContext context, String message, Throwable t) {
        return new SiddhiParserException("Syntax error in SiddhiQL, near '" + context.getText() + "', " + message + ".", t, new int[]{context.getStart().getLine(), context.getStart().getCharPositionInLine()}, new int[]{context.getStop().getLine(), context.getStop().getCharPositionInLine()});
    }

    @Override
    public TimePeriod.Duration visitAggregation_time_duration(@NotNull SiddhiQLParser.Aggregation_time_durationContext ctx) {
        if (ctx.SECONDS() != null) {
            return TimePeriod.Duration.SECONDS;
        }
        if (ctx.MINUTES() != null) {
            return TimePeriod.Duration.MINUTES;
        }
        if (ctx.HOURS() != null) {
            return TimePeriod.Duration.HOURS;
        }
        if (ctx.DAYS() != null) {
            return TimePeriod.Duration.DAYS;
        }
        if (ctx.MONTHS() != null) {
            return TimePeriod.Duration.MONTHS;
        }
        if (ctx.YEARS() != null) {
            return TimePeriod.Duration.YEARS;
        }
        throw this.newSiddhiParserException(ctx, "Found " + ctx.getText() + ", but only values SECONDS, MINUTES, HOURS," + " DAYS, WEEKS, MONTHS or YEARS are supported");
    }

    @Override
    public TimePeriod visitAggregation_time_interval(@NotNull SiddhiQLParser.Aggregation_time_intervalContext ctx) {
        ArrayList<TimePeriod.Duration> durations = new ArrayList<TimePeriod.Duration>();
        for (SiddhiQLParser.Aggregation_time_durationContext context : ctx.aggregation_time_duration()) {
            durations.add((TimePeriod.Duration)this.visit((ParseTree)context));
        }
        TimePeriod.Duration[] durationVarArg = new TimePeriod.Duration[durations.size()];
        durationVarArg = durations.toArray(durationVarArg);
        TimePeriod timePeriod = TimePeriod.interval((TimePeriod.Duration[])durationVarArg);
        this.populateQueryContext((SiddhiElement)timePeriod, ctx);
        return timePeriod;
    }

    @Override
    public TimePeriod visitAggregation_time_range(@NotNull SiddhiQLParser.Aggregation_time_rangeContext ctx) {
        SiddhiQLParser.Aggregation_time_durationContext left = ctx.aggregation_time_duration().get(0);
        SiddhiQLParser.Aggregation_time_durationContext right = ctx.aggregation_time_duration().get(1);
        TimePeriod.Duration leftTimeDuration = this.visitAggregation_time_duration(left);
        TimePeriod.Duration rightTimeDuration = this.visitAggregation_time_duration(right);
        TimePeriod timePeriod = TimePeriod.range((TimePeriod.Duration)leftTimeDuration, (TimePeriod.Duration)rightTimeDuration);
        this.populateQueryContext((SiddhiElement)timePeriod, ctx);
        return timePeriod;
    }

    @Override
    public TimePeriod visitAggregation_time(@NotNull SiddhiQLParser.Aggregation_timeContext ctx) {
        if (ctx.aggregation_time_interval() != null) {
            TimePeriod timePeriod = this.visitAggregation_time_interval(ctx.aggregation_time_interval());
            this.populateQueryContext((SiddhiElement)timePeriod, ctx);
            return timePeriod;
        }
        if (ctx.aggregation_time_range() != null) {
            TimePeriod timePeriod = this.visitAggregation_time_range(ctx.aggregation_time_range());
            this.populateQueryContext((SiddhiElement)timePeriod, ctx);
            return timePeriod;
        }
        throw this.newSiddhiParserException(ctx, "Found " + ctx.getText() + " but only comma separated time durations, or time duration ... time duration is supported!");
    }

    @Override
    public AggregationDefinition visitDefinition_aggregation_final(@NotNull SiddhiQLParser.Definition_aggregation_finalContext ctx) {
        return (AggregationDefinition)this.visit((ParseTree)ctx.definition_aggregation());
    }

    @Override
    public AggregationDefinition visitDefinition_aggregation(@NotNull SiddhiQLParser.Definition_aggregationContext ctx) {
        String aggregationName = (String)this.visitAggregation_name(ctx.aggregation_name());
        AggregationDefinition aggregationDefinition = AggregationDefinition.id((String)aggregationName);
        for (SiddhiQLParser.AnnotationContext annotationContext : ctx.annotation()) {
            aggregationDefinition.annotation((Annotation)this.visit((ParseTree)annotationContext));
        }
        BasicSingleInputStream basicSingleInputStream = (BasicSingleInputStream)this.visit((ParseTree)ctx.standard_stream());
        aggregationDefinition.from(basicSingleInputStream);
        BasicSelector selector = (BasicSelector)this.visit((ParseTree)ctx.group_by_query_selection());
        aggregationDefinition.select(selector);
        if (ctx.attribute_reference() != null) {
            Variable aggregatedBy = (Variable)this.visit((ParseTree)ctx.attribute_reference());
            aggregationDefinition.aggregateBy(aggregatedBy);
        }
        TimePeriod timePeriod = (TimePeriod)this.visit((ParseTree)ctx.aggregation_time());
        aggregationDefinition.every(timePeriod);
        this.populateQueryContext((SiddhiElement)aggregationDefinition, ctx);
        return aggregationDefinition;
    }

    @Override
    public Object visitWithin_time_range(SiddhiQLParser.Within_time_rangeContext ctx) {
        Within within = ctx.end_pattern == null ? Within.within((Expression)((Expression)this.visit((ParseTree)ctx.start_pattern))) : Within.within((Expression)((Expression)this.visit((ParseTree)ctx.start_pattern)), (Expression)((Expression)this.visit((ParseTree)ctx.end_pattern)));
        this.populateQueryContext((SiddhiElement)within, ctx);
        return within;
    }

    @Override
    public Object visitStore_query_final(SiddhiQLParser.Store_query_finalContext ctx) {
        return this.visit((ParseTree)ctx.store_query());
    }

    @Override
    public Object visitStore_query(SiddhiQLParser.Store_queryContext ctx) {
        StoreQuery storeQuery = StoreQuery.query();
        if (ctx.FROM() != null) {
            storeQuery.setType(StoreQuery.StoreQueryType.FIND);
            storeQuery.from((InputStore)this.visit((ParseTree)ctx.store_input()));
            if (ctx.query_section() != null) {
                storeQuery = storeQuery.select((Selector)this.visit((ParseTree)ctx.query_section()));
            }
        } else if (ctx.query_section() != null) {
            storeQuery.select((Selector)this.visit((ParseTree)ctx.query_section()));
            if (ctx.UPDATE() != null && ctx.OR() != null) {
                UpdateOrInsertStream outputStream;
                storeQuery.setType(StoreQuery.StoreQueryType.UPDATE_OR_INSERT);
                Source source = (Source)this.visit((ParseTree)ctx.target());
                if (source.isInnerStream) {
                    throw this.newSiddhiParserException(ctx, "UPDATE OR INTO INSERT can be only used with Tables!");
                }
                if (ctx.set_clause() != null) {
                    outputStream = new UpdateOrInsertStream(source.streamId, (UpdateSet)this.visit((ParseTree)ctx.set_clause()), (Expression)this.visit((ParseTree)ctx.expression()));
                    this.populateQueryContext((SiddhiElement)outputStream, ctx);
                } else {
                    outputStream = new UpdateOrInsertStream(source.streamId, (Expression)this.visit((ParseTree)ctx.expression()));
                    this.populateQueryContext((SiddhiElement)outputStream, ctx);
                }
                storeQuery.outStream((OutputStream)outputStream);
            } else if (ctx.INSERT() != null) {
                storeQuery.setType(StoreQuery.StoreQueryType.INSERT);
                Source source = (Source)this.visit((ParseTree)ctx.target());
                if (source.isInnerStream) {
                    throw this.newSiddhiParserException(ctx, "INSERT can be only used with Tables!");
                }
                InsertIntoStream outputStream = new InsertIntoStream(source.streamId);
                this.populateQueryContext((SiddhiElement)outputStream, ctx);
                storeQuery.outStream((OutputStream)outputStream);
            } else if (ctx.store_query_output() != null) {
                OutputStream outputStream = (OutputStream)this.visit((ParseTree)ctx.store_query_output());
                if (outputStream instanceof DeleteStream) {
                    storeQuery.setType(StoreQuery.StoreQueryType.DELETE);
                } else if (outputStream instanceof UpdateStream) {
                    storeQuery.setType(StoreQuery.StoreQueryType.UPDATE);
                }
                storeQuery.outStream(outputStream);
            }
        } else if (ctx.store_query_output() != null) {
            OutputStream outputStream = (OutputStream)this.visit((ParseTree)ctx.store_query_output());
            if (outputStream instanceof DeleteStream) {
                storeQuery.setType(StoreQuery.StoreQueryType.DELETE);
            } else if (outputStream instanceof UpdateStream) {
                storeQuery.setType(StoreQuery.StoreQueryType.UPDATE);
            }
            storeQuery.outStream(outputStream);
        }
        this.populateQueryContext((SiddhiElement)storeQuery, ctx);
        return storeQuery;
    }

    @Override
    public Object visitStore_input(SiddhiQLParser.Store_inputContext ctx) {
        String sourceId = (String)this.visit((ParseTree)ctx.source_id());
        String alias = null;
        if (ctx.alias() != null) {
            alias = (String)this.visit((ParseTree)ctx.source_id());
        }
        Store store = InputStore.store(alias, (String)sourceId);
        Expression expression = null;
        if (ctx.expression() != null) {
            expression = (Expression)this.visit((ParseTree)ctx.expression());
        }
        this.populateQueryContext((SiddhiElement)store, ctx);
        if (ctx.per() != null) {
            return store.on(expression, (Within)this.visit((ParseTree)ctx.within_time_range()), (Expression)this.visit((ParseTree)ctx.per()));
        }
        if (expression != null) {
            return store.on(expression);
        }
        return store;
    }

    private void populateQueryContext(SiddhiElement siddhiElement, @NotNull ParserRuleContext ctx) {
        if (siddhiElement != null && siddhiElement.getQueryContextStartIndex() == null && siddhiElement.getQueryContextEndIndex() == null) {
            siddhiElement.setQueryContextStartIndex(new int[]{ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine()});
            siddhiElement.setQueryContextEndIndex(new int[]{ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine() + 1 + ctx.getStop().getStopIndex() - ctx.getStop().getStartIndex()});
        }
    }

    private static class StreamReference {
        private String streamId;
        private boolean isInnerStream;
        private Integer streamIndex;

        private StreamReference() {
        }
    }

    private static class Source {
        private String streamId;
        private boolean isInnerStream;

        private Source() {
        }
    }
}

