/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.string;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ConcatFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        int attributeCount = 0;
        if (attributeExpressionExecutors.length < 2) {
            throw new ExecutionPlanValidationException("str:charat() function requires at least two arguments, but found only " + attributeExpressionExecutors.length);
        }
        for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            ++attributeCount;
            if (this.returnType == expressionExecutor.getReturnType()) continue;
            throw new ExecutionPlanValidationException("Invalid parameter type found for the " + attributeCount + "'th argument of str:concat() function, " + "required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[attributeCount - 1].getReturnType().toString());
        }
    }

    protected Object execute(Object[] data) {
        StringBuilder sb = new StringBuilder();
        for (Object aData : data) {
            if (aData == null) continue;
            sb.append(aData);
        }
        return sb.toString();
    }

    protected Object execute(Object data) {
        return data;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return null;
    }

    public void restoreState(Object[] state) {
    }
}

