/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class RegexpFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;
    boolean isRegexConstant = false;
    String regexConstant;
    Pattern patternConstant;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to str:regexp() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of str:regexp() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of str:regexp() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor) {
            this.isRegexConstant = true;
            this.regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
            this.patternConstant = Pattern.compile(this.regexConstant);
        }
    }

    protected Object execute(Object[] data) {
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to str:regexp() function. First argument cannot be null");
        }
        if (data[1] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to str:regexp() function. Second argument cannot be null");
        }
        String source = (String)data[0];
        if (!this.isRegexConstant) {
            String regex = (String)data[1];
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(source);
            return matcher.matches();
        }
        Matcher matcher = this.patternConstant.matcher(source);
        return matcher.matches();
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[]{this.isRegexConstant, this.regexConstant, this.patternConstant};
    }

    public void restoreState(Object[] state) {
        this.isRegexConstant = (Boolean)state[0];
        this.regexConstant = (String)state[1];
        this.patternConstant = (Pattern)state[2];
    }
}

