/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class SubstrFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.STRING;
    boolean isRegexConstant = false;
    String regexConstant;
    Pattern patternConstant;
    SubstrType substrType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of str:substr() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors.length == 2) {
            if (attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT) {
                this.substrType = SubstrType.ONE;
                return;
            } else {
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of str:substr() function, required " + Attribute.Type.STRING + " or " + Attribute.Type.INT + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
                this.substrType = SubstrType.THREE;
                if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) return;
                this.isRegexConstant = true;
                this.regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
                this.patternConstant = Pattern.compile(this.regexConstant);
            }
            return;
        } else {
            if (attributeExpressionExecutors.length != 3) throw new ExecutionPlanValidationException("Invalid no of Arguments passed to str:substr() function, required 2 or 3, but found " + attributeExpressionExecutors.length);
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.INT) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of str:substr() function, required " + Attribute.Type.INT + ", but found " + attributeExpressionExecutors[2].getReturnType().toString());
            }
            if (attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT) {
                this.substrType = SubstrType.TWO;
                return;
            } else {
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of str:substr() function, required " + Attribute.Type.STRING + " or " + Attribute.Type.INT + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
                this.substrType = SubstrType.FOUR;
                if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) return;
                this.isRegexConstant = true;
                this.regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
                this.patternConstant = Pattern.compile(this.regexConstant);
            }
        }
    }

    protected Object execute(Object[] data) {
        String output = "";
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to str:substr() function. First argument cannot be null");
        }
        if (data[1] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to str:substr() function. Second argument cannot be null");
        }
        String source = (String)data[0];
        switch (this.substrType) {
            case ONE: {
                int beginIndex = (Integer)data[1];
                output = source.substring(beginIndex);
                break;
            }
            case TWO: {
                if (data[2] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to str:substr() function. Third argument cannot be null");
                }
                int beginIndex = (Integer)data[1];
                int length = (Integer)data[2];
                output = source.substring(beginIndex, beginIndex + length);
                break;
            }
            case THREE: {
                if (!this.isRegexConstant) {
                    String regex = (String)data[1];
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(source);
                    if (!matcher.find()) break;
                    output = matcher.group(0);
                    break;
                }
                Matcher matcher = this.patternConstant.matcher(source);
                if (!matcher.find()) break;
                output = matcher.group(0);
                break;
            }
            case FOUR: {
                if (data[2] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to str:substr() function. Third argument cannot be null");
                }
                int groupNo = (Integer)data[2];
                if (!this.isRegexConstant) {
                    String regex = (String)data[1];
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(source);
                    if (!matcher.find()) break;
                    output = matcher.group(groupNo);
                    break;
                }
                Matcher matcher = this.patternConstant.matcher(source);
                if (!matcher.find()) break;
                output = matcher.group(groupNo);
            }
        }
        return output;
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[]{this.isRegexConstant, this.regexConstant, this.patternConstant, this.substrType};
    }

    public void restoreState(Object[] state) {
        this.isRegexConstant = (Boolean)state[0];
        this.regexConstant = (String)state[1];
        this.patternConstant = (Pattern)state[2];
        this.substrType = (SubstrType)((Object)state[3]);
    }

    public static enum SubstrType {
        ONE,
        TWO,
        THREE,
        FOUR;

    }
}

