/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.in.InEvent;
import org.wso2.siddhi.core.event.in.InListEvent;
import org.wso2.siddhi.core.event.in.InStream;
import org.wso2.siddhi.core.exception.QueryCreationException;
import org.wso2.siddhi.core.executor.expression.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.transform.TransformProcessor;
import org.wso2.siddhi.extension.timeseries.linreg.MultipleLinearRegressionCalculator;
import org.wso2.siddhi.extension.timeseries.linreg.RegressionCalculator;
import org.wso2.siddhi.extension.timeseries.linreg.SimpleLinearRegressionCalculator;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.constant.DoubleConstant;
import org.wso2.siddhi.query.api.expression.constant.IntConstant;
import org.wso2.siddhi.query.api.extension.annotation.SiddhiExtension;

@SiddhiExtension(namespace="timeseries", function="regress")
public class LinearRegressionTransformProcessor
extends TransformProcessor {
    static final Logger log = Logger.getLogger(LinearRegressionTransformProcessor.class);
    private int paramCount = 0;
    private int calcInterval = 1;
    private int batchSize = 1000000000;
    private double ci = 0.95;
    private final int SIMPLE_LINREG_INPUT_PARAM_COUNT = 2;
    private Object[] regResult;
    private Map<Integer, String> paramPositions = new HashMap<Integer, String>();
    private RegressionCalculator regressionCalculator = null;

    protected void init(Expression[] parameters, List<ExpressionExecutor> expressionExecutors, StreamDefinition inStreamDefinition, StreamDefinition outStreamDefinition, String elementId, SiddhiContext siddhiContext) {
        String attributeName;
        Variable var;
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query Initialized. Stream Parameters: " + inStreamDefinition.toString()));
        }
        if (parameters[0] instanceof IntConstant) {
            try {
                this.calcInterval = ((IntConstant)parameters[0]).getValue();
                this.batchSize = ((IntConstant)parameters[1]).getValue();
            }
            catch (ClassCastException c) {
                throw new QueryCreationException("Calculation interval, batch size and range should be of type int");
            }
            try {
                this.ci = ((DoubleConstant)parameters[2]).getValue();
            }
            catch (ClassCastException c) {
                throw new QueryCreationException("Confidence interval should be of type double and a value between 0 and 1");
            }
            for (i = 3; i < parameters.length; ++i) {
                if (!(parameters[i] instanceof Variable)) continue;
                var = (Variable)parameters[i];
                attributeName = var.getAttributeName();
                this.paramPositions.put(inStreamDefinition.getAttributePosition(attributeName), attributeName);
                ++this.paramCount;
            }
        } else {
            for (i = 0; i < parameters.length; ++i) {
                if (!(parameters[i] instanceof Variable)) continue;
                var = (Variable)parameters[i];
                attributeName = var.getAttributeName();
                this.paramPositions.put(inStreamDefinition.getAttributePosition(attributeName), attributeName);
                ++this.paramCount;
            }
        }
        this.regressionCalculator = this.paramCount > 2 ? new MultipleLinearRegressionCalculator(this.paramCount, this.calcInterval, this.batchSize, this.ci) : new SimpleLinearRegressionCalculator(this.paramCount, this.calcInterval, this.batchSize, this.ci);
        if (outStreamDefinition == null) {
            this.outStreamDefinition = new StreamDefinition().name("linregStream");
            this.outStreamDefinition.attribute("stdError", Attribute.Type.DOUBLE);
            for (int itr = 0; itr < this.paramCount; ++itr) {
                String betaVal = "beta" + itr;
                this.outStreamDefinition.attribute(betaVal, Attribute.Type.DOUBLE);
            }
            for (Attribute strDef : inStreamDefinition.getAttributeList()) {
                this.outStreamDefinition.attribute(strDef.getName(), strDef.getType());
            }
        }
    }

    protected InStream processEvent(InEvent inEvent) {
        Object[] outStreamData;
        if (log.isDebugEnabled()) {
            log.debug((Object)"processEvent");
        }
        Object[] inStreamData = inEvent.getData();
        Object[] temp = this.regressionCalculator.calculateLinearRegression(inEvent, this.paramPositions);
        if (this.regResult == null && temp == null) {
            outStreamData = null;
        } else {
            if (temp != null) {
                this.regResult = temp;
            }
            outStreamData = new Object[this.regResult.length + inStreamData.length];
            System.arraycopy(this.regResult, 0, outStreamData, 0, this.regResult.length);
            System.arraycopy(inStreamData, 0, outStreamData, this.regResult.length, inStreamData.length);
        }
        return new InEvent(inEvent.getStreamId(), System.currentTimeMillis(), outStreamData);
    }

    protected InStream processEvent(InListEvent inListEvent) {
        InStream inStream = null;
        for (Event event : inListEvent.getEvents()) {
            if (!(event instanceof InEvent)) continue;
            inStream = this.processEvent((InEvent)event);
        }
        return inStream;
    }

    protected Object[] currentState() {
        return null;
    }

    protected void restoreState(Object[] objects) {
    }

    public void destroy() {
    }
}

