/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;

public abstract class Caller {
    private static Log log = LogFactory.getLog((String)Caller.class.getName());
    private long nextAccessTime = 0L;
    private long firstAccessTime = 0L;
    private long nextTimeWindow = 0L;
    private int count = 0;
    final Object lock = new Object();
    private Object ID;

    public Caller(Object ID) {
        this.ID = ID;
    }

    public Object getID() {
        return this.ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAccess(CallerConfiguration configurationIPBased, ThrottleContext throttleContext, long currentTime) throws ThrottleException {
        if (configurationIPBased.getMaximumRequestPerUnitTime() != 0) {
            Object object = this.lock;
            synchronized (object) {
                this.firstAccessTime = currentTime;
                if (this.nextTimeWindow != 0L) {
                    throttleContext.removeCaller(new Long(this.nextTimeWindow));
                }
                this.nextTimeWindow = currentTime + configurationIPBased.getUnitTimeInMiliSecond();
            }
            throttleContext.addCaller(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccessIfUnitTimeNotOver(CallerConfiguration configurationIPBased, ThrottleContext throttleContext, long currentTime) throws ThrottleException {
        boolean canAcess = false;
        if (configurationIPBased.getMaximumRequestPerUnitTime() != 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.count <= configurationIPBased.getMaximumRequestPerUnitTime() - 1) {
                    canAcess = true;
                    ++this.count;
                } else if (this.nextAccessTime == 0L) {
                    this.nextAccessTime = configurationIPBased.getProhibitTimePeriod() == 0L ? this.firstAccessTime + configurationIPBased.getUnitTimeInMiliSecond() : currentTime + configurationIPBased.getProhibitTimePeriod();
                    log.debug((Object)("Maximum Number of requests are reached :IP-" + this.ID));
                } else if (this.nextAccessTime <= currentTime) {
                    this.nextAccessTime = 0L;
                    canAcess = true;
                    this.count = 1;
                    this.firstAccessTime = currentTime;
                    if (this.nextTimeWindow != 0L) {
                        throttleContext.removeCaller(new Long(this.nextTimeWindow));
                    }
                    this.nextTimeWindow = currentTime + configurationIPBased.getUnitTimeInMiliSecond();
                } else {
                    log.debug((Object)("Prohibit period is not yet over :IP- " + this.ID));
                }
            }
        }
        return canAcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccessIfUnitTimeOver(CallerConfiguration configurationIPBased, ThrottleContext throttleContext, long currentTime) throws ThrottleException {
        boolean canAcess = false;
        if (configurationIPBased.getMaximumRequestPerUnitTime() != 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.count <= configurationIPBased.getMaximumRequestPerUnitTime() - 1) {
                    if (this.nextTimeWindow != 0L) {
                        throttleContext.removeCaller(new Long(this.nextTimeWindow));
                    }
                    canAcess = true;
                } else if (this.nextAccessTime == 0L || this.nextAccessTime <= currentTime) {
                    this.nextAccessTime = 0L;
                    canAcess = true;
                    this.count = 1;
                    this.firstAccessTime = currentTime;
                    if (this.nextTimeWindow != 0L) {
                        throttleContext.removeCaller(new Long(this.nextTimeWindow));
                    }
                    this.nextTimeWindow = currentTime + configurationIPBased.getUnitTimeInMiliSecond();
                } else {
                    log.debug((Object)("Even unit time has overed , CallerIP in prohibit state :IP -" + this.ID));
                }
            }
        }
        return canAcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccess(ThrottleContext throttleContext, long currentTime) throws ThrottleException {
        boolean canAcess = false;
        ThrottleConfiguration throttleConfiguration = throttleContext.getThrottleConfiguration();
        CallerConfiguration ipBasedconfiguration = throttleConfiguration.getCallerConfiguration(this.getID());
        if (ipBasedconfiguration == null) {
            return false;
        }
        if (ipBasedconfiguration.getMaximumRequestPerUnitTime() < 0 || ipBasedconfiguration.getUnitTimeInMiliSecond() <= 0L || ipBasedconfiguration.getProhibitTimePeriod() < 0L) {
            throw new ThrottleException("Invalid Throttle Configuration");
        }
        if (ipBasedconfiguration.getMaximumRequestPerUnitTime() != 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.firstAccessTime == 0L) {
                    this.initAccess(ipBasedconfiguration, throttleContext, currentTime);
                }
                canAcess = this.nextTimeWindow > currentTime ? this.canAccessIfUnitTimeNotOver(ipBasedconfiguration, throttleContext, currentTime) : this.canAccessIfUnitTimeOver(ipBasedconfiguration, throttleContext, currentTime);
            }
        }
        return canAcess;
    }

    public long getNextTimeWindow() {
        return this.nextTimeWindow;
    }

    public abstract int getType();
}

