/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleConstants;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.factory.CallerConfigurationFactory;
import org.wso2.throttle.factory.ThrottleConfigurationFactory;
import org.wso2.throttle.factory.ThrottleContextFactory;

public class ThrottlePolicyProcessor {
    private static Log log = LogFactory.getLog((String)ThrottlePolicyProcessor.class.getName());

    public static Throttle processPolicy(Policy policy) throws ThrottleException {
        Throttle throttle = null;
        ThrottleConfiguration throttleConfiguration = null;
        if (policy == null) {
            return null;
        }
        List topLevelAssertionList = policy.getPolicyComponents();
        Iterator topLevelAssertionsIterator = topLevelAssertionList.iterator();
        while (topLevelAssertionsIterator.hasNext()) {
            XmlPrimtiveAssertion topLevelXmlPrimtiveAssertion;
            QName qName;
            Object topLevelAssertionObject = topLevelAssertionsIterator.next();
            if (!(topLevelAssertionObject instanceof XmlPrimtiveAssertion) || !(qName = (topLevelXmlPrimtiveAssertion = (XmlPrimtiveAssertion)topLevelAssertionObject).getName()).equals(ThrottleConstants.THROTTLE_ASSERTION_QNAME)) continue;
            throttle = new Throttle();
            Policy throtlePolicy = PolicyEngine.getPolicy((OMElement)topLevelXmlPrimtiveAssertion.getValue());
            List assertionList = throtlePolicy.getPolicyComponents();
            Iterator assertionsIterator = assertionList.iterator();
            while (assertionsIterator.hasNext()) {
                Object allObject = assertionsIterator.next();
                if (!(allObject instanceof All)) continue;
                CallerConfiguration configuration = null;
                boolean isIPRangeFound = false;
                boolean isExactlyOneFound = false;
                List configDataAssertionList = ((All)allObject).getAssertions();
                if (configDataAssertionList != null) {
                    Iterator configDataAssertionIterator = configDataAssertionList.iterator();
                    while (configDataAssertionIterator.hasNext()) {
                        Object aConfigDataAssertionObject = configDataAssertionIterator.next();
                        if (aConfigDataAssertionObject instanceof XmlPrimtiveAssertion) {
                            XmlPrimtiveAssertion idPrimitiveAssertion = (XmlPrimtiveAssertion)aConfigDataAssertionObject;
                            OMElement element = idPrimitiveAssertion.getValue();
                            String throttleType = element.getAttributeValue(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME);
                            if (throttleType == null) {
                                ThrottlePolicyProcessor.handleException("Type of Throtle in the policy cannot be null");
                            }
                            if (throttleType.equals("IP")) {
                                throttleConfiguration = throttle.getThrottleConfiguration("Key_of_ip_based_Throttle");
                                if (throttleConfiguration == null) {
                                    throttleConfiguration = ThrottleConfigurationFactory.createThrottleConfiguration(0);
                                    throttle.addThrottleContext("Key_of_ip_based_Throttle", ThrottleContextFactory.createThrottleContext(0, throttleConfiguration));
                                    throttle.addThrottleConfiguration("Key_of_ip_based_Throttle", throttleConfiguration);
                                }
                                configuration = CallerConfigurationFactory.createCallerConfiguration(0);
                            }
                            String name = element.getLocalName();
                            String value = element.getText();
                            if (name == null || value == null) {
                                ThrottlePolicyProcessor.handleException("Either Value or Name of the policy cannot be null");
                                continue;
                            }
                            if (name.equals("ID")) {
                                if (!value.equals("")) {
                                    isIPRangeFound = true;
                                    configuration.setID(value);
                                    continue;
                                }
                                ThrottlePolicyProcessor.handleException("Value of ID cannot find - invalid configuration");
                                continue;
                            }
                            ThrottlePolicyProcessor.handleException("Undefined pocilcy property for throttle - Expect ID  ");
                            continue;
                        }
                        if (!(aConfigDataAssertionObject instanceof ExactlyOne)) continue;
                        ExactlyOne exactlyOne = (ExactlyOne)aConfigDataAssertionObject;
                        List childAssertionsList = exactlyOne.getPolicyComponents();
                        boolean haveSelectOneFromExactlyOne = false;
                        Iterator childAssertionSIterator = childAssertionsList.iterator();
                        while (childAssertionSIterator.hasNext() && !haveSelectOneFromExactlyOne) {
                            Object childAssertionObject = childAssertionSIterator.next();
                            if (childAssertionObject instanceof All) {
                                haveSelectOneFromExactlyOne = true;
                                boolean isFoundMaxCount = false;
                                boolean isFoundUnitTime = false;
                                All childAll = (All)childAssertionObject;
                                List aConfigDataAssertionList = childAll.getPolicyComponents();
                                Iterator aConfigDataAssertionsIterator = aConfigDataAssertionList.iterator();
                                while (aConfigDataAssertionsIterator.hasNext()) {
                                    Object aOneOfConfigDataAssertions = aConfigDataAssertionsIterator.next();
                                    if (!(aOneOfConfigDataAssertions instanceof XmlPrimtiveAssertion)) continue;
                                    XmlPrimtiveAssertion aOneOfConfigDataPrimitiveAssertion = (XmlPrimtiveAssertion)aOneOfConfigDataAssertions;
                                    OMElement element = aOneOfConfigDataPrimitiveAssertion.getValue();
                                    String name = element.getLocalName();
                                    String value = element.getText();
                                    if (name == null || value == null) {
                                        ThrottlePolicyProcessor.handleException("Either Value or Name of the policy cannot be null");
                                    }
                                    if (!value.equals("")) {
                                        if (name.equals("MaximumCount")) {
                                            isFoundMaxCount = true;
                                            configuration.setMaximumRequestPerUnitTime(Integer.parseInt(value.trim()));
                                            continue;
                                        }
                                        if (name.equals("UnitTime")) {
                                            long timeInMiliSec = Long.parseLong(value.trim());
                                            if (timeInMiliSec == 0L) {
                                                ThrottlePolicyProcessor.handleException("Unit Time cannot find - invalid throttle policy configuration");
                                            }
                                            isFoundUnitTime = true;
                                            configuration.setUnitTimeInMiliSecond(timeInMiliSec);
                                            continue;
                                        }
                                        if (name.equals("ProhibitTimePeriod")) {
                                            configuration.setProhibitTimePeriod(Long.parseLong(value.trim()));
                                            continue;
                                        }
                                        ThrottlePolicyProcessor.handleException("Undefined Policy property for Throttle Policy");
                                        continue;
                                    }
                                    if (name.equals("ProhibitTimePeriod")) continue;
                                    ThrottlePolicyProcessor.handleException("The policy which have not defined as optional should have value ");
                                }
                                if (isFoundUnitTime && isFoundMaxCount) {
                                    isExactlyOneFound = true;
                                    continue;
                                }
                                ThrottlePolicyProcessor.handleException("Maximum Count and UnitTime are Mandatory in Throttle Policy ");
                                continue;
                            }
                            if (!(childAssertionObject instanceof XmlPrimtiveAssertion)) continue;
                            haveSelectOneFromExactlyOne = true;
                            XmlPrimtiveAssertion isAllowXmlPrimtiveAssertion = (XmlPrimtiveAssertion)childAssertionObject;
                            OMElement element = isAllowXmlPrimtiveAssertion.getValue();
                            String name = element.getLocalName();
                            String value = element.getText();
                            if (name == null || value == null) {
                                ThrottlePolicyProcessor.handleException("Either Value or Name of the policy cannot be null");
                                continue;
                            }
                            if (name.equals("IsAllow")) {
                                if (value.equals(Boolean.toString(true))) {
                                    isExactlyOneFound = true;
                                    configuration.setAccessState(2);
                                    continue;
                                }
                                if (value.equals(Boolean.toString(false))) {
                                    isExactlyOneFound = true;
                                    configuration.setAccessState(1);
                                    continue;
                                }
                                ThrottlePolicyProcessor.handleException("Value for isAllow policy component is invalied");
                                continue;
                            }
                            ThrottlePolicyProcessor.handleException("Invalied Throttle Policy configuration");
                        }
                    }
                }
                if (isIPRangeFound && isExactlyOneFound) {
                    throttleConfiguration.addCallerConfiguration(configuration);
                    continue;
                }
                ThrottlePolicyProcessor.handleException("ID and one of Valid Control policy component are Mandatory in Throttle Policy");
            }
        }
        return throttle;
    }

    private static void handleException(String messeage) throws ThrottleException {
        log.error((Object)messeage);
        throw new ThrottleException(messeage);
    }
}

