/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.impl.ipbase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.Caller;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;

public class IPBaseThrottleContext
implements ThrottleContext {
    private static Log log = LogFactory.getLog((String)IPBaseThrottleContext.class.getName());
    private TreeMap callersMap;
    private HashMap keyToTimeStampMap;
    private long nextCleanTime = 0L;
    final Object lock = new Object();
    private ThrottleConfiguration throttleConfiguration;

    public IPBaseThrottleContext(ThrottleConfiguration throttleConfiguration) {
        this.keyToTimeStampMap = new HashMap();
        this.callersMap = new TreeMap();
        this.throttleConfiguration = throttleConfiguration;
    }

    public ThrottleConfiguration getThrottleConfiguration() {
        return this.throttleConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Caller getCaller(Object ID) {
        String keyOfConfiguration = (String)this.throttleConfiguration.getConfigurationKeyOfCaller(ID);
        if (keyOfConfiguration != null) {
            Object object = this.lock;
            synchronized (object) {
                Object callerObject;
                Long timeKeyOfCallerContext = (Long)this.keyToTimeStampMap.get(keyOfConfiguration);
                if (timeKeyOfCallerContext != null && (callerObject = this.callersMap.get(timeKeyOfCallerContext)) != null) {
                    if (callerObject instanceof Caller) {
                        return (Caller)callerObject;
                    }
                    if (callerObject instanceof LinkedList) {
                        LinkedList callersWithSameTimeStampList = (LinkedList)callerObject;
                        Iterator iterator = callersWithSameTimeStampList.iterator();
                        while (iterator.hasNext()) {
                            Caller caller = (Caller)iterator.next();
                            if (!keyOfConfiguration.equals(this.throttleConfiguration.getConfigurationKeyOfCaller(caller.getID()))) continue;
                            return caller;
                        }
                    }
                }
            }
        }
        return null;
    }

    public void setThrottleConfiguration(ThrottleConfiguration throttleConfiguration) {
        this.throttleConfiguration = throttleConfiguration;
    }

    public void addCaller(Caller caller) {
        String keyOfConfiguration = (String)this.throttleConfiguration.getConfigurationKeyOfCaller(caller.getID());
        if (keyOfConfiguration != null) {
            this.setCaller(caller, keyOfConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCaller(Caller caller, String keyOfConfiguration) {
        Long time = new Long(caller.getNextTimeWindow());
        Object object = this.lock;
        synchronized (object) {
            if (!this.callersMap.containsKey(time)) {
                this.callersMap.put(time, caller);
            } else {
                LinkedList callersWithSameTimeStampList = null;
                Object callerObject = this.callersMap.get(time);
                if (callerObject != null) {
                    if (callerObject instanceof Caller) {
                        callersWithSameTimeStampList = new LinkedList();
                        callersWithSameTimeStampList.add(callerObject);
                        callersWithSameTimeStampList.add(caller);
                        this.callersMap.remove(time);
                    } else if (callerObject instanceof LinkedList) {
                        callersWithSameTimeStampList = (LinkedList)callerObject;
                        callersWithSameTimeStampList.add(caller);
                    }
                    if (callersWithSameTimeStampList != null) {
                        this.callersMap.put(time, callersWithSameTimeStampList);
                    }
                }
            }
            this.keyToTimeStampMap.put(keyOfConfiguration, time);
        }
    }

    public void removeCaller(Object ID) {
        if (ID instanceof Long) {
            this.removeCaller((Long)ID);
        } else {
            String keyOfConfiguration = (String)this.throttleConfiguration.getConfigurationKeyOfCaller(ID);
            if (keyOfConfiguration != null) {
                Long time = (Long)this.keyToTimeStampMap.get(keyOfConfiguration);
                this.removeCaller(time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCaller(Long key) {
        Object object = this.lock;
        synchronized (object) {
            this.callersMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCleanList(long currentTime) throws ThrottleException {
        Object object = this.lock;
        synchronized (object) {
            if (currentTime > this.nextCleanTime) {
                SortedMap sortedMap = this.callersMap.headMap(new Long(currentTime));
                if (sortedMap != null && sortedMap.size() > 0) {
                    Iterator callersIterator = sortedMap.values().iterator();
                    while (callersIterator.hasNext()) {
                        Object callerObject = callersIterator.next();
                        if (callerObject == null) continue;
                        if (callerObject instanceof Caller) {
                            Caller caller = (Caller)callerObject;
                            caller.canAccessIfUnitTimeOver(this.getThrottleConfiguration().getCallerConfiguration(caller.getID()), this, currentTime);
                            continue;
                        }
                        if (!(callerObject instanceof LinkedList)) continue;
                        LinkedList callersWithSameTimeStampList = (LinkedList)callerObject;
                        Iterator iterator = callersWithSameTimeStampList.iterator();
                        while (iterator.hasNext()) {
                            Caller caller = (Caller)iterator.next();
                            if (caller == null) continue;
                            caller.canAccessIfUnitTimeOver(this.getThrottleConfiguration().getCallerConfiguration(caller.getID()), this, currentTime);
                        }
                    }
                }
                this.nextCleanTime = currentTime + 300000L;
            }
        }
    }

    public int getType() {
        return 0;
    }
}

