/*
* Copyright 2005,2006 WSO2, Inc. http://wso2.com
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*
*/

package org.wso2.throttle;

import java.util.HashMap;

/**
 * The representation for Throttle-hold both runtime data and static data
 * There is a one to one releationship between configuration and context
 */

public class Throttle {

    /** Holder for ThrottleContext     */
    private HashMap throttleContexts;
    /** Holder for ThrottleConfigurations     */
    private HashMap throttleConfigurations;

    /**
     * Default Constructor
     */
    public Throttle() {
        throttleContexts = new HashMap();
        throttleConfigurations = new HashMap();
    }

    /**
     * To add a configuration
     *
     * @param key
     * @param throttleConfiguration
     */
    public void addThrottleConfiguration(String key, ThrottleConfiguration throttleConfiguration) {
        this.throttleConfigurations.put(key, throttleConfiguration);
    }

    /**
     * To add a context
     *
     * @param key
     * @param throttleContext
     */
    public void addThrottleContext(String key, ThrottleContext throttleContext) {
        this.throttleContexts.put(key, throttleContext);
    }

    /**
     * To get a ThrotleContext
     *
     * @param contextID
     * @return ThrottleContext
     */

    public ThrottleContext getThrottleContext(String contextID) {
        return (ThrottleContext) throttleContexts.get(contextID);
    }

    /**
     * To get a ThrottleConfiguration
     *
     * @param key
     * @return ThrottleConfiguration
     */
    public ThrottleConfiguration getThrottleConfiguration(String key) {
        return (ThrottleConfiguration) throttleConfigurations.get(key);
    }
}
