/*
* Copyright 2005,2006 WSO2, Inc. http://wso2.com
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*
*/

package org.wso2.throttle;

public interface ThrottleContext {

    /**
     * To set the ThrottleConfiguration- The static data corresspounding to this context
     *
     * @param throttleConfiguration
     */
    public void setThrottleConfiguration(ThrottleConfiguration throttleConfiguration);

    /**
     * To get the ThrottleConfiguration
     *
     * @return ThrottleConfiguration
     */
    public ThrottleConfiguration getThrottleConfiguration();

    /**
     * To add a Caller
     *
     * @param caller
     */
    public void addCaller(Caller caller);

    /**
     * To get a Caller
     *
     * @param ID
     * @return Caller
     */
    public Caller getCaller(Object ID);

    /**
     * To remove a Caller
     *
     * @param ID
     */
    public void removeCaller(Object ID);

    /**
     * To clean up callers(RunTime Data) according to current system time
     *
     * @param currentTime
     * @throws ThrottleException
     */
    public void processCleanList(long currentTime) throws ThrottleException;

    /**
     * To get the type of the throttle
     *
     * @return the type of the throttle
     */
    public int getType();


}
