/*
* Copyright 2005,2006 WSO2, Inc. http://www.wso2.org
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*
*/

package org.wso2.throttle;

import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.throttle.factory.CallerConfigurationFactory;
import org.wso2.throttle.factory.ThrottleConfigurationFactory;
import org.wso2.throttle.factory.ThrottleContextFactory;

import javax.xml.namespace.QName;
import java.util.Iterator;
import java.util.List;


/**
 * The class for processing policy that specify throttle configuration
 */

public class ThrottlePolicyProcessor {

    /**  Log for this class   */
    private static Log log = LogFactory.getLog(ThrottlePolicyProcessor.class.getName());


    /**
     * process policy and return IPBaseThrottleConfiguration object
     *
     * @param policy - policy for throttle
     * @return IPBaseThrottleConfiguration         - Bean object which holds Mata-Data about throttle
     * @throws ThrottleException
     *
     */

    public static Throttle processPolicy(Policy policy) throws ThrottleException {

        Throttle throttle = null;
        ThrottleConfiguration throttleConfiguration = null;
        if (policy == null) {
            //if policy is not available ,then return null for ThrottleConfiguration
            return null; // no pilicy is available in the module description
        }
        List topLevelAssertionList = policy.getPolicyComponents();
        for (Iterator topLevelAssertionsIterator = topLevelAssertionList.iterator();
             topLevelAssertionsIterator.hasNext();)
        {
            Object topLevelAssertionObject = topLevelAssertionsIterator.next();
            if (topLevelAssertionObject instanceof XmlPrimtiveAssertion) {
                XmlPrimtiveAssertion topLevelXmlPrimtiveAssertion = (XmlPrimtiveAssertion)
                        topLevelAssertionObject;
                QName qName = topLevelXmlPrimtiveAssertion.getName();
                if (qName.equals(ThrottleConstants.THROTTLE_ASSERTION_QNAME)) {
                    throttle = new Throttle();
                    Policy throtlePolicy = PolicyEngine.
                            getPolicy(topLevelXmlPrimtiveAssertion.getValue());
                    List assertionList = throtlePolicy.getPolicyComponents();

                    for (Iterator assertionsIterator = assertionList.iterator(); assertionsIterator.hasNext();)
                    {
                        Object allObject = assertionsIterator.next();
                        if (allObject instanceof All) {

                            // boolean isOtherConfiguration = false;
                            //  // To track default configuration for all ips
                            CallerConfiguration configuration = null; // To create a
                            //configurationbean object
                            boolean isIPRangeFound = false;
                            boolean isExactlyOneFound = false;
                            List configDataAssertionList = ((All) allObject).getAssertions();
                            if (configDataAssertionList != null) {
                                for (Iterator configDataAssertionIterator =
                                        configDataAssertionList.iterator(); configDataAssertionIterator.hasNext();)
                                {
                                    Object aConfigDataAssertionObject = configDataAssertionIterator.next();
                                    if (aConfigDataAssertionObject instanceof XmlPrimtiveAssertion)
                                    {
                                        XmlPrimtiveAssertion idPrimitiveAssertion = (XmlPrimtiveAssertion) aConfigDataAssertionObject;
                                        OMElement element = idPrimitiveAssertion.getValue();

                                        String throttleType = element.getAttributeValue(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME);
                                        if (throttleType == null) {
                                            handleException("Type of Throtle in the policy cannot be null");
                                        }
                                        if (throttleType.equals("IP")) {
                                            throttleConfiguration = throttle.getThrottleConfiguration(ThrottleConstants.IP_BASED_THROTTLE_KEY);
                                            if (throttleConfiguration == null) {
                                                throttleConfiguration = ThrottleConfigurationFactory.createThrottleConfiguration(ThrottleConstants.IP_BASE);
                                                throttle.addThrottleContext(ThrottleConstants.IP_BASED_THROTTLE_KEY,
                                                        ThrottleContextFactory.createThrottleContext(ThrottleConstants.IP_BASE, throttleConfiguration));
                                                throttle.addThrottleConfiguration(ThrottleConstants.IP_BASED_THROTTLE_KEY, throttleConfiguration);
                                            }
                                            configuration = CallerConfigurationFactory.createCallerConfiguration(ThrottleConstants.IP_BASE);
                                        }
                                        // Name of the policy assertion
                                        String name = element.getLocalName();
                                        // Value of the policy assertion
                                        String value = element.getText();

                                        // If Value and Name name are null,then it is a invalid policy configuration
                                        if (name == null || value == null) {
                                            handleException("Either Value or Name of the policy cannot be null");
                                        } else
                                        if (name.equals(ThrottleConstants.ID_PARAMETER_NAME)) {

                                            if (!value.equals("")) {

                                                isIPRangeFound = true;
                                                configuration.setID(value);
                                            } else {
                                                handleException("Value of ID cannot find - invalid configuration");
                                            }
                                        } else {
                                            handleException("Undefined pocilcy property for throttle - Expect ID  ");
                                        }

                                    } else if (aConfigDataAssertionObject instanceof ExactlyOne) {

                                        ExactlyOne exactlyOne = (ExactlyOne) aConfigDataAssertionObject;
                                        List childAssertionsList = exactlyOne.getPolicyComponents();
                                        boolean haveSelectOneFromExactlyOne = false;
                                        for (Iterator childAssertionSIterator = childAssertionsList.iterator(); childAssertionSIterator.hasNext() && !haveSelectOneFromExactlyOne;)
                                        {
                                            Object childAssertionObject = childAssertionSIterator.next();
                                            if (childAssertionObject instanceof All) {
                                                haveSelectOneFromExactlyOne = true;
                                                boolean isFoundMaxCount = false;
                                                boolean isFoundUnitTime = false;
                                                All childAll = (All) childAssertionObject;
                                                List aConfigDataAssertionList = childAll.getPolicyComponents();
                                                for (Iterator aConfigDataAssertionsIterator = aConfigDataAssertionList.iterator(); aConfigDataAssertionsIterator.hasNext();)
                                                {
                                                    Object aOneOfConfigDataAssertions = aConfigDataAssertionsIterator.next();
                                                    if (aOneOfConfigDataAssertions instanceof XmlPrimtiveAssertion)
                                                    {
                                                        XmlPrimtiveAssertion aOneOfConfigDataPrimitiveAssertion = (XmlPrimtiveAssertion) aOneOfConfigDataAssertions;
                                                        OMElement element = aOneOfConfigDataPrimitiveAssertion.getValue();
                                                        // Name of the policy assertion
                                                        String name = element.getLocalName();
                                                        //Value of the policy assertion
                                                        String value = element.getText();

                                                        //if Value and Name name are null,then it is a invalid policy configuration
                                                        if (name == null || value == null) {
                                                            handleException("Either Value or Name of the policy cannot be null");
                                                        }
                                                        if (!value.equals("")) {

                                                            if (name.equals(ThrottleConstants.MAXIMUM_COUNT_PARAMETER_NAME))
                                                            {
                                                                isFoundMaxCount = true;
                                                                configuration.setMaximumRequestPerUnitTime(Integer.parseInt(value.trim()));

                                                            } else
                                                            if (name.equals(ThrottleConstants.UNIT_TIME_PARAMETER_NAME))
                                                            {
                                                                //TODO need to verify that value is milisecond
                                                                long timeInMiliSec = Long.parseLong(value.trim());
                                                                if (timeInMiliSec == 0) {
                                                                    handleException("Unit Time cannot find - invalid throttle policy configuration");
                                                                }
                                                                isFoundUnitTime = true;
                                                                configuration.setUnitTimeInMiliSecond(timeInMiliSec);

                                                            } else
                                                            if (name.equals(ThrottleConstants.PROHIBIT_TIME_PERIOD_PARAMETER_NAME))
                                                            {
                                                                configuration.setProhibitTimePeriod(Long.parseLong(value.trim()));

                                                            } else {
                                                                handleException("Undefined Policy property for Throttle Policy");
                                                            }
                                                        } else {
                                                            if (!name.equals(ThrottleConstants.PROHIBIT_TIME_PERIOD_PARAMETER_NAME))
                                                            {
                                                                handleException("The policy which have not defined as optional should have value ");
                                                            }
                                                        }
                                                    }
                                                }
                                                if (isFoundUnitTime && isFoundMaxCount) {
                                                    isExactlyOneFound = true;
                                                } else {
                                                    handleException("Maximum Count and UnitTime are Mandatory in Throttle Policy ");

                                                }
                                            } else
                                            if (childAssertionObject instanceof XmlPrimtiveAssertion)
                                            {
                                                haveSelectOneFromExactlyOne = true;
                                                XmlPrimtiveAssertion isAllowXmlPrimtiveAssertion = (XmlPrimtiveAssertion) childAssertionObject;
                                                OMElement element = isAllowXmlPrimtiveAssertion.getValue();
                                                // Name of the policy assertion
                                                String name = element.getLocalName();
                                                //Value of the policy assertion
                                                String value = element.getText();

                                                //if Value and Name name are null,then it is a invalid policy configuration
                                                if (name == null || value == null) {
                                                    handleException("Either Value or Name of the policy cannot be null");
                                                } else
                                                if (name.equals(ThrottleConstants.ISALLOW_PARAMETER_NAME))
                                                {
                                                    if (value.equals(Boolean.toString(true))) {
                                                        isExactlyOneFound = true;
                                                        configuration.setAccessState(ThrottleConstants.ACCESS_ALLOWED);
                                                    } else
                                                    if (value.equals(Boolean.toString(false))) {
                                                        isExactlyOneFound = true;
                                                        configuration.setAccessState(ThrottleConstants.ACCESS_DENIED);
                                                    } else {
                                                        handleException("Value for isAllow policy component is invalied");
                                                    }
                                                } else {
                                                    handleException("Invalied Throttle Policy configuration");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (isIPRangeFound && isExactlyOneFound)
                            {// If the Throttle Configuration is valid
                                throttleConfiguration.addCallerConfiguration(configuration);
                            } else {
                                handleException("ID and one of Valid Control policy component are Mandatory in Throttle Policy");
                            }
                        }
                    }
                }
            }
        }
        return throttle;
    }

    /**
     * Helper method to handle exception
     *
     * @param messeage
     * @throws ThrottleException
     */
    private static void handleException(String messeage) throws ThrottleException {
        log.error(messeage);
        throw new ThrottleException(messeage);
    }

}
