/*
* Copyright 2004,2005 The Apache Software Foundation.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.wso2.throttle.factory;

import org.wso2.throttle.Caller;
import org.wso2.throttle.ThrottleConstants;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.impl.ipbase.IPBaseCaller;

/**
 *
 *
 */

public class CallerFactory {

    /**
     * To create a Caller
     *
     * @param throttletype - the type of the throttle
     * @param id           - the id of the caller
     * @return caller
     * @throws ThrottleException
     */
    public static Caller createCaller(int throttletype, Object id) throws ThrottleException {
        if (ThrottleConstants.IP_BASE == throttletype) {
            return new IPBaseCaller(id);
        } else {
            throw new ThrottleException("unknown throttle type");
        }
    }
}
