/*
* Copyright 2005,2006 WSO2, Inc. http://www.wso2.org
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*
*/

package org.wso2.throttle.impl.ipbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleConstants;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class IPBaseThrottleConfiguration implements Serializable, ThrottleConfiguration {

    /** Log for this class   */
    private static Log log = LogFactory.getLog(IPBaseThrottleConfiguration.class.getName());
    /** The key for Other configuration     */
    private String keyOfOther;
    /** The default configuration for a throttle and this will apply to callersMap that have not a custom configuration   */
    private CallerConfiguration defaultCallerConfiguration;
    /** To hold configurations   */
    private TreeMap configurationsMap;
    /**
     * The Deault Constructor for Throttle Bean
     */
    public IPBaseThrottleConfiguration() {
        this.configurationsMap = new TreeMap();
    }

    /**
     * To get a IPBaseCallerConfiguration
     *
     * @param ID
     * @return IPBaseCallerConfiguration
     */
    public CallerConfiguration getCallerConfiguration(Object ID) {

        if (ID.equals(ThrottleConstants.KEY_OF_DEFAULT_CONFIGURATION_FOR_OTHER)) {
            return defaultCallerConfiguration;
        } else {
            String key = (String) getConfigurationKeyOfCaller(ID);
            if (key != null) {
                if (key.equals(ThrottleConstants.KEY_OF_DEFAULT_CONFIGURATION_FOR_OTHER)) {
                    return defaultCallerConfiguration;
                }
                return (IPBaseCallerConfiguration) configurationsMap.get(key);
            }
        }
        return null;
    }

    /**
     * To get map of configurations
     *
     * @return TreeMap
     */
    public TreeMap getConfigurations() {
        return this.configurationsMap;
    }


    /**
     * To set map of configurations
     *
     * @param map
     */
    public void setConfigurations(TreeMap map) {
        this.configurationsMap = map;
    }

    /**
     * To add a IPBaseCallerConfiguration
     *
     * @param configuration
     */
    public void addCallerConfiguration(CallerConfiguration configuration) {
        //TODO need to enable overlapping of ip with FirstPartOfIPRange
        IPBaseCallerConfiguration ipBaseCallerConfiguration = (IPBaseCallerConfiguration) configuration;
        String key = ipBaseCallerConfiguration.getFirstPartOfIPRange();
        if (key.equals(ThrottleConstants.KEY_OF_DEFAULT_CONFIGURATION_FOR_OTHER)) {
            keyOfOther = ThrottleConstants.KEY_OF_DEFAULT_CONFIGURATION_FOR_OTHER;
            defaultCallerConfiguration = ipBaseCallerConfiguration;
        } else {
            configurationsMap.put(key, ipBaseCallerConfiguration);
        }
    }

    /**
     * To get key for access configuration
     *
     * @param callerID
     * @return Object-String representation of  corrected epr-key for get configuration
     */
    public Object getConfigurationKeyOfCaller(Object callerID) {
        String ip = (String) callerID;
        //if there is a unique IP
        if (configurationsMap.containsKey(ip)) {
            return ip;
        } else {
            //if ip contains in group iprange
            SortedMap map = configurationsMap.headMap(ip);
            if (map != null && map.size() > 0) {
                for (Iterator iterator = map.values().iterator(); iterator.hasNext();) {
                    IPBaseCallerConfiguration ipBaseCallerConfiguration = (IPBaseCallerConfiguration) iterator.next();
                    if (ipBaseCallerConfiguration.getSecondPartOfIPRange() != null && ipBaseCallerConfiguration.getSecondPartOfIPRange().compareTo(ip) > 0)
                        return ipBaseCallerConfiguration.getFirstPartOfIPRange();
                }

            }
        }
        return keyOfOther;
    }

    public int getType() {
        return ThrottleConstants.IP_BASE;
    }

}
